/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.app;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.AbstractContextual;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.app.event.StatusEvent;
import org.scijava.event.EventHandler;
import org.scijava.plugin.Parameter;

public class DefaultStatusServiceTest {
    private Context context;
    private StatusListener statusListener;
    private BlockingQueue<StatusEvent> queue;
    private StatusService statusService;

    @Before
    public void setUp() throws Exception {
        this.context = new Context();
        this.queue = new ArrayBlockingQueue<StatusEvent>(10);
        this.statusListener = new StatusListener();
        this.statusListener.setContext(this.context);
        this.statusService = this.statusListener.statusService;
    }

    @Test
    public void testShowProgress() {
        this.statusService.showProgress(15, 45);
        try {
            StatusEvent event = this.queue.poll(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)event.getProgressValue(), (long)15L);
            Assert.assertEquals((long)event.getProgressMaximum(), (long)45L);
            Assert.assertFalse((boolean)event.isWarning());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testShowStatusString() {
        String text = "Hello, world";
        this.statusService.showStatus("Hello, world");
        try {
            StatusEvent event = this.queue.poll(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)event.getStatusMessage(), (Object)"Hello, world");
            Assert.assertFalse((boolean)event.isWarning());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testShowStatusIntIntString() {
        String text = "Working...";
        this.statusService.showStatus(25, 55, "Working...");
        try {
            StatusEvent event = this.queue.poll(10L, TimeUnit.SECONDS);
            Assert.assertEquals((long)event.getProgressValue(), (long)25L);
            Assert.assertEquals((long)event.getProgressMaximum(), (long)55L);
            Assert.assertEquals((Object)event.getStatusMessage(), (Object)"Working...");
            Assert.assertFalse((boolean)event.isWarning());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testWarn() {
        String text = "Totally hosed";
        this.statusService.warn("Totally hosed");
        try {
            StatusEvent event = this.queue.poll(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)event.getStatusMessage(), (Object)"Totally hosed");
            Assert.assertTrue((boolean)event.isWarning());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testShowStatusIntIntStringBoolean() {
        String text = "Working and hosed...";
        this.statusService.showStatus(33, 44, "Working and hosed...", true);
        try {
            StatusEvent event = this.queue.poll(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)event.getStatusMessage(), (Object)"Working and hosed...");
            Assert.assertEquals((long)event.getProgressValue(), (long)33L);
            Assert.assertEquals((long)event.getProgressMaximum(), (long)44L);
            Assert.assertTrue((boolean)event.isWarning());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testClearStatus() {
        this.statusService.clearStatus();
        try {
            StatusEvent event = this.queue.poll(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)event.getStatusMessage(), (Object)"");
            Assert.assertFalse((boolean)event.isWarning());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    private class StatusListener
    extends AbstractContextual {
        @Parameter
        private StatusService statusService;

        private StatusListener() {
        }

        @EventHandler
        private void eventHandler(StatusEvent e) {
            try {
                DefaultStatusServiceTest.this.queue.put(new StatusEvent(e.getProgressValue(), e.getProgressMaximum(), e.getStatusMessage(), e.isWarning()));
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
                Assert.fail();
            }
        }
    }
}

