/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.location;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationResolver;
import org.scijava.plugin.HandlerService;
import org.scijava.service.SciJavaService;

public interface LocationService
extends HandlerService<URI, LocationResolver>,
SciJavaService {
    default public Location resolve(String uriString) throws URISyntaxException {
        return this.resolve(new URI(uriString));
    }

    default public Location resolve(URI uri) throws URISyntaxException {
        LocationResolver resolver;
        if (uri.getScheme() == null) {
            uri = new File(uri.getPath()).toURI();
        }
        return (resolver = this.getResolver(uri)) != null ? resolver.resolve(uri) : null;
    }

    public LocationResolver getResolver(URI var1);

    @Override
    default public Class<LocationResolver> getPluginType() {
        return LocationResolver.class;
    }

    @Override
    default public Class<URI> getType() {
        return URI.class;
    }
}

