/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.convert.FileListConverters;

public class FileListConverterTest {
    @Test
    public void testStringToFileConverter() {
        FileListConverters.StringToFileConverter conv = new FileListConverters.StringToFileConverter();
        String path = "C:\\temp\\f,i;l-ename.txt";
        Assert.assertTrue((String)"Cannot convert from String to File", (boolean)conv.canConvert(String.class, File.class));
        Assert.assertFalse((String)"Can erroneously convert from String to File[]", (boolean)conv.canConvert(String.class, File[].class));
        Assert.assertEquals((Object)new File("C:\\temp\\f,i;l-ename.txt"), (Object)conv.convert((Object)"C:\\temp\\f,i;l-ename.txt", File.class));
    }

    @Test
    public void testStringToFileArrayConverter() {
        FileListConverters.StringToFileArrayConverter conv = new FileListConverters.StringToFileArrayConverter();
        String path = "\"C:\\temp\\f,i;l-ename.txt\",C:\\temp";
        Assert.assertTrue((String)"Cannot convert from String to File[]", (boolean)conv.canConvert(String.class, File[].class));
        Assert.assertFalse((String)"Can erroneously convert from String to File", (boolean)conv.canConvert(String.class, File.class));
        Assert.assertEquals((String)"Wrong array length", (long)2L, (long)((File[])conv.convert((Object)"\"C:\\temp\\f,i;l-ename.txt\",C:\\temp", File[].class)).length);
        Assert.assertEquals((String)"Wrong file name", (Object)new File("C:\\temp\\f,i;l-ename.txt"), (Object)((File[])conv.convert((Object)"\"C:\\temp\\f,i;l-ename.txt\",C:\\temp", File[].class))[0]);
        Assert.assertEquals((String)"Wrong file name", (Object)new File("C:\\temp"), (Object)((File[])conv.convert((Object)"\"C:\\temp\\f,i;l-ename.txt\",C:\\temp", File[].class))[1]);
    }

    @Test
    public void testFileToStringConverter() {
        FileListConverters.FileToStringConverter conv = new FileListConverters.FileToStringConverter();
        File file = new File("C:\\temp\\f,i;l-ename.txt");
        Assert.assertTrue((String)"Cannot convert from File to String", (boolean)conv.canConvert(File.class, String.class));
        Assert.assertFalse((String)"Can erroneously convert from File[] to String", (boolean)conv.canConvert(File[].class, String.class));
        Assert.assertEquals((Object)file.getAbsolutePath(), (Object)conv.convert((Object)file, String.class));
    }

    @Test
    public void testFileArrayToStringConverter() {
        FileListConverters.FileArrayToStringConverter conv = new FileListConverters.FileArrayToStringConverter();
        File[] fileArray = new File[]{new File("C:\\temp\\f,i;l-ename.txt"), new File("C:\\temp")};
        String expected = "\"" + fileArray[0].getAbsolutePath() + "\"," + fileArray[1].getAbsolutePath();
        Assert.assertTrue((String)"Cannot convert from File[] to String", (boolean)conv.canConvert(File[].class, String.class));
        Assert.assertFalse((String)"Can erroneously convert from File to String", (boolean)conv.canConvert(File.class, String.class));
        Assert.assertEquals((String)"Wrong output string", (Object)expected, (Object)conv.convert((Object)fileArray, String.class));
    }
}

