/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.module.AbstractModule;
import org.scijava.module.AbstractModuleInfo;
import org.scijava.module.AbstractModuleItem;
import org.scijava.module.Module;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.module.ModuleService;

public class ModuleServiceTest {
    private ModuleService moduleService;

    @Before
    public void setUp() {
        Context context = new Context(new Class[]{ModuleService.class});
        this.moduleService = (ModuleService)context.service(ModuleService.class);
    }

    @After
    public void tearDown() {
        this.moduleService.context().dispose();
    }

    @Test
    public void testRunModuleInfoArray() throws InterruptedException, ExecutionException {
        FooModuleInfo info = new FooModuleInfo();
        Module m = (Module)this.moduleService.run((ModuleInfo)info, false, this.createInputArray()).get();
        Assert.assertEquals((Object)this.expectedResult(), (Object)m.getOutput("result"));
    }

    @Test
    public void testRunModuleInfoMap() throws InterruptedException, ExecutionException {
        FooModuleInfo info = new FooModuleInfo();
        Module m = (Module)this.moduleService.run((ModuleInfo)info, false, this.createInputMap()).get();
        Assert.assertEquals((Object)this.expectedResult(), (Object)m.getOutput("result"));
    }

    @Test
    public void testRunModuleArray() throws ModuleException, InterruptedException, ExecutionException {
        FooModuleInfo info = new FooModuleInfo();
        Module module = info.createModule();
        Module m = (Module)this.moduleService.run(module, false, this.createInputArray()).get();
        Assert.assertSame((Object)module, (Object)m);
        Assert.assertEquals((Object)this.expectedResult(), (Object)m.getOutput("result"));
    }

    @Test
    public void testRunModuleMap() throws ModuleException, InterruptedException, ExecutionException {
        FooModuleInfo info = new FooModuleInfo();
        Module module = info.createModule();
        Module m = (Module)this.moduleService.run(module, false, this.createInputMap()).get();
        Assert.assertSame((Object)module, (Object)m);
        Assert.assertEquals((Object)this.expectedResult(), (Object)m.getOutput("result"));
    }

    @Test
    public void testRunMapHack() throws ModuleException, InterruptedException, ExecutionException {
        FooModuleInfo info = new FooModuleInfo();
        Object[] inputs = new Object[]{this.createInputMap()};
        Module m = (Module)this.moduleService.run((ModuleInfo)info, false, inputs).get();
        Assert.assertEquals((Object)this.expectedResult(), (Object)m.getOutput("result"));
        Module module = info.createModule();
        Module m2 = (Module)this.moduleService.run(module, false, inputs).get();
        Assert.assertEquals((Object)this.expectedResult(), (Object)m2.getOutput("result"));
    }

    @Test
    public void testGetSingleInput() throws ModuleException {
        FooModuleInfo info = new FooModuleInfo();
        Module module = info.createModule();
        ModuleItem singleString = this.moduleService.getSingleInput(module, String.class);
        Assert.assertSame((Object)info.getInput("string"), (Object)singleString);
        ModuleItem singleFloat = this.moduleService.getSingleInput(module, Float.class);
        Assert.assertNull((Object)singleFloat);
        ModuleItem singleInteger = this.moduleService.getSingleInput(module, Integer.class);
        Assert.assertNull((Object)singleInteger);
        ModuleItem singleDouble = this.moduleService.getSingleInput(module, Double.class);
        Assert.assertSame((Object)info.getInput("double2"), (Object)singleDouble);
    }

    private Object[] createInputArray() {
        return new Object[]{"string", "hello", "float", Float.valueOf(1.234f), "integer1", -2, "integer2", 7, "double1", Math.E, "double2", Math.PI};
    }

    private Map<String, Object> createInputMap() {
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        inputMap.put("string", "hello");
        inputMap.put("float", Float.valueOf(1.234f));
        inputMap.put("integer1", -2);
        inputMap.put("integer2", 7);
        inputMap.put("double1", Math.E);
        inputMap.put("double2", Math.PI);
        return inputMap;
    }

    private String expectedResult() {
        return ModuleServiceTest.mapToString(this.createInputMap());
    }

    private static String mapToString(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append(entry.getKey() + " = " + entry.getValue() + "\n");
        }
        return sb.toString();
    }

    public static class FooModuleInfo
    extends AbstractModuleInfo {
        public String getDelegateClassName() {
            return FooModule.class.getName();
        }

        public Class<?> loadDelegateClass() throws ClassNotFoundException {
            return FooModule.class;
        }

        public Module createModule() throws ModuleException {
            return new FooModule(this);
        }

        protected void parseParameters() {
            this.addInput("string", String.class, true);
            this.addInput("float", Float.class, false);
            this.addInput("integer1", Integer.class, true);
            this.addInput("integer2", Integer.class, true);
            this.addInput("double1", Double.class, false);
            this.addInput("double2", Double.class, true);
            this.addOutput("result", String.class);
        }

        private <T> void addInput(final String name, final Class<T> type, final boolean autoFill) {
            this.registerInput((ModuleItem)new AbstractModuleItem<T>((ModuleInfo)this){

                public String getName() {
                    return name;
                }

                public Class<T> getType() {
                    return type;
                }

                public boolean isAutoFill() {
                    return autoFill;
                }
            });
        }

        private <T> void addOutput(final String name, final Class<T> type) {
            this.registerOutput((ModuleItem)new AbstractModuleItem<T>((ModuleInfo)this){

                public String getName() {
                    return name;
                }

                public Class<T> getType() {
                    return type;
                }
            });
        }
    }

    public static class FooModule
    extends AbstractModule {
        private final FooModuleInfo info;

        public FooModule(FooModuleInfo info) {
            this.info = info;
        }

        public ModuleInfo getInfo() {
            return this.info;
        }

        public void run() {
            this.setOutput("result", ModuleServiceTest.mapToString(this.getInputs()));
        }
    }
}

