/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugin;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.InstantiableException;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginIndex;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.SciJavaPlugin;

public class PluginInfoTest {
    private Context context;
    private PluginIndex pluginIndex;

    @Before
    public void setUp() {
        this.context = new Context(true);
        this.pluginIndex = this.context.getPluginIndex();
    }

    @After
    public void tearDown() {
        this.context.dispose();
        this.context = null;
        this.pluginIndex = null;
    }

    @Test
    public void testNames() throws InstantiableException {
        List infos = this.pluginIndex.get(IceCream.class);
        Assert.assertEquals((long)3L, (long)infos.size());
        this.assertPlugin(Chocolate.class, IceCream.class, "chocolate", (PluginInfo)infos.get(0));
        this.assertPlugin(Vanilla.class, IceCream.class, "vanilla", (PluginInfo)infos.get(1));
        this.assertPlugin(Flavorless.class, IceCream.class, "", (PluginInfo)infos.get(2));
    }

    @Test
    public void testGet() throws InstantiableException {
        PluginInfo chocolateInfo = PluginInfo.get(Chocolate.class, (PluginIndex)this.pluginIndex);
        this.assertPlugin(Chocolate.class, IceCream.class, "chocolate", chocolateInfo);
        PluginInfo chocolateInfoWithType = PluginInfo.get(Chocolate.class, IceCream.class, (PluginIndex)this.pluginIndex);
        Assert.assertSame((Object)chocolateInfo, (Object)chocolateInfoWithType);
        class Sherbet
        implements IceCream {
            Sherbet() {
            }
        }
        Assert.assertNull((Object)PluginInfo.get(Sherbet.class, (PluginIndex)this.pluginIndex));
    }

    @Test
    public void testCreate() throws InstantiableException {
        PluginInfo chocolateInfo = PluginInfo.create(Chocolate.class);
        this.assertPlugin(Chocolate.class, IceCream.class, "chocolate", chocolateInfo);
        PluginInfo chocolateInfoWithType = PluginInfo.create(Chocolate.class, IceCream.class);
        this.assertPlugin(Chocolate.class, IceCream.class, "chocolate", chocolateInfoWithType);
        Assert.assertNotSame((Object)chocolateInfo, (Object)chocolateInfoWithType);
        class Sherbet
        implements IceCream {
            Sherbet() {
            }
        }
        PluginInfo sherbetInfoWithType = PluginInfo.create(Sherbet.class, IceCream.class);
        this.assertPlugin(Sherbet.class, IceCream.class, null, sherbetInfoWithType);
        try {
            PluginInfo result = PluginInfo.create(Sherbet.class);
            Assert.fail((String)("Expected IllegalArgumentException but got: " + result));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetOrCreate() throws InstantiableException {
        PluginInfo chocolateInfo = PluginInfo.getOrCreate(Chocolate.class, (PluginIndex)this.pluginIndex);
        this.assertPlugin(Chocolate.class, IceCream.class, "chocolate", chocolateInfo);
        PluginInfo chocolateInfoWithType = PluginInfo.getOrCreate(Chocolate.class, IceCream.class, (PluginIndex)this.pluginIndex);
        Assert.assertSame((Object)chocolateInfo, (Object)chocolateInfoWithType);
        class Sherbet
        implements IceCream {
            Sherbet() {
            }
        }
        PluginInfo sherbetInfoWithType = PluginInfo.getOrCreate(Sherbet.class, IceCream.class, (PluginIndex)this.pluginIndex);
        this.assertPlugin(Sherbet.class, IceCream.class, null, sherbetInfoWithType);
        try {
            PluginInfo result = PluginInfo.getOrCreate(Sherbet.class, (PluginIndex)this.pluginIndex);
            Assert.fail((String)("Expected IllegalArgumentException but got: " + result));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertPlugin(Class<?> pluginClass, Class<?> pluginType, String name, PluginInfo<?> info) throws InstantiableException {
        Assert.assertNotNull(info);
        Assert.assertSame(pluginClass, (Object)info.loadClass());
        Assert.assertSame(pluginType, (Object)info.getPluginType());
        Assert.assertEquals((Object)name, (Object)info.getName());
    }

    @Plugin(type=IceCream.class, name="chocolate", priority=10000.0)
    public static class Chocolate
    implements IceCream {
    }

    @Plugin(type=IceCream.class, name="vanilla", priority=-100.0)
    public static class Vanilla
    implements SciJavaPlugin {
    }

    @Plugin(type=IceCream.class, priority=-10000.0)
    public static class Flavorless
    implements SciJavaPlugin {
    }

    public static interface IceCream
    extends SciJavaPlugin {
    }
}

