/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.parse;

import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.parse.Item;
import org.scijava.parse.Items;
import org.scijava.parse.ParseService;

public class ParseServiceTest {
    private ParseService parser;

    @Before
    public void setUp() {
        Context context = new Context(new Class[]{ParseService.class});
        this.parser = (ParseService)context.service(ParseService.class);
    }

    @After
    public void tearDown() {
        this.parser.getContext().dispose();
    }

    @Test
    public void testEmpty() {
        Items items = this.parser.parse("");
        Assert.assertTrue((boolean)items.isEmpty());
        Assert.assertTrue((boolean)items.isList());
        Assert.assertTrue((boolean)items.isMap());
        this.assertMapCorrect(items);
    }

    @Test
    public void testList() {
        Items items = this.parser.parse("1,2,3,4,5");
        Assert.assertEquals((long)5L, (long)items.size());
        Assert.assertTrue((boolean)items.isList());
        Assert.assertFalse((boolean)items.isMap());
        Assert.assertSame((Object)1, (Object)((Item)items.get(0)).value());
        Assert.assertSame((Object)2, (Object)((Item)items.get(1)).value());
        Assert.assertSame((Object)3, (Object)((Item)items.get(2)).value());
        Assert.assertSame((Object)4, (Object)((Item)items.get(3)).value());
        Assert.assertSame((Object)5, (Object)((Item)items.get(4)).value());
        Assert.assertNull((Object)((Item)items.get(0)).name());
        Assert.assertNull((Object)((Item)items.get(1)).name());
        Assert.assertNull((Object)((Item)items.get(2)).name());
        Assert.assertNull((Object)((Item)items.get(3)).name());
        Assert.assertNull((Object)((Item)items.get(4)).name());
    }

    @Test
    public void testMap() {
        Items items = this.parser.parse("foo='bar', animal='Quick brown fox', colors={'red', 'green', 'blue'}");
        Assert.assertEquals((long)3L, (long)items.size());
        Assert.assertFalse((boolean)items.isList());
        Assert.assertTrue((boolean)items.isMap());
        Assert.assertEquals((Object)"foo", (Object)((Item)items.get(0)).name());
        Assert.assertEquals((Object)"bar", (Object)((Item)items.get(0)).value());
        Assert.assertEquals((Object)"animal", (Object)((Item)items.get(1)).name());
        Assert.assertEquals((Object)"Quick brown fox", (Object)((Item)items.get(1)).value());
        Assert.assertEquals((Object)"colors", (Object)((Item)items.get(2)).name());
        Object colors = ((Item)items.get(2)).value();
        Assert.assertTrue((boolean)(colors instanceof List));
        List colorsList = (List)colors;
        Assert.assertEquals((long)3L, (long)colorsList.size());
        Assert.assertEquals((Object)"red", colorsList.get(0));
        Assert.assertEquals((Object)"green", colorsList.get(1));
        Assert.assertEquals((Object)"blue", colorsList.get(2));
        this.assertMapCorrect(items);
    }

    private void assertMapCorrect(Items items) {
        Map map = items.asMap();
        Assert.assertEquals((long)items.size(), (long)map.size());
        for (Item item : items) {
            Assert.assertSame((Object)item.value(), map.get(item.name()));
        }
        int index = 0;
        for (Object value : map.values()) {
            Assert.assertSame((String)("" + index + ":"), (Object)((Item)items.get(index++)).value(), value);
        }
    }
}

