/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.plugin.Plugin;
import org.scijava.script.AbstractScriptEngine;
import org.scijava.script.AbstractScriptLanguage;
import org.scijava.script.AutoCompleter;
import org.scijava.script.AutoCompletionResult;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptModule;
import org.scijava.script.ScriptService;

public class ScriptEngineTest {
    private Context context;
    private ScriptService scriptService;

    @Before
    public void setUp() {
        this.context = new Context(new Class[]{ScriptService.class});
        this.scriptService = (ScriptService)this.context.getService(ScriptService.class);
    }

    @After
    public void tearDown() {
        this.context.dispose();
        this.context = null;
        this.scriptService = null;
    }

    @Test
    public void testRot13() throws Exception {
        ScriptLanguage hello = this.scriptService.getLanguageByName("Hello");
        Assert.assertNotNull((Object)hello);
        ScriptLanguage rot13 = this.scriptService.getLanguageByName("Rot13");
        Assert.assertEquals((Object)hello, (Object)rot13);
        Assert.assertEquals((Object)"Svool", (Object)rot13.getScriptEngine().eval("Hello"));
    }

    @Test
    public void testScriptModuleValue() throws Exception {
        ScriptModule module = (ScriptModule)this.scriptService.run("test.rot13", ScriptModule.class.getName(), false, (Map)null).get();
        ScriptModule scriptModule = Rot13Engine.latestModule;
        Assert.assertEquals((Object)module, (Object)scriptModule);
        Assert.assertNotNull((Object)scriptModule);
        ScriptInfo info = scriptModule.getInfo();
        Assert.assertEquals((Object)this.context, (Object)info.context());
    }

    @Test
    public void testAutoCompleter() {
        ScriptLanguage hello = this.scriptService.getLanguageByName("Hello");
        ScriptEngine engine = hello.getScriptEngine();
        AutoCompleter ac = hello.getAutoCompleter();
        engine.put("thing", new Object());
        AutoCompletionResult result = ac.autocomplete("thing.", engine);
        Assert.assertEquals((long)0L, (long)result.getStartIndex());
        List matches = result.getMatches();
        List<String> expected = Arrays.asList("thing.equals(", "thing.getClass(", "thing.hashCode(", "thing.notify(", "thing.notifyAll(", "thing.toString(", "thing.wait(");
        Assert.assertEquals((Object)matches, expected);
        engine.put("hello", "world");
        AutoCompletionResult cWords = ac.autocomplete("hello.c", engine);
        Assert.assertEquals((long)0L, (long)cWords.getStartIndex());
        List cMatches = cWords.getMatches();
        List<String> cExpected = Arrays.asList("hello.CASE_INSENSITIVE_ORDER", "hello.charAt(", "hello.chars(", "hello.codePointAt(", "hello.codePointBefore(", "hello.codePointCount(", "hello.codePoints(", "hello.compareTo(", "hello.compareToIgnoreCase(", "hello.concat(", "hello.contains(", "hello.contentEquals(", "hello.copyValueOf(");
        Assert.assertEquals((Object)cMatches, cExpected);
    }

    private static class Rot13Bindings
    extends HashMap<String, Object>
    implements Bindings {
        private static final long serialVersionUID = 1L;

        private Rot13Bindings() {
        }
    }

    private static class Rot13Engine
    extends AbstractScriptEngine {
        private static ScriptModule latestModule;

        private Rot13Engine() {
            this.engineScopeBindings = new Rot13Bindings();
        }

        public Object eval(String script) throws ScriptException {
            return this.eval(new StringReader(script));
        }

        public Object eval(Reader reader) throws ScriptException {
            latestModule = (ScriptModule)this.get(ScriptModule.class.getName());
            StringBuilder builder = new StringBuilder();
            try {
                int c;
                while ((c = reader.read()) >= 0) {
                    if (c >= 65 && c <= 90) {
                        c = 90 - c + 65;
                    } else if (c >= 97 && c <= 122) {
                        c = 122 - c + 97;
                    }
                    builder.append((char)c);
                }
            }
            catch (IOException e) {
                throw new ScriptException(e);
            }
            return builder.toString();
        }
    }

    @Plugin(type=ScriptLanguage.class)
    public static class Rot13
    extends AbstractScriptLanguage {
        public ScriptEngine getScriptEngine() {
            return new Rot13Engine();
        }

        public List<String> getNames() {
            return Arrays.asList("Hello", "World", "Rot13");
        }

        public List<String> getExtensions() {
            return Arrays.asList("rot13");
        }
    }
}

