/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@FunctionalInterface
public interface Discoverer {
    public <U> List<U> discover(Class<U> var1);

    public static <T> Discoverer using(final Function<Class<T>, ? extends Iterable<T>> func) {
        return new Discoverer(){

            @Override
            public <U> List<U> discover(Class<U> c) {
                try {
                    Iterable itr = (Iterable)func.apply(c);
                    return StreamSupport.stream(itr.spliterator(), false).collect(Collectors.toList());
                }
                catch (ClassCastException | ServiceConfigurationError e) {
                    return Collections.emptyList();
                }
            }
        };
    }

    public static <T> List<Discoverer> all(Function<Class<T>, ? extends Iterable<T>> func) {
        Discoverer d = Discoverer.using(func);
        List<Discoverer> allProvided = d.discover(Discoverer.class);
        ArrayList<Discoverer> discoverers = new ArrayList<Discoverer>(allProvided);
        discoverers.add(d);
        return discoverers;
    }

    public static Discoverer union(final Iterable<Discoverer> discoverers) {
        return new Discoverer(){

            @Override
            public <U> List<U> discover(Class<U> c) {
                ArrayList<U> list = new ArrayList<U>();
                for (Discoverer discoverer : discoverers) {
                    list.addAll(discoverer.discover(c));
                }
                return list;
            }
        };
    }

    default public Discoverer onlyFor(Class<?> ... classes) {
        final List<Class<?>> list = Arrays.asList(classes);
        final Discoverer d = this;
        return new Discoverer(){

            @Override
            public <U> List<U> discover(Class<U> c) {
                if (list.contains(c)) {
                    return d.discover(c);
                }
                return Collections.emptyList();
            }
        };
    }

    default public Discoverer except(Class<?> ... classes) {
        final List<Class<?>> list = Arrays.asList(classes);
        final Discoverer d = this;
        return new Discoverer(){

            @Override
            public <U> List<U> discover(Class<U> c) {
                if (list.contains(c)) {
                    return Collections.emptyList();
                }
                return d.discover(c);
            }
        };
    }

    default public <U extends Comparable<U>> Optional<U> discoverMax(Class<U> c) {
        List<U> discoveries = this.discover(c);
        return discoveries.stream().max(Comparator.naturalOrder());
    }

    default public <U extends Comparable<U>> Optional<U> discoverMin(Class<U> c) {
        List<U> discoveries = this.discover(c);
        return discoveries.stream().min(Comparator.naturalOrder());
    }
}

