/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.scijava.maven.plugin.AbstractSciJavaDependencyChecker;

public class SnapshotFinder
extends AbstractSciJavaDependencyChecker {
    private final List remoteRepositories;
    private final MavenProjectBuilder projectBuilder;
    private final ArtifactRepository localRepository;
    private final Map<DependencyNode, Result> results = new HashMap<DependencyNode, Result>();
    private Set<MavenProject> reactorModules = new HashSet<MavenProject>();

    public SnapshotFinder(MavenProjectBuilder projectBuilder, ArtifactRepository localRepository, List remoteRepositories) {
        this.projectBuilder = projectBuilder;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
    }

    public void setReactorModules(List<MavenProject> modules) {
        this.reactorModules = new HashSet<MavenProject>(modules);
    }

    @Override
    public String makeExceptionMessage() {
        if (!this.failed()) {
            return null;
        }
        String message = "\nThe following artifacts either - are SNAPSHOT versions (V), contain \nSNAPSHOT parents (P), or contain SNAPSHOT dependencies (D):\n\n";
        HashMap<Artifact, Result> mergedResults = new HashMap<Artifact, Result>();
        for (DependencyNode node : this.results.keySet()) {
            Artifact a = node.getArtifact();
            Result r = this.results.get(node);
            if (mergedResults.containsKey(a)) {
                ((Result)mergedResults.get(a)).merge(r);
                continue;
            }
            mergedResults.put(a, r);
        }
        for (Artifact a : mergedResults.keySet()) {
            Result r = (Result)mergedResults.get(a);
            if (!r.failed() || !this.matches(a.getGroupId())) continue;
            message = message + r.failTags() + " " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion() + "\n";
        }
        if (this.isFailFast()) {
            message = message + "\nThere may be others but <failFast> was set to false\n";
        }
        return message;
    }

    public boolean visit(DependencyNode node) {
        Artifact a = node.getArtifact();
        MavenProject pom = null;
        Result r = null;
        try {
            pom = this.getProject(a);
            if (this.isRoot(node)) {
                r = new Result();
                this.checkParent(pom, r);
            } else {
                r = this.containsSnapshots(pom);
            }
        }
        catch (ProjectBuildingException e) {
            r = new Result();
            r.setFailTag(" Failed to build pom.");
        }
        this.results.put(node, r);
        if (r.failed() && this.matches(a.getGroupId())) {
            this.setFailed();
            this.markParent(node);
        }
        return !this.stopVisit();
    }

    private void markParent(DependencyNode badDependency) {
        Result r;
        DependencyNode parent = badDependency.getParent();
        if (parent != null && !this.isRoot(parent) && !(r = this.results.get(parent)).badDep()) {
            this.markParent(parent);
        }
    }

    private Result containsSnapshots(MavenProject pom) {
        Result r = new Result();
        this.checkParent(pom, r);
        if (this.isSnapshot(pom)) {
            r.badVersion();
        }
        return r;
    }

    private void checkParent(MavenProject pom, Result result) {
        if (pom.hasParent()) {
            MavenProject parent = pom.getParent();
            if (this.isSnapshot(parent)) {
                result.badParent();
            }
            this.checkParent(parent, result);
        }
    }

    private MavenProject getProject(Artifact a) throws ProjectBuildingException {
        MavenProject project = this.projectBuilder.buildFromRepository(a, this.remoteRepositories, this.localRepository);
        return project;
    }

    private boolean isSnapshot(MavenProject pom) {
        return pom.getVersion().contains("SNAPSHOT") && !this.reactorModules.contains(pom);
    }

    private static class Result {
        private boolean parent = false;
        private boolean dep = false;
        private boolean version = false;
        private String tag = "";

        private Result() {
        }

        public void badParent() {
            this.parent = true;
        }

        public boolean badDep() {
            boolean oldValue = this.dep;
            this.dep = true;
            return oldValue;
        }

        public void badVersion() {
            this.version = true;
        }

        public void setFailTag(String tag) {
            this.tag = tag;
        }

        public boolean failed() {
            return !this.tag.isEmpty() || this.parent || this.dep || this.version;
        }

        public String failTags() {
            return this.tag + (this.version ? " (V) " : "") + (this.parent ? " (P) " : "") + (this.dep ? " (D) " : "");
        }

        public void merge(Result r) {
            this.parent = this.parent || r.parent;
            this.dep = this.dep || r.dep;
            this.version = this.version || r.version;
            this.tag = !this.tag.isEmpty() && r.tag.isEmpty() ? this.tag + " | " + r.tag : this.tag + r.tag;
        }
    }
}

