/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.struct;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.scijava.common3.Classes;
import org.scijava.common3.Types;
import org.scijava.struct.Member;
import org.scijava.struct.MemberInstance;
import org.scijava.struct.MemberParser;
import org.scijava.struct.Struct;
import org.scijava.struct.StructInstance;

public final class Structs {
    private Structs() {
    }

    public static StructInstance<?> expand(StructInstance<?> parent, String key) {
        return Structs.expand(parent.member(key));
    }

    public static <T> StructInstance<T> expand(MemberInstance<T> memberInstance) {
        if (!memberInstance.member().isStruct()) {
            return null;
        }
        return memberInstance.member().childStruct().createInstance(memberInstance.get());
    }

    public static <S> Struct from(S source, Type structType, MemberParser<S, ? extends Member<?>> ... parsers) {
        ArrayList members = new ArrayList();
        for (MemberParser<S, Member<?>> memberParser : parsers) {
            members.addAll(memberParser.parse(source, structType));
        }
        return () -> members;
    }

    public static void checkModifiers(String message, int actualModifiers, boolean negate, int ... requiredModifiers) {
        for (int mod : requiredModifiers) {
            if (negate) {
                if ((actualModifiers & mod) == 0) continue;
                throw new IllegalArgumentException(message + "Illegal modifier. Must not be " + Modifier.toString(mod));
            }
            throw new IllegalArgumentException(message + "Illegal modifier. Must be " + Modifier.toString(mod));
        }
    }

    public static boolean isImmutable(Class<?> type) {
        return Classes.isNumber(type) || Classes.isText(type) || Classes.isBoolean(type);
    }

    public static String toString(Struct struct) {
        return Structs.toString(struct, 0);
    }

    public static String toString(Member<?> member) {
        return Structs.toString(member, 0);
    }

    private static String toString(Struct struct, int level) {
        String indent = " ".repeat(2 * level);
        return indent + String.join((CharSequence)("\n" + indent), struct.members().stream().map(m -> Structs.toString(m, level)).collect(Collectors.toList()));
    }

    private static String toString(Member<?> member, int level) {
        String desc = member.description();
        String descriptionSuffix = desc == null ? "" : " {" + desc.trim() + "}";
        return String.format("%s: %s%s [%s]%s%s", new Object[]{member.key(), Types.name((Type)member.type()), member.isRequired() ? "" : "?", member.getIOType(), descriptionSuffix, member.isStruct() ? "\n" + Structs.toString(member.childStruct(), level + 1) : ""});
    }
}

