/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlMappingAttribute;
import org.sqlproc.engine.impl.SqlMappingIdentity;
import org.sqlproc.engine.impl.SqlMetaElement;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.type.SqlInternalType;
import org.sqlproc.engine.type.SqlMetaType;

class SqlMappingItem
implements SqlMetaElement {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<SqlMappingAttribute> attributes;
    private Map<String, SqlMappingAttribute> attributesMap;
    private String dbName;
    private StringBuilder fullName;
    private SqlType sqlType;
    private boolean identity;
    Map<String, String> values = new HashMap<String, String>();

    SqlMappingItem(String dbName) {
        this.attributes = new ArrayList<SqlMappingAttribute>();
        this.attributesMap = new HashMap<String, SqlMappingAttribute>();
        this.sqlType = new SqlType();
        this.dbName = dbName;
        this.fullName = new StringBuilder();
    }

    String getDbName() {
        return this.dbName;
    }

    SqlMappingAttribute addAttributeName(String name) {
        String[] names = name.split("=");
        if (this.fullName.length() > 0) {
            this.fullName.append(".");
        }
        this.fullName.append(names[0]);
        SqlMappingAttribute attr = new SqlMappingAttribute(this, this.fullName.toString(), names[0]);
        if (names.length > 1) {
            attr.setValues("type", names[1]);
        }
        if (names.length > 2) {
            attr.setValues("gtype", names[2]);
        }
        this.attributes.add(attr);
        this.attributesMap.put(this.fullName.toString(), attr);
        return attr;
    }

    SqlMappingAttribute setAttributeValue(String attrName, String value) {
        String[] values = value.split("=");
        SqlMappingAttribute attr = this.attributesMap.get(attrName);
        if (values.length > 1) {
            attr.setValues("gtype", values[1]);
        } else {
            attr.setValues("type", values[0]);
        }
        return attr;
    }

    List<SqlMappingAttribute> getAttributes() {
        return this.attributes;
    }

    void setAttributes(List<SqlMappingAttribute> attributes) {
        this.attributes = attributes;
    }

    void setAttributesMap(Map<String, SqlMappingAttribute> attributesMap) {
        this.attributesMap = attributesMap;
    }

    boolean isIdentity() {
        if (this.identity) {
            return true;
        }
        String id = SqlProcessContext.getFeature("ID");
        return id != null && id.equalsIgnoreCase(this.getName());
    }

    String getFullName() {
        if (this.fullName.length() > 0) {
            return this.fullName.toString();
        }
        return this.dbName;
    }

    String getName() {
        return this.attributes.isEmpty() ? this.dbName : this.attributes.get(this.attributes.size() - 1).getName();
    }

    void setMetaType(SqlMetaType metaType) {
        this.sqlType = new SqlType(metaType);
    }

    SqlType getSqlType() {
        return this.sqlType;
    }

    void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    void setValues(String value, String value2) {
        this.setValues(null, value, value2);
    }

    void setValues(String name, String value, String value2) {
        int ix = -1;
        if (value2 == null && (ix = value.indexOf(61)) >= 0) {
            value2 = value.substring(ix + 1);
            value = value.substring(0, ix);
        }
        if (value2 == null) {
            if ("id".equalsIgnoreCase(value)) {
                this.identity = true;
            } else {
                this.sqlType.setValue(value);
            }
        } else if (name == null) {
            this.values.put(value, value2);
        } else {
            this.values.put(name + value, value2);
        }
    }

    void setQueryResultMapping(Class<?> resultClass, Map<String, Class<?>> moreResultClasses, SqlQuery query) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>>  setQueryResultMapping, fullName=" + this.getFullName() + ", resultClass=" + resultClass + ", moreResultClasses=" + moreResultClasses);
        }
        if (this.sqlType.getMetaType() instanceof SqlInternalType) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("<<<  setQueryResultMapping, fullName=" + this.getFullName() + ", dbName=" + this.dbName + ", metaType=" + this.sqlType.getMetaType());
            }
            ((SqlInternalType)this.sqlType.getMetaType()).addScalar(query, this.dbName, null);
        } else {
            int count = this.attributes.size();
            boolean exit = false;
            Class<?> objClass = resultClass;
            for (int i = 0; i < count - 1 && !exit; ++i) {
                Class<?> typeClass;
                String typeName;
                SqlMappingAttribute attr = this.attributes.get(i);
                String name = attr.getName();
                Method m = BeanUtils.getGetter(objClass, name);
                if (m != null) {
                    objClass = m.getReturnType();
                } else if (SqlProcessContext.isFeature("IGNORE_INPROPER_OUT")) {
                    this.logger.error("There's no getter for '" + name + "' in " + objClass + ", complete attribute name is '" + attr.getFullName() + "'");
                    exit = true;
                } else {
                    throw new SqlRuntimeException("There's no getter for '" + name + "' in " + objClass + ", complete attribute name is '" + attr.getFullName() + "'");
                }
                if (exit) continue;
                boolean isCollection = false;
                for (Class<?> clazz : objClass.getInterfaces()) {
                    if (clazz != Collection.class) continue;
                    isCollection = true;
                    break;
                }
                if (isCollection) {
                    Class typeClass2;
                    typeName = moreResultClasses != null ? this.values.get(attr.getFullName() + "gtype") : null;
                    Class clazz = typeClass2 = typeName != null ? moreResultClasses.get(typeName) : null;
                    if (typeClass2 == null) {
                        ParameterizedType paramType = (ParameterizedType)m.getGenericReturnType();
                        typeClass2 = (Class)paramType.getActualTypeArguments()[0];
                    }
                    if (typeClass2 != null) {
                        objClass = typeClass2;
                        continue;
                    }
                    if (SqlProcessContext.isFeature("IGNORE_INPROPER_OUT")) {
                        this.logger.error("There's no generic type defined for collection " + objClass + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
                        exit = true;
                        continue;
                    }
                    throw new SqlRuntimeException("There's no generic type defined for collection " + objClass + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
                }
                if (moreResultClasses == null) continue;
                typeName = moreResultClasses != null ? this.values.get(attr.getFullName() + "gtype") : null;
                Class<?> clazz = typeClass = typeName != null ? moreResultClasses.get(typeName) : null;
                if (typeClass == null) continue;
                objClass = typeClass;
            }
            Class<?> attributeType = BeanUtils.getFieldType(objClass, this.getName());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("<<<  setQueryResultMapping, fullName=" + this.getFullName() + ", dbName=" + this.dbName + ", attributeType=" + attributeType);
            }
            if (!exit) {
                this.sqlType.getMetaType().addScalar(query, this.dbName, attributeType);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setQueryResultData(Object resultInstance, int resultIndex, Object[] resultValues, Map<String, Object> ids, Map<String, Object> idsProcessed, Map<String, SqlMappingIdentity> identities, Map<String, Class<?>> moreResultClasses) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setQueryResultData, fullName=" + this.getFullName() + ", resultInstance=" + resultInstance + ", resultValue=" + resultValues[resultIndex]);
        }
        if (resultValues[resultIndex] == null) {
            return;
        }
        if (ids != null) {
            String idsKey = SqlUtils.getIdsKey(resultValues, identities, this.getFullName());
            boolean alreadyProcessed = ids.containsKey(idsKey);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("=== setQueryResultData, fullName=" + this.getFullName() + ", idsKey=" + idsKey + ", alreadyProcessed=" + alreadyProcessed);
            }
            if (alreadyProcessed) {
                return;
            }
        }
        boolean exit = false;
        Object obj = resultInstance;
        int count = this.attributes.size();
        for (int i = 0; i < count - 1 && !exit; ++i) {
            Method m;
            SqlMappingAttribute attr = this.attributes.get(i);
            String name = attr.getName();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("=== setQueryResultData, fullName=" + this.getFullName() + ", name=" + name + ", identities=" + identities.get(attr.getFullName()));
            }
            if ((m = BeanUtils.getGetter(obj, name)) != null) {
                Object nextObj = BeanUtils.invokeMethod(obj, m.getName(), null);
                if (nextObj == null) {
                    Class<?> clazz;
                    String typeName = this.values.get(attr.getFullName() + "type");
                    Class<?> clazz2 = clazz = typeName != null ? moreResultClasses.get(typeName) : null;
                    if (clazz == null) {
                        Class<?> clazz3 = m.getReturnType();
                        if (clazz3.isInterface()) {
                            if (clazz3 == List.class) {
                                Class<ArrayList> clazz4 = ArrayList.class;
                            } else if (clazz3 == Set.class) {
                                Class<HashSet> clazz5 = HashSet.class;
                            } else {
                                if (!SqlProcessContext.isFeature("IGNORE_INPROPER_OUT")) throw new SqlRuntimeException("There's no type defined for collection " + clazz3 + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
                                this.logger.error("There's no type defined for collection " + clazz3 + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
                                exit = true;
                            }
                        } else {
                            Class<?> clazz6 = clazz3;
                        }
                    }
                    if (!exit) {
                        void var17_24;
                        String typeName2;
                        Class<?> typeClass2 = null;
                        if (moreResultClasses != null && (typeName2 = this.values.get(attr.getFullName() + "gtype")) != null) {
                            typeClass2 = typeName2.toLowerCase().startsWith("discr") ? moreResultClasses.get(resultValues[resultIndex]) : moreResultClasses.get(typeName2);
                        }
                        if ((nextObj = typeClass2 != null && var17_24.isAssignableFrom(typeClass2) ? BeanUtils.getInstance(typeClass2) : BeanUtils.getInstance(var17_24)) != null) {
                            BeanUtils.setProperty(obj, name, nextObj);
                        } else {
                            if (!SqlProcessContext.isFeature("IGNORE_INPROPER_OUT")) throw new SqlRuntimeException("There's problem to instantiate " + var17_24 + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
                            this.logger.error("There's problem to instantiate " + var17_24 + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
                            exit = true;
                        }
                    }
                }
                if (!exit && nextObj instanceof Collection) {
                    String idsKey = SqlUtils.getIdsKey(resultValues, identities, attr.getFullName());
                    if (ids.containsKey(idsKey)) {
                        nextObj = ids.get(idsKey);
                    } else if (idsProcessed.containsKey(idsKey)) {
                        nextObj = idsProcessed.get(idsKey);
                    } else {
                        String string = moreResultClasses != null ? this.values.get(attr.getFullName() + "gtype") : null;
                        Class<Object> typeClass = null;
                        if (string != null) {
                            typeClass = string.toLowerCase().startsWith("discr") ? moreResultClasses.get(resultValues[resultIndex]) : moreResultClasses.get(string);
                        }
                        if (typeClass == null) {
                            ParameterizedType paramType = (ParameterizedType)m.getGenericReturnType();
                            typeClass = (Class<Object>)paramType.getActualTypeArguments()[0];
                        }
                        if (typeClass != null) {
                            Object itemObj = BeanUtils.getInstance(typeClass);
                            if (itemObj != null) {
                                ((Collection)nextObj).add(itemObj);
                                idsProcessed.put(idsKey, itemObj);
                                nextObj = itemObj;
                            } else {
                                if (!SqlProcessContext.isFeature("IGNORE_INPROPER_OUT")) throw new SqlRuntimeException("There's problem to instantiate " + typeClass + ", complete attribute name is " + attr.getFullName() + ", possible type name is " + string);
                                this.logger.error("There's problem to instantiate " + typeClass + ", complete attribute name is " + attr.getFullName() + ", possible type name is " + string);
                                exit = true;
                            }
                        } else {
                            if (!SqlProcessContext.isFeature("IGNORE_INPROPER_OUT")) throw new SqlRuntimeException("There's no generic type defined for collection " + nextObj + ", complete attribute name is " + attr.getFullName() + ", possible type name is " + string);
                            this.logger.error("There's no generic type defined for collection " + nextObj + ", complete attribute name is " + attr.getFullName() + ", possible type name is " + string);
                            exit = true;
                        }
                    }
                }
                obj = nextObj;
                continue;
            }
            if (!SqlProcessContext.isFeature("IGNORE_INPROPER_OUT")) throw new SqlRuntimeException("There's no getter for " + name + " in " + obj + ", complete attribute name is " + attr.getFullName());
            this.logger.error("There's no getter for " + name + " in " + obj + ", complete attribute name is " + attr.getFullName());
            exit = true;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("<<< setQueryResultData, fullName=" + this.getFullName() + ", name=" + this.getName() + ", obj=" + obj + ", resultValue=" + resultValues[resultIndex]);
        }
        this.sqlType.setResult(obj, this.getName(), resultValues[resultIndex]);
    }

    SqlMappingItem merge(SqlMappingItem outputMapping) {
        SqlMappingItem resultMappingItem = new SqlMappingItem(this.dbName);
        if (this.attributes != null && this.attributes.size() > 0) {
            resultMappingItem.setAttributes(this.attributes);
            resultMappingItem.setAttributesMap(this.attributesMap);
            resultMappingItem.fullName = this.fullName;
            resultMappingItem.identity = this.identity;
            resultMappingItem.values = this.values;
        } else {
            resultMappingItem.setAttributes(outputMapping.getAttributes());
            resultMappingItem.setAttributesMap(this.attributesMap);
            resultMappingItem.fullName = outputMapping.fullName;
            resultMappingItem.identity = outputMapping.identity;
            resultMappingItem.values = outputMapping.values;
        }
        if (this.sqlType != null) {
            resultMappingItem.setSqlType(this.sqlType);
        } else {
            resultMappingItem.setSqlType(outputMapping.getSqlType());
        }
        return resultMappingItem;
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlProcessResult result = new SqlProcessResult(this.dbName);
        result.addOutputValue(this.dbName, this);
        return result;
    }

    public String toString() {
        return "SqlMappingItem [attributes=" + this.attributes + ", dbName=" + this.dbName + ", fullName=" + this.fullName + ", sqlType=" + this.sqlType + ", identity=" + this.identity + "]";
    }
}

