/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.type.SqlMetaType;

class SqlType {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlMetaType metaType;
    private String value;

    SqlType() {
        this.metaType = null;
    }

    SqlType(SqlMetaType metaType) {
        this.metaType = metaType;
    }

    SqlMetaType getMetaType() {
        if (this.metaType == null) {
            return SqlProcessContext.getTypeFactory().getDefaultType();
        }
        return this.metaType;
    }

    void setResult(Object resultInstance, String attributeName, Object resultValue) throws SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("setResult " + this.metaType + " " + attributeName + " " + resultValue);
        }
        this.getMetaType().setResult(resultInstance, attributeName, resultValue, SqlProcessContext.isFeature("IGNORE_INPROPER_OUT"));
    }

    void setParameter(SqlQuery query, String paramName, Object inputValue, Class<?> inputType) throws SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("setParameter " + this.metaType + " " + paramName + " " + inputValue);
        }
        this.getMetaType().setParameter(query, paramName, inputValue, inputType, SqlProcessContext.isFeature("IGNORE_INPROPER_IN"));
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

