/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlFeature;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.SqlInputValue;
import org.sqlproc.engine.impl.SqlMetaLogOperand;
import org.sqlproc.engine.impl.SqlMetaSimple;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.type.SqlMetaType;

class SqlMetaConst
implements SqlMetaSimple,
SqlMetaLogOperand {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlInputValue.Code caseConversion;
    private boolean not;
    private List<String> elements;
    private SqlType sqlType;
    Map<String, String> values = new HashMap<String, String>();

    SqlMetaConst(SqlInputValue.Code caseConversion) {
        this(caseConversion, false);
    }

    SqlMetaConst(SqlInputValue.Code caseConversion, boolean not) {
        this(caseConversion, false, new SqlType());
    }

    SqlMetaConst(SqlInputValue.Code caseConversion, boolean not, SqlType type) {
        this.elements = new ArrayList<String>();
        this.caseConversion = caseConversion;
        this.not = not;
        this.sqlType = type;
    }

    void addConst(String name) {
        String[] names = name.split("=");
        this.elements.add(names[0]);
    }

    void setMetaType(String metaTypeName, SqlMetaType metaType) {
        this.sqlType = new SqlType(metaTypeName, metaType);
    }

    public void setValues(String value, String value2) {
        int ix = -1;
        if (value2 == null && (ix = value.indexOf(61)) >= 0) {
            value2 = value.substring(ix + 1);
            value = value.substring(0, ix);
        }
        if (value2 == null) {
            if (value.equals("anyset")) {
                this.values.put(value, null);
            } else {
                this.sqlType.setValue(value);
            }
        } else {
            this.values.put(value, value2);
        }
    }

    SqlType getSqlType() {
        return this.sqlType;
    }

    void setNot(boolean not) {
        this.not = not;
    }

    boolean isNot() {
        return this.not;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public void setElements(List<String> elements) {
        this.elements = elements;
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> process : inputValues=" + this.getInputValues(ctx) + ", class=" + (this.getInputValues(ctx) != null ? this.getInputValues(ctx).getClass() : null) + ", sqlType=" + this.sqlType);
        }
        SqlProcessResult result = new SqlProcessResult(ctx);
        Object obj = null;
        Object parentObj = null;
        String attributeName = null;
        if (this.getInputValues(ctx) != null) {
            obj = this.getInputValues(ctx);
            Class<?> attributeType = obj != null ? obj.getClass() : null;
            Iterator<String> i$ = this.elements.iterator();
            while (i$.hasNext()) {
                String item;
                attributeName = item = i$.next();
                if (attributeType != null) {
                    Class<?> origAttributeType = attributeType;
                    if ((attributeType = this.getFieldType(ctx, attributeType, attributeName)) == null) {
                        if (ctx.isFeature(SqlFeature.IGNORE_INPROPER_IN)) {
                            this.logger.error("There's no attribute '" + attributeName + "' for " + origAttributeType);
                        } else {
                            throw new SqlRuntimeException("There's no attribute '" + attributeName + "' for " + origAttributeType);
                        }
                    }
                }
                if (obj == null) continue;
                parentObj = obj;
                obj = this.getProperty(ctx, obj, item);
            }
        }
        String defaultInputValue = obj == null ? this.getDefaultData() : null;
        try {
            if (defaultInputValue != null) {
                result.add(true);
            } else {
                result.add(ctx.getPluginFactory().getIsEmptyPlugin().isNotEmpty(ctx, attributeName, obj, parentObj, this.sqlType == null ? null : this.sqlType.getMetaType(ctx), this.sqlType == null ? null : this.sqlType.getValue(), ctx.isInSetOrInsert(), this.values));
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Input value " + attributeName + ", failed reason" + e.getMessage());
        }
        if (obj != null) {
            if (obj instanceof Collection) {
                boolean notEmpty;
                boolean bl = notEmpty = !((Collection)obj).isEmpty();
                if (!notEmpty && this.values.containsKey("anyset")) {
                    result.setSql(new StringBuilder("(null)"));
                } else {
                    StringBuilder s = new StringBuilder(notEmpty ? "(" : "");
                    Iterator i = ((Collection)obj).iterator();
                    while (i.hasNext()) {
                        Object objItem = i.next();
                        if (objItem != null) {
                            s.append(this.getData(ctx, objItem));
                        } else {
                            s.append("null");
                        }
                        if (!i.hasNext()) continue;
                        s.append(',');
                    }
                    if (notEmpty) {
                        s.append(')');
                    }
                    result.setSql(s);
                }
            } else {
                result.setSql(new StringBuilder(this.getData(ctx, obj)));
            }
        } else {
            result.setSql(new StringBuilder(defaultInputValue != null ? defaultInputValue : ""));
        }
        return result;
    }

    String getData(SqlProcessContext ctx, Object obj) {
        if (obj instanceof String) {
            if (this.caseConversion == SqlInputValue.Code.UPPER) {
                return "'" + obj.toString().toUpperCase() + "'";
            }
            if (this.caseConversion == SqlInputValue.Code.LOWER) {
                return "'" + obj.toString().toLowerCase() + "'";
            }
            return "'" + obj.toString() + "'";
        }
        if (obj.getClass().isEnum() && this.sqlType != null) {
            if (this.sqlType.getMetaType(ctx) == ctx.getTypeFactory().getEnumStringType()) {
                Object o = ctx.getEnumToValue(obj);
                if (o != null && o instanceof String) {
                    return "'" + (String)o + "'";
                }
                return "'" + obj.toString() + "'";
            }
            if (this.sqlType.getMetaType(ctx) == ctx.getTypeFactory().getEnumIntegerType()) {
                Object o = ctx.getEnumToValue(obj);
                if (o != null) {
                    return o.toString();
                }
                return obj.toString();
            }
            if (this.sqlType.getMetaType(ctx) == ctx.getTypeFactory().getDefaultType()) {
                Object o = ctx.getEnumToValue(obj);
                if (o != null && o instanceof Integer) {
                    return o.toString();
                }
                if (o != null && o instanceof String) {
                    return "'" + o + "'";
                }
                return obj.toString();
            }
            return obj.toString();
        }
        return obj.toString();
    }

    @Override
    public boolean processExpression(SqlProcessContext ctx) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> processExpression : inputValues=" + this.getInputValues(ctx) + ", class=" + (this.getInputValues(ctx) != null ? this.getInputValues(ctx).getClass() : null) + ", sqlType=" + this.sqlType);
        }
        Object parentObj = null;
        Object obj = null;
        String attributeName = null;
        if (this.getInputValues(ctx) != null) {
            obj = this.getInputValues(ctx);
            Iterator<String> i$ = this.elements.iterator();
            while (i$.hasNext()) {
                String item;
                attributeName = item = i$.next();
                if (obj == null) continue;
                parentObj = obj;
                obj = ctx.getAttribute(obj, item);
            }
        }
        boolean result = ctx.getPluginFactory().getIsTruePlugin().isTrue(ctx, attributeName, obj, parentObj, this.sqlType == null ? null : this.sqlType.getMetaType(ctx), this.sqlType == null ? null : this.sqlType.getValue(), this.values);
        return this.not ? !result : result;
    }

    Object getInputValues(SqlProcessContext ctx) {
        return ctx.getStaticInputValues();
    }

    String getDefaultData() {
        return null;
    }

    Class<?> getFieldType(SqlProcessContext ctx, Class<?> attributeType, String attributeName) {
        return ctx.getAttributeType(attributeType, attributeName);
    }

    Object getProperty(SqlProcessContext ctx, Object obj, String item) {
        return ctx.getAttribute(obj, item);
    }
}

