/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.type.SqlBigIntegerType;

public class JdbcBigIntegerType
extends SqlBigIntegerType
implements JdbcSqlType {
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[]{BigInteger.class};
    }

    @Override
    public Object getProviderSqlType() {
        return this;
    }

    @Override
    public Integer getDatabaseSqlType() {
        return 2;
    }

    @Override
    public Object get(ResultSet rs, String columnLabel) throws SQLException {
        BigDecimal bigDecimal = Character.isDigit(columnLabel.charAt(0)) ? rs.getBigDecimal(Integer.parseInt(columnLabel)) : rs.getBigDecimal(columnLabel);
        return bigDecimal == null ? null : bigDecimal.setScale(0, 7).unscaledValue();
    }

    @Override
    public void set(PreparedStatement st, int index, Object value) throws SQLException {
        st.setBigDecimal(index, new BigDecimal((BigInteger)value));
    }

    @Override
    public Object get(CallableStatement cs, int index) throws SQLException {
        BigDecimal result = cs.getBigDecimal(index);
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }
}

