/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlFeature;
import org.sqlproc.engine.impl.ErrorMsg;
import org.sqlproc.engine.impl.ParserUtils;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaElement;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessorLazyLexer;
import org.sqlproc.engine.impl.SqlProcessorLazyParser;
import org.sqlproc.engine.impl.SqlProcessorLexer;
import org.sqlproc.engine.impl.SqlProcessorParser;
import org.sqlproc.engine.type.SqlTypeFactory;

public class SqlProcessor {
    protected static Logger logger = LoggerFactory.getLogger(SqlMetaElement.class);
    private Pattern mapPattern = Pattern.compile("\\s*\\[\\s*(.*)\\s*]\\s*");
    Map<String, Map<String, SqlMetaStatement>> metaStatements = new LinkedHashMap<String, Map<String, SqlMetaStatement>>();
    Map<String, Map<String, SqlMappingRule>> mappingRules;
    private Map<String, Object> features;
    private Map<String, Map<String, Object>> statementsFeatures;
    private Map<String, Set<String>> statementsFeaturesUnset;
    private Map<String, Object> defaultFeatures;
    private Set<String> onlyStatements;
    private Set<String> allArtifactsNames;
    private List<String> warnings;
    private List<ErrorMsg> errors;
    private static final String IDGEN = SqlFeature.IDGEN.name() + "_";
    private static final int lIDGEN = IDGEN.length();
    private static final String SEQ = SqlFeature.SEQ.name() + "_";
    private static final int lSEQ = SEQ.length();
    private static final String IDSEL = SqlFeature.IDSEL.name() + "_";
    private static final int lIDSEL = IDSEL.length();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlProcessor getInstance(StringBuilder sbStatements, SqlTypeFactory typeFactory, Map<String, Object> defaultFeatures, Set<String> onlyStatements, String ... filters) throws SqlEngineException {
        if (logger.isTraceEnabled()) {
            logger.trace(">> getInstance, sStatements=" + sbStatements);
        }
        SqlProcessor processor = null;
        try {
            SqlProcessorLexer lexer = new SqlProcessorLexer((CharStream)new ANTLRStringStream(sbStatements.toString()));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SqlProcessorParser parser = new SqlProcessorParser((TokenStream)tokens);
            try {
                processor = parser.parse2(typeFactory, defaultFeatures, onlyStatements, filters);
            }
            catch (RecognitionException ex) {
                ex.printStackTrace();
            }
            if (!(lexer.getErrors().isEmpty() && parser.getErrors().isEmpty() && processor.getErrors().isEmpty())) {
                throw new SqlEngineException("Statement error for '" + sbStatements + "'", lexer.getErrors(), parser.getErrors(), processor.getErrors());
            }
            SqlProcessor sqlProcessor = processor;
            return sqlProcessor;
        }
        finally {
            if (logger.isTraceEnabled() && processor != null) {
                logger.trace("<< getInstance, queries=" + processor.getMetaStatements(StatementType.QRY));
                logger.trace("<< getInstance, cruds=" + processor.getMetaStatements(StatementType.CRUD));
                logger.trace("<< getInstance, calls=" + processor.getMetaStatements(StatementType.CALL));
                logger.trace("<< getInstance, input mappings=" + processor.getMappingRules(MappingType.IN));
                logger.trace("<< getInstance, output mappings=" + processor.getMappingRules(MappingType.OUT));
                logger.trace("<< getInstance, features=" + processor.getFeatures());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlProcessor getLazyInstance(StringBuilder sbStatements, SqlTypeFactory typeFactory, Map<String, Object> defaultFeatures, Set<String> onlyStatements, String ... filters) throws SqlEngineException {
        if (logger.isTraceEnabled()) {
            logger.trace(">> getRawInstance, sStatements=" + sbStatements);
        }
        SqlProcessor processor = null;
        try {
            SqlProcessorLazyLexer lexer = new SqlProcessorLazyLexer((CharStream)new ANTLRStringStream(sbStatements.toString()));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SqlProcessorLazyParser parser = new SqlProcessorLazyParser((TokenStream)tokens);
            try {
                processor = parser.parse2(typeFactory, defaultFeatures, onlyStatements, filters);
            }
            catch (RecognitionException ex) {
                ex.printStackTrace();
            }
            if (!(lexer.getErrors().isEmpty() && parser.getErrors().isEmpty() && processor.getErrors().isEmpty())) {
                throw new SqlEngineException("Statement error for '" + sbStatements + "'", lexer.getErrors(), parser.getErrors(), processor.getErrors());
            }
            SqlProcessor sqlProcessor = processor;
            return sqlProcessor;
        }
        finally {
            if (logger.isTraceEnabled() && processor != null) {
                logger.trace("<< getInstance, queries=" + processor.getMetaStatements(StatementType.QRY));
                logger.trace("<< getInstance, cruds=" + processor.getMetaStatements(StatementType.CRUD));
                logger.trace("<< getInstance, calls=" + processor.getMetaStatements(StatementType.CALL));
                logger.trace("<< getInstance, input mappings=" + processor.getMappingRules(MappingType.IN));
                logger.trace("<< getInstance, output mappings=" + processor.getMappingRules(MappingType.OUT));
                logger.trace("<< getInstance, features=" + processor.getFeatures());
            }
        }
    }

    SqlProcessor(Map<String, Object> defaultFeatures, Set<String> onlyStatements) {
        for (StatementType statementType : StatementType.values()) {
            this.metaStatements.put(statementType.name(), new LinkedHashMap());
        }
        this.mappingRules = new LinkedHashMap<String, Map<String, SqlMappingRule>>();
        for (Enum enum_ : MappingType.values()) {
            this.mappingRules.put(enum_.name(), new LinkedHashMap());
        }
        this.defaultFeatures = defaultFeatures;
        this.features = new LinkedHashMap<String, Object>();
        this.features.putAll(defaultFeatures);
        this.statementsFeatures = new HashMap<String, Map<String, Object>>();
        this.statementsFeaturesUnset = new HashMap<String, Set<String>>();
        if (onlyStatements != null && !onlyStatements.isEmpty()) {
            this.onlyStatements = onlyStatements;
        }
        this.allArtifactsNames = new HashSet<String>();
        this.warnings = new ArrayList<String>();
        this.errors = new ArrayList<ErrorMsg>();
    }

    public Map<String, SqlMetaStatement> getMetaStatements(StatementType type) {
        return this.metaStatements.get(type.name());
    }

    public Map<String, SqlMetaStatement> getMetaStatements(String type) {
        StatementType.valueOf(type);
        return this.metaStatements.get(type);
    }

    boolean addMetaStatement(String type, String name, String raw, SqlMetaStatement statement, List<ErrorMsg> errors, List<String> activeFilters, String ... filters) {
        if (statement == null) {
            statement = new SqlMetaStatement(raw);
        }
        StatementType.valueOf(type);
        if (this.nameControl(this.onlyStatements, name)) {
            this.addWarnings(errors);
            return false;
        }
        if (errors != null && !errors.isEmpty()) {
            this.errors.addAll(errors);
            return false;
        }
        List<String> filteredActiveFilters = this.filterActiveFilters(activeFilters);
        FilterStatus status = this.filtersControl(filters, filteredActiveFilters);
        if (status == FilterStatus.NOK) {
            return false;
        }
        Map<String, SqlMetaStatement> statements = this.getMetaStatements(type);
        if (status == FilterStatus.OK_LOWER) {
            if (statements.containsKey(name)) {
                this.warnings.add("The artifact " + this.uniqueArtifactName(type, name, filteredActiveFilters) + " is already defined, the first definition is used.");
                return false;
            }
            statements.put(name, statement);
            this.loadStatementFeatures(name, activeFilters);
            return true;
        }
        this.duplicityControl(type, name, filteredActiveFilters);
        statements.put(name, statement);
        this.loadStatementFeatures(name, activeFilters);
        return true;
    }

    public Map<String, SqlMappingRule> getMappingRules(MappingType type) {
        return this.mappingRules.get(type.name());
    }

    public Map<String, SqlMappingRule> getMappingRules(String type) {
        MappingType.valueOf(type);
        return this.mappingRules.get(type);
    }

    public boolean addMappingRule(String type, String name, String raw, SqlMappingRule mapping, List<ErrorMsg> errors, List<String> activeFilters, String ... filters) {
        if (mapping == null) {
            mapping = new SqlMappingRule(raw);
        }
        MappingType.valueOf(type);
        if (this.nameControl(this.onlyStatements, name)) {
            this.addWarnings(errors);
            return false;
        }
        if (errors != null && !errors.isEmpty()) {
            this.errors.addAll(errors);
            return false;
        }
        List<String> filteredActiveFilters = this.filterActiveFilters(activeFilters);
        FilterStatus status = this.filtersControl(filters, filteredActiveFilters);
        if (status == FilterStatus.NOK) {
            return false;
        }
        Map<String, SqlMappingRule> mappings = this.getMappingRules(type);
        if (status == FilterStatus.OK_LOWER) {
            if (mappings.containsKey(name)) {
                this.warnings.add("The artifact " + this.uniqueArtifactName(type, name, filteredActiveFilters) + " is already defined, the first definition is used.");
                return false;
            }
            mappings.put(name, mapping);
            return true;
        }
        this.duplicityControl(type, name, filteredActiveFilters);
        mappings.put(name, mapping);
        return true;
    }

    public Map<String, Object> getFeatures() {
        return this.features;
    }

    public Map<String, Map<String, Object>> getStatementsFeatures() {
        return this.statementsFeatures;
    }

    public Map<String, Set<String>> getStatementsFeaturesUnset() {
        return this.statementsFeaturesUnset;
    }

    protected Object getFeature(String type, String feature) {
        FeatureType ftype = FeatureType.valueOf(type);
        if (ftype == FeatureType.LOPT) {
            return Long.parseLong(feature);
        }
        if (ftype == FeatureType.IOPT) {
            return Integer.parseInt(feature);
        }
        if (ftype == FeatureType.SOPT) {
            return Short.parseShort(feature);
        }
        if (ftype == FeatureType.BOPT) {
            return Boolean.parseBoolean(feature);
        }
        if (ftype == FeatureType.OPT) {
            return feature;
        }
        if (ftype == FeatureType.MOPT) {
            Matcher matcher = this.mapPattern.matcher(feature);
            if (!matcher.matches()) {
                return null;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            String[] ss = matcher.group(1).split("'");
            String key = null;
            block4: for (int i = 0; i < ss.length; ++i) {
                int phase = i % 4;
                switch (phase) {
                    case 1: {
                        key = ss[i];
                        continue block4;
                    }
                    case 3: {
                        map.put(key, ss[i]);
                    }
                }
            }
            return map;
        }
        return null;
    }

    public boolean addFeature(String type, String name, String feature, List<ErrorMsg> errors, List<String> activeFilters, String ... filters) {
        if ("MAX_DB_COLUMN_LEN".equalsIgnoreCase(name)) {
            ParserUtils.MAX_DB_COLUMN_LEN = Integer.valueOf(feature);
            return true;
        }
        String[] ss = name.split("=");
        if (ss.length > 1) {
            name = ss[0] + "###" + ss[1];
        } else if (name.startsWith(IDGEN)) {
            name = SqlFeature.IDGEN.name() + "###" + name.substring(lIDGEN);
        } else if (name.startsWith(SEQ)) {
            name = SqlFeature.SEQ.name() + "###" + name.substring(lSEQ);
        } else if (name.startsWith(IDSEL)) {
            name = SqlFeature.IDSEL.name() + "###" + name.substring(lIDSEL);
        }
        FeatureType.valueOf(type);
        if (errors != null && !errors.isEmpty()) {
            this.errors.addAll(errors);
            return false;
        }
        List<String> filteredActiveFilters = this.filterActiveFilters(activeFilters);
        FilterStatus status = this.filtersControl(filters, filteredActiveFilters);
        if (status == FilterStatus.NOK) {
            return false;
        }
        if (status == FilterStatus.OK_LOWER) {
            if (this.getFeatures().containsKey(name)) {
                if (!this.defaultFeatures.containsKey(name)) {
                    this.warnings.add("The artifact " + this.uniqueArtifactName(type, name, filteredActiveFilters) + " is already defined, the first definition is used.");
                    return false;
                }
                this.defaultFeatures.remove(name);
                this.getFeatures().put(name, this.getFeature(type, feature));
                return true;
            }
            this.getFeatures().put(name, this.getFeature(type, feature));
            return true;
        }
        this.duplicityControl(type, name, filteredActiveFilters);
        this.getFeatures().put(name, this.getFeature(type, feature));
        return true;
    }

    protected boolean duplicityControl(String type, String name, List<String> activeFilters) {
        String uniqueName = this.uniqueArtifactName(type, name, activeFilters);
        if (this.allArtifactsNames.contains(uniqueName)) {
            this.warnings.add("The artifact " + uniqueName + " is already defined, the latest definition is used.");
            return true;
        }
        this.allArtifactsNames.add(uniqueName);
        return false;
    }

    protected String uniqueArtifactName(String type, String name, List<String> activeFilters) {
        return type + ":" + name + (activeFilters != null && !activeFilters.isEmpty() ? activeFilters.toString() : "");
    }

    protected void addWarnings(List<ErrorMsg> errors) {
        if (errors == null || errors.isEmpty()) {
            return;
        }
        for (ErrorMsg errorMsg : errors) {
            this.warnings.add(errorMsg.toString());
        }
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public List<ErrorMsg> getErrors() {
        return this.errors;
    }

    protected FilterStatus filtersControl(String[] filters, List<String> activeFilters) {
        if (filters == null || filters.length == 0) {
            if (activeFilters == null || activeFilters.isEmpty()) {
                return FilterStatus.OK;
            }
            return FilterStatus.NOK;
        }
        if (activeFilters == null || activeFilters.isEmpty()) {
            return FilterStatus.OK_LOWER;
        }
        ArrayList<String> commonList = new ArrayList<String>();
        for (String filter : filters) {
            if (!activeFilters.contains(filter)) continue;
            commonList.add(filter);
        }
        return commonList.isEmpty() ? FilterStatus.NOK : FilterStatus.OK;
    }

    protected boolean nameControl(Set<String> onlyStatements, String name) {
        if (onlyStatements == null || onlyStatements.isEmpty()) {
            return false;
        }
        return !onlyStatements.contains(name);
    }

    private List<String> filterActiveFilters(List<String> activeFilters) {
        if (activeFilters == null) {
            return null;
        }
        ArrayList<String> filteredActiveFilters = new ArrayList<String>();
        for (String filter : activeFilters) {
            if (filter.indexOf(61) >= 0) continue;
            filteredActiveFilters.add(filter);
        }
        return filteredActiveFilters;
    }

    private void loadStatementFeatures(String name, List<String> activeFilters) {
        if (activeFilters == null) {
            return;
        }
        for (String filter : activeFilters) {
            String type;
            int ix = filter.indexOf(61);
            if (ix <= 0 || !(type = filter.substring(0, ix)).equals(FeatureType.OPT.name()) && !type.equals(FeatureType.IOPT.name()) && !type.equals(FeatureType.LOPT.name()) && !type.equals(FeatureType.BOPT.name()) && !type.equals(FeatureType.SOPT.name())) continue;
            int ix2 = (filter = filter.substring(ix + 1)).indexOf(61);
            if (ix2 <= 0) {
                if (!this.getStatementsFeaturesUnset().containsKey(name)) {
                    this.getStatementsFeaturesUnset().put(name, new HashSet());
                }
                this.getStatementsFeaturesUnset().get(name).add(filter);
                continue;
            }
            String featureName = filter.substring(0, ix2);
            String sValue = filter.substring(ix2 + 1);
            boolean isRef = sValue.startsWith("REF=");
            if (!isRef) {
                Object value = this.getFeature(type, sValue);
                if (value == null) continue;
                if (!this.getStatementsFeatures().containsKey(name)) {
                    this.getStatementsFeatures().put(name, new HashMap());
                }
                this.getStatementsFeatures().get(name).put(featureName, value);
                continue;
            }
            String refName = sValue.substring(4);
            Object refValue = this.getFeatures().get(refName);
            if (refValue == null) continue;
            if (!this.getStatementsFeatures().containsKey(name)) {
                this.getStatementsFeatures().put(name, new HashMap());
            }
            this.getStatementsFeatures().get(name).put(featureName, refValue);
        }
    }

    static enum FilterStatus {
        NOK,
        OK_LOWER,
        OK;

    }

    public static enum FeatureType {
        OPT,
        LOPT,
        IOPT,
        SOPT,
        BOPT,
        MOPT;

    }

    public static enum MappingType {
        OUT,
        IN;

    }

    public static enum StatementType {
        QRY,
        CRUD,
        CALL;

    }
}

