/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.type.SqlIntegerType;

public class JdbcIntegerType
extends SqlIntegerType
implements JdbcSqlType {
    @Override
    public Object getProviderSqlType() {
        return this;
    }

    @Override
    public Integer getDatabaseSqlType() {
        return 4;
    }

    @Override
    public Object get(ResultSet rs, String columnLabel) throws SQLException {
        if (Character.isDigit(columnLabel.charAt(0))) {
            return new Integer(rs.getInt(Integer.parseInt(columnLabel)));
        }
        return new Integer(rs.getInt(columnLabel));
    }

    @Override
    public void set(PreparedStatement st, int index, Object value) throws SQLException {
        st.setInt(index, (Integer)value);
    }

    @Override
    public Object get(CallableStatement cs, int index) throws SQLException {
        Integer result = new Integer(cs.getInt(index));
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }
}

