/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.plugin;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlFeature;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.plugin.BeanUtilsPlugin;

public class DefaultBeanUtilsPlugin
implements BeanUtilsPlugin {
    protected ConcurrentHashMap<String, Constructor<?>> constructors = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, PropertyDescriptor[]> descriptors = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Class<?>> types = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Class<?>[]> parameterizedTypes = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Method> getters = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, BeanUtilsPlugin.GetterType> typeGetters = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Method> setters = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Method> methods = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Method> enumsIn = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Method> enumsOut = new ConcurrentHashMap();
    final Logger logger = LoggerFactory.getLogger(DefaultBeanUtilsPlugin.class);

    protected Constructor<?> getInstanceConstructor(SqlRuntimeContext runtimeCtx, Class<?> clazz) {
        String keyName = clazz.getName();
        Constructor<?> ctor = this.constructors.get(keyName);
        if (ctor != null) {
            return ctor;
        }
        if ((clazz.getModifiers() & 0x400) != 0) {
            this.logger.warn("getInstance: " + clazz + " is abstract");
            return null;
        }
        try {
            ctor = clazz.getConstructor(new Class[0]);
            try {
                ctor.setAccessible(true);
            }
            catch (SecurityException se) {
                this.logger.warn("getInstance: " + clazz + " " + se.getMessage());
            }
        }
        catch (NoSuchMethodException e) {
            this.logger.warn("getInstance: " + clazz + " " + e.getMessage());
        }
        catch (SecurityException e) {
            this.logger.warn("getInstance: " + clazz + " " + e.getMessage());
        }
        if (ctor == null) {
            Constructor<?>[] ctors = clazz.getConstructors();
            int size = ctors.length;
            for (int i = 0; i < size; ++i) {
                Class<?> _clazz;
                Class<?>[] ctorParams = ctors[i].getParameterTypes();
                if (ctorParams.length != 0) continue;
                if (Modifier.isPublic(ctor.getModifiers()) && Modifier.isPublic((_clazz = ctor.getDeclaringClass()).getModifiers())) {
                    ctor = ctors[i];
                }
                if (ctor == null) continue;
                try {
                    ctor.setAccessible(true);
                    continue;
                }
                catch (SecurityException se) {
                    this.logger.warn("getInstance: " + clazz + " " + se.getMessage());
                }
            }
        }
        if (ctor == null) {
            return null;
        }
        Constructor<?> ctorPrev = this.constructors.putIfAbsent(keyName, ctor);
        if (ctorPrev != null) {
            return ctorPrev;
        }
        return ctor;
    }

    @Override
    public Object getInstance(SqlRuntimeContext runtimeCtx, Class<?> clazz) {
        Constructor<?> ctor = this.getInstanceConstructor(runtimeCtx, clazz);
        if (ctor == null) {
            this.logger.warn("getInstance: " + clazz + " can't get constructor");
            return null;
        }
        try {
            return ctor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            this.logger.error("getInstance: " + clazz, (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            this.logger.error("getInstance: " + clazz, (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            this.logger.error("getInstance: " + clazz, (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            this.logger.error("getInstance: " + clazz, (Throwable)e);
            return null;
        }
    }

    protected PropertyDescriptor[] getDescriptors(Class<?> clazz) {
        String keyName = clazz.getName();
        PropertyDescriptor[] _descriptors = this.descriptors.get(keyName);
        if (_descriptors != null) {
            return _descriptors;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            this.logger.error("getDescriptors: " + clazz, (Throwable)e);
            return null;
        }
        for (PropertyDescriptor pd : _descriptors = beanInfo.getPropertyDescriptors()) {
            if (!(pd instanceof IndexedPropertyDescriptor)) continue;
            this.logger.warn("getDescriptors: " + clazz + " unsupported IndexedPropertyDescriptor " + pd.getDisplayName());
        }
        PropertyDescriptor[] _descriptorsPrev = this.descriptors.putIfAbsent(keyName, _descriptors);
        if (_descriptorsPrev != null) {
            return _descriptorsPrev;
        }
        return _descriptors;
    }

    protected PropertyDescriptor getAttributeDescriptor(Class<?> clazz, String attrName) {
        PropertyDescriptor descriptor = null;
        PropertyDescriptor[] descriptors = this.getDescriptors(clazz);
        if (descriptors != null) {
            for (PropertyDescriptor _descriptor : descriptors) {
                if (!_descriptor.getName().equalsIgnoreCase(attrName)) continue;
                descriptor = _descriptor;
                break;
            }
        }
        return descriptor;
    }

    @Override
    public Class<?> getAttributeType(SqlRuntimeContext runtimeCtx, Class<?> clazz, String attrName) {
        String keyName = clazz.getName() + "." + attrName;
        Class<?> attrType = this.types.get(keyName);
        if (attrType != null) {
            return attrType;
        }
        PropertyDescriptor descriptor = this.getAttributeDescriptor(clazz, attrName);
        if (descriptor == null) {
            this.logger.error("getAttributeType: there's no attribute " + attrName + " in " + clazz.getName());
            return null;
        }
        attrType = descriptor.getPropertyType();
        Class<?> attrTypePrev = this.types.putIfAbsent(keyName, attrType);
        if (attrTypePrev != null) {
            return attrTypePrev;
        }
        return attrType;
    }

    @Override
    public Class<?>[] getAttributeParameterizedTypes(SqlRuntimeContext runtimeCtx, Class<?> clazz, String attrName) {
        Class<?>[] attrTypesPrev;
        String keyName = clazz.getName() + "." + attrName;
        Class<?>[] attrTypes = this.parameterizedTypes.get(keyName);
        if (attrTypes != null) {
            return attrTypes;
        }
        PropertyDescriptor descriptor = this.getAttributeDescriptor(clazz, attrName);
        if (descriptor == null) {
            this.logger.error("getAttributeType: there's no attribute " + attrName + " in " + clazz.getName());
            return null;
        }
        try {
            Field f = clazz.getDeclaredField(attrName);
            if (f.getGenericType() != null && f.getGenericType() instanceof ParameterizedType) {
                int size = ((ParameterizedType)f.getGenericType()).getActualTypeArguments().length;
                attrTypes = new Class[size];
                for (int i = 0; i < size; ++i) {
                    attrTypes[i] = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[i];
                }
            }
        }
        catch (NoSuchFieldException | SecurityException e) {
            this.logger.error("getAttributeParameterizedType: " + clazz + " for " + attrName, (Throwable)e);
            return null;
        }
        if (attrTypes != null && (attrTypesPrev = this.parameterizedTypes.putIfAbsent(keyName, attrTypes)) != null) {
            return attrTypesPrev;
        }
        return attrTypes;
    }

    protected Method getGetter(SqlRuntimeContext runtimeCtx, Class<?> clazz, String attrName, boolean onlyCheck) {
        String keyName = clazz.getName() + "." + attrName;
        Method getter = this.getters.get(keyName);
        if (getter != null) {
            return getter;
        }
        PropertyDescriptor descriptor = this.getAttributeDescriptor(clazz, attrName);
        if (descriptor == null) {
            if (!onlyCheck) {
                this.logger.error("getGetter: there's no attribute " + attrName + " in " + clazz.getName());
            }
            return null;
        }
        getter = this.getMethod(clazz, descriptor.getReadMethod(), onlyCheck);
        if (getter == null) {
            return null;
        }
        Method getterPrev = this.getters.putIfAbsent(keyName, getter);
        if (getterPrev != null) {
            return getterPrev;
        }
        return getter;
    }

    @Override
    public BeanUtilsPlugin.GetterType getGetterType(SqlRuntimeContext runtimeCtx, Class<?> clazz, String attrName) {
        String keyName = clazz.getName() + "." + attrName;
        BeanUtilsPlugin.GetterType getterType = this.typeGetters.get(keyName);
        if (getterType != null) {
            return getterType;
        }
        Method m = this.getGetter(runtimeCtx, clazz, attrName, false);
        if (m == null) {
            return null;
        }
        getterType = new BeanUtilsPlugin.GetterType(m);
        BeanUtilsPlugin.GetterType getterTypePrev = this.typeGetters.putIfAbsent(keyName, getterType);
        if (getterTypePrev != null) {
            return getterTypePrev;
        }
        return getterType;
    }

    @Override
    public BeanUtilsPlugin.GetterType getGetterType(SqlRuntimeContext runtimeCtx, Object bean, String attrName) {
        return this.getGetterType(runtimeCtx, bean.getClass(), attrName);
    }

    @Override
    public boolean checkAttribute(SqlRuntimeContext runtimeCtx, Object bean, String attrName) {
        return this.getGetter(runtimeCtx, bean.getClass(), attrName, true) != null;
    }

    @Override
    public Object getAttribute(SqlRuntimeContext runtimeCtx, Object bean, String attrName) throws SqlRuntimeException {
        Method getter = this.getGetter(runtimeCtx, bean.getClass(), attrName, true);
        if (getter == null) {
            throw new SqlRuntimeException("getAttribute(NoSuchMethodException): there's no getter for '" + attrName + "' in " + bean.getClass());
        }
        return this.invokeMethod(runtimeCtx, bean, getter, new Object[0]);
    }

    protected Method getSetter(SqlRuntimeContext runtimeCtx, Class<?> clazz, String attrName, boolean onlyCheck, Class<?> ... attrTypes) {
        String keyName = clazz.getName() + "." + attrName + this.attrTypes2String(attrTypes);
        Method _setter = this.setters.get(keyName);
        if (_setter != null) {
            return _setter;
        }
        PropertyDescriptor descriptor = this.getAttributeDescriptor(clazz, attrName);
        if (descriptor == null) {
            if (!onlyCheck) {
                this.logger.error("getSetter: there's no attribute " + attrName + " in " + clazz.getName());
            }
            return null;
        }
        _setter = this.getMethod(clazz, descriptor.getWriteMethod(), onlyCheck);
        if (_setter == null) {
            return null;
        }
        if (_setter.getParameterTypes() == null || _setter.getParameterTypes().length != 1) {
            if (!onlyCheck) {
                this.logger.error("getSetter: there's no setter " + attrName + " in " + clazz.getName());
            }
            return null;
        }
        Method setter = null;
        if (attrTypes == null || attrTypes.length == 0) {
            setter = _setter;
        } else {
            Class<?> setterType = _setter.getParameterTypes()[0];
            for (Class<?> _clazz : attrTypes) {
                if (!_clazz.isAssignableFrom(setterType)) continue;
                setter = _setter;
            }
        }
        if (setter == null) {
            if (!onlyCheck) {
                this.logger.error("getSetter: there's no setter " + attrName + " in " + clazz.getName());
            }
            return null;
        }
        Method setterPrev = this.setters.putIfAbsent(keyName, setter);
        if (setterPrev != null) {
            return setterPrev;
        }
        return setter;
    }

    protected Method getSetter(SqlRuntimeContext runtimeCtx, Object bean, String attrName, boolean onlyCheck, Class<?> ... attrTypes) {
        return this.getSetter(runtimeCtx, bean.getClass(), attrName, onlyCheck, attrTypes);
    }

    @Override
    public boolean simpleSetAttribute(SqlRuntimeContext runtimeCtx, Object bean, String attrName, Object attrValue, Class<?> ... attrTypes) {
        Method setter = this.getSetter(runtimeCtx, bean, attrName, true, attrTypes);
        if (setter != null) {
            this.invokeMethod(runtimeCtx, bean, setter, attrValue);
            return true;
        }
        return false;
    }

    @Override
    public void setAttribute(SqlRuntimeContext runtimeCtx, Object bean, String attrName, Object attrValue) throws SqlRuntimeException {
        Method setter = this.getSetter(runtimeCtx, bean, attrName, true, new Class[0]);
        if (setter == null) {
            throw new SqlRuntimeException("setAttribute(NoSuchMethodException): there's no setter for '" + attrName + "' in " + bean.getClass());
        }
        this.invokeMethod(runtimeCtx, bean, setter, attrValue);
    }

    protected Method getMethod(Class<?> clazz, Method method, boolean onlyCheck) {
        Class<?>[] parameterTypes;
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            if (!onlyCheck) {
                this.logger.error("getMethod: " + method.toString() + " in " + clazz.getName() + " is not public");
            }
            return null;
        }
        boolean sameClass = true;
        if (clazz == null) {
            clazz = method.getDeclaringClass();
        } else {
            sameClass = clazz.equals(method.getDeclaringClass());
            if (!method.getDeclaringClass().isAssignableFrom(clazz)) {
                if (!onlyCheck) {
                    this.logger.error("getMethod: " + clazz.getName() + " is not assignable from " + method.getDeclaringClass().getName());
                }
                return null;
            }
        }
        if (Modifier.isPublic(clazz.getModifiers())) {
            if (!sameClass && !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException se) {
                    this.logger.warn("getMethod: " + method.toString() + " in " + clazz + " " + se.getMessage());
                }
            }
            return method;
        }
        String methodName = method.getName();
        Method _method = this.getInterfaceMethod(clazz, methodName, parameterTypes = method.getParameterTypes());
        if (_method == null) {
            _method = this.getSuperclassMethod(clazz, methodName, parameterTypes);
        }
        if (_method == null && !onlyCheck) {
            this.logger.error("getMethod: there's no method " + method.toString() + " in " + clazz.getName());
        }
        return _method;
    }

    protected Method getInterfaceMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!Modifier.isPublic(interfaces[i].getModifiers())) continue;
                try {
                    method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (method != null) {
                    return method;
                }
                method = this.getInterfaceMethod(interfaces[i], methodName, parameterTypes);
                if (method == null) continue;
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    protected Method getSuperclassMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        for (Class<?> parentClazz = clazz.getSuperclass(); parentClazz != null; parentClazz = parentClazz.getSuperclass()) {
            if (!Modifier.isPublic(parentClazz.getModifiers())) continue;
            try {
                return parentClazz.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    protected Method getMethod(Class<?> clazz, String methodName, boolean onlyCheck, Class<?> ... parameterTypes) {
        String keyName = clazz.getName() + "." + methodName + this.attrTypes2String(parameterTypes);
        Method method = this.methods.get(keyName);
        if (method != null) {
            return method;
        }
        try {
            method = clazz.getMethod(methodName, parameterTypes);
            try {
                method.setAccessible(true);
            }
            catch (SecurityException se) {
                this.logger.warn("getMethod: not accessible method " + method.toString() + " in " + clazz.getName() + ": " + se.getMessage());
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            if (!onlyCheck) {
                this.logger.warn("getMethod: there's no method " + methodName + " in " + clazz.getName());
            }
            for (Method _method : clazz.getMethods()) {
                Class<?>[] methodsParams;
                int methodParamSize;
                if (!_method.getName().equals(methodName) || (methodParamSize = (methodsParams = _method.getParameterTypes()).length) != parameterTypes.length) continue;
                boolean match = true;
                for (int n = 0; n < methodParamSize; ++n) {
                    if (this.areTheSameParameters(methodsParams[n], parameterTypes[n])) continue;
                    match = false;
                    break;
                }
                if (match && (method = this.getMethod(clazz, _method, onlyCheck)) != null) break;
            }
            if (method == null) {
                if (!onlyCheck) {
                    this.logger.error("getMethod: there's no method " + methodName + " in " + clazz.getName());
                }
            } else {
                Method methodPrev = this.methods.putIfAbsent(keyName, method);
                if (methodPrev != null) {
                    return methodPrev;
                }
            }
            return method;
        }
    }

    protected final boolean areTheSameParameters(Class<?> methodParameterType, Class<?> parameterType) {
        Class<?> parameterWrapperClazz;
        if (methodParameterType.isAssignableFrom(parameterType)) {
            return true;
        }
        if (methodParameterType.isPrimitive() && (parameterWrapperClazz = this.getPrimitiveWrapper(methodParameterType)) != null) {
            return parameterWrapperClazz.equals(parameterType);
        }
        return false;
    }

    protected Class<?> getPrimitiveWrapper(Class<?> primitiveType) {
        if (Boolean.TYPE.equals(primitiveType)) {
            return Boolean.class;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return Float.class;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return Long.class;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            return Integer.class;
        }
        if (Short.TYPE.equals(primitiveType)) {
            return Short.class;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return Byte.class;
        }
        if (Double.TYPE.equals(primitiveType)) {
            return Double.class;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return Character.class;
        }
        return null;
    }

    protected Object invokeMethod(SqlRuntimeContext runtimeCtx, Object bean, Method method, Object ... args) {
        try {
            if (!method.isAccessible()) {
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException se) {
                    this.logger.warn("invokeMethod: " + bean.getClass() + " " + se.getMessage());
                }
            }
            return method.invoke(bean, args);
        }
        catch (IllegalAccessException e) {
            throw new SqlRuntimeException(this.debugInfo("invokeMethod", bean, method, args), e);
        }
        catch (IllegalArgumentException e) {
            throw new SqlRuntimeException(this.debugInfo("invokeMethod", bean, method, args), e);
        }
        catch (InvocationTargetException e) {
            throw new SqlRuntimeException(this.debugInfo("invokeMethod", bean, method, args), e);
        }
    }

    @Override
    public boolean checkMethod(SqlRuntimeContext runtimeCtx, Class<?> clazz, String methodName, Class<?> ... argTypes) {
        return this.getMethod(clazz, methodName, true, argTypes) != null;
    }

    @Override
    public boolean checkMethod(SqlRuntimeContext runtimeCtx, Object bean, String methodName, Object ... args) {
        return this.getMethod(bean.getClass(), methodName, true, this.toParameterTypes(args)) != null;
    }

    @Override
    public Object invokeMethod(SqlRuntimeContext runtimeCtx, Class<?> clazz, String methodName, Object ... args) throws SqlRuntimeException {
        return this.invokeMethod(runtimeCtx, clazz, null, methodName, args);
    }

    @Override
    public Object invokeMethod(SqlRuntimeContext runtimeCtx, Object bean, String methodName, Object ... args) throws SqlRuntimeException {
        return this.invokeMethod(runtimeCtx, bean.getClass(), bean, methodName, args);
    }

    protected Object invokeMethod(SqlRuntimeContext runtimeCtx, Class<?> clazz, Object bean, String methodName, Object ... args) throws SqlRuntimeException {
        Class<?>[] parameterTypes = this.toParameterTypes(args);
        Method method = this.getMethod(clazz, methodName, true, parameterTypes);
        if (method == null) {
            throw new SqlRuntimeException(this.debugInfo("invokeMethod(NoSuchMethodException)", bean, method, args));
        }
        try {
            return method.invoke(bean, args);
        }
        catch (IllegalAccessException e) {
            throw new SqlRuntimeException(this.debugInfo("invokeMethod", bean, method, args), e);
        }
        catch (IllegalArgumentException e) {
            throw new SqlRuntimeException(this.debugInfo("invokeMethod", bean, method, args), e);
        }
        catch (InvocationTargetException e) {
            throw new SqlRuntimeException(this.debugInfo("invokeMethod", bean, method, args), e);
        }
    }

    @Override
    public Object getEnumToValue(SqlRuntimeContext runtimeCtx, Object bean) {
        if (bean == null) {
            return null;
        }
        String keyName = bean.getClass().getName();
        Method method = this.enumsIn.get(keyName);
        if (method != null) {
            return this.invokeMethod(runtimeCtx, bean, method, new Object[0]);
        }
        for (String methodName : runtimeCtx.getFeatures(SqlFeature.METHODS_ENUM_IN.name())) {
            method = this.getMethod(bean.getClass(), methodName, true, new Class[0]);
            if (method != null) break;
        }
        if (method == null) {
            return null;
        }
        this.enumsIn.put(keyName, method);
        return this.invokeMethod(runtimeCtx, bean, method, new Object[0]);
    }

    @Override
    public Class<?> getEnumToClass(SqlRuntimeContext runtimeCtx, Class<?> clazz) {
        String methodName;
        if (clazz == null) {
            return null;
        }
        String keyName = clazz.getName();
        Method method = this.enumsIn.get(keyName);
        if (method != null) {
            return method.getReturnType();
        }
        String[] stringArray = runtimeCtx.getFeatures(SqlFeature.METHODS_ENUM_IN.name());
        int n = stringArray.length;
        for (int i = 0; i < n && (method = this.getMethod(clazz, methodName = stringArray[i], true, new Class[0])) == null; ++i) {
        }
        if (method == null) {
            return null;
        }
        this.enumsIn.put(keyName, method);
        return method.getReturnType();
    }

    @Override
    public Object getValueToEnum(SqlRuntimeContext runtimeCtx, Class<?> clazz, Object val) {
        String methodName;
        if (val == null) {
            return null;
        }
        Class<?>[] parameterTypes = this.toParameterTypes(val);
        String keyName = clazz.getName() + this.attrTypes2String(parameterTypes);
        Method method = this.enumsOut.get(keyName);
        if (method != null) {
            return this.invokeMethod(runtimeCtx, clazz, method, val);
        }
        String[] stringArray = runtimeCtx.getFeatures(SqlFeature.METHODS_ENUM_OUT.name());
        int n = stringArray.length;
        for (int i = 0; i < n && (method = this.getMethod(clazz, methodName = stringArray[i], true, parameterTypes)) == null; ++i) {
        }
        if (method == null) {
            return null;
        }
        this.enumsOut.put(keyName, method);
        return this.invokeMethod(runtimeCtx, clazz, method, val);
    }

    protected String attrTypes2String(Class<?> ... attrTypes) {
        if (attrTypes == null || attrTypes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(".");
        boolean first = true;
        for (Class<?> attrType : attrTypes) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(attrType.getName());
        }
        return sb.toString();
    }

    protected Object[] toArray(Object arg) {
        Object[] args = null;
        if (arg != null) {
            args = new Object[]{arg};
        }
        return args;
    }

    protected Class<?>[] toParameterTypes(Object arg) {
        if (arg == null) {
            return new Class[0];
        }
        return new Class[]{arg.getClass()};
    }

    protected Class<?>[] toParameterTypes(Object[] args) {
        if (args == null) {
            return new Class[0];
        }
        Class[] parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return parameterTypes;
    }

    protected String debugInfo(String msg, Object bean, Method method, Object ... args) {
        StringBuilder sb = new StringBuilder(msg);
        sb.append(": bean=").append(bean != null ? bean.getClass() : "null");
        sb.append(", method=").append(method != null ? method.toString() : "null");
        if (args != null) {
            Class<?>[] parameterTypes = this.toParameterTypes(args);
            sb.append(", args=").append(this.attrTypes2String(parameterTypes));
        }
        if (method != null) {
            sb.append(", method params=").append(method.getParameterTypes() != null ? Arrays.asList(method.getParameterTypes()) : "empty");
        }
        return sb.toString();
    }
}

