/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.xray.model.SamplingRule;
import java.util.Map;

@SdkInternalApi
public class SamplingRuleMarshaller {
    private static final MarshallingInfo<String> RULENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleName").build();
    private static final MarshallingInfo<String> RULEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleARN").build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceARN").build();
    private static final MarshallingInfo<Integer> PRIORITY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Priority").build();
    private static final MarshallingInfo<Double> FIXEDRATE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FixedRate").build();
    private static final MarshallingInfo<Integer> RESERVOIRSIZE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReservoirSize").build();
    private static final MarshallingInfo<String> SERVICENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceName").build();
    private static final MarshallingInfo<String> SERVICETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceType").build();
    private static final MarshallingInfo<String> HOST_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Host").build();
    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HTTPMethod").build();
    private static final MarshallingInfo<String> URLPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("URLPath").build();
    private static final MarshallingInfo<Integer> VERSION_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").build();
    private static final SamplingRuleMarshaller instance = new SamplingRuleMarshaller();

    public static SamplingRuleMarshaller getInstance() {
        return instance;
    }

    public void marshall(SamplingRule samplingRule, ProtocolMarshaller protocolMarshaller) {
        if (samplingRule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(samplingRule.getRuleName(), RULENAME_BINDING);
            protocolMarshaller.marshall(samplingRule.getRuleARN(), RULEARN_BINDING);
            protocolMarshaller.marshall(samplingRule.getResourceARN(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall(samplingRule.getPriority(), PRIORITY_BINDING);
            protocolMarshaller.marshall(samplingRule.getFixedRate(), FIXEDRATE_BINDING);
            protocolMarshaller.marshall(samplingRule.getReservoirSize(), RESERVOIRSIZE_BINDING);
            protocolMarshaller.marshall(samplingRule.getServiceName(), SERVICENAME_BINDING);
            protocolMarshaller.marshall(samplingRule.getServiceType(), SERVICETYPE_BINDING);
            protocolMarshaller.marshall(samplingRule.getHost(), HOST_BINDING);
            protocolMarshaller.marshall(samplingRule.getHTTPMethod(), HTTPMETHOD_BINDING);
            protocolMarshaller.marshall(samplingRule.getURLPath(), URLPATH_BINDING);
            protocolMarshaller.marshall(samplingRule.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall(samplingRule.getAttributes(), ATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

