/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.entities;

import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.ThreadLocalStorage;
import com.amazonaws.xray.entities.Cause;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.TraceID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;

public interface Entity
extends AutoCloseable {
    public static String generateId() {
        String id = Long.toString(ThreadLocalStorage.getRandom().nextLong() >>> 1, 16);
        while (id.length() < 16) {
            id = '0' + id;
        }
        return id;
    }

    public String getName();

    public String getId();

    public void setId(String var1);

    public double getStartTime();

    public void setStartTime(double var1);

    public double getEndTime();

    public void setEndTime(double var1);

    public boolean isFault();

    public void setFault(boolean var1);

    public boolean isError();

    public void setError(boolean var1);

    public String getNamespace();

    public void setNamespace(String var1);

    public ReentrantLock getSubsegmentsLock();

    public void setSubsegmentsLock(ReentrantLock var1);

    public Cause getCause();

    public Map<String, Object> getHttp();

    public void setHttp(Map<String, Object> var1);

    public Map<String, Object> getAws();

    public void setAws(Map<String, Object> var1);

    public Map<String, Object> getSql();

    public void setSql(Map<String, Object> var1);

    public Map<String, Map<String, Object>> getMetadata();

    public void setMetadata(Map<String, Map<String, Object>> var1);

    public Map<String, Object> getAnnotations();

    public void setAnnotations(Map<String, Object> var1);

    public Entity getParent();

    public void setParent(Entity var1);

    public boolean isThrottle();

    public void setThrottle(boolean var1);

    public boolean isInProgress();

    public void setInProgress(boolean var1);

    public TraceID getTraceId();

    public void setTraceId(TraceID var1);

    public String getParentId();

    public void setParentId(String var1);

    public AWSXRayRecorder getCreator();

    public void setCreator(AWSXRayRecorder var1);

    @JsonIgnore
    public Segment getParentSegment();

    public List<Subsegment> getSubsegments();

    public void addSubsegment(Subsegment var1);

    public void addException(Throwable var1);

    public int getReferenceCount();

    public LongAdder getTotalSize();

    public void incrementReferenceCount();

    public boolean decrementReferenceCount();

    public void putHttp(String var1, Object var2);

    public void putAllHttp(Map<String, Object> var1);

    public void putAws(String var1, Object var2);

    public void putAllAws(Map<String, Object> var1);

    public void putSql(String var1, Object var2);

    public void putAllSql(Map<String, Object> var1);

    public void putAnnotation(String var1, String var2);

    public void putAnnotation(String var1, Number var2);

    public void putAnnotation(String var1, Boolean var2);

    public void putMetadata(String var1, Object var2);

    public void putMetadata(String var1, String var2, Object var3);

    public void removeSubsegment(Subsegment var1);

    public boolean isEmitted();

    public void setEmitted(boolean var1);

    public String serialize();

    public String prettySerialize();
}

