/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.entities;

import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.entities.EntityImpl;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.TraceID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SegmentImpl
extends EntityImpl
implements Segment {
    private static final Log logger = LogFactory.getLog(SegmentImpl.class);
    protected String resourceArn;
    protected String user;
    protected String origin;
    protected Map<String, Object> service;
    @JsonIgnore
    private boolean sampled;

    private SegmentImpl() {
    }

    public SegmentImpl(AWSXRayRecorder creator, String name) {
        this(creator, name, new TraceID());
    }

    public SegmentImpl(AWSXRayRecorder creator, String name, TraceID traceId) {
        super(creator, name);
        this.setTraceId(traceId);
        this.service = new ConcurrentHashMap<String, Object>();
        this.sampled = true;
    }

    @Override
    public boolean end() {
        boolean shouldEmit;
        if (this.getEndTime() < Double.MIN_NORMAL) {
            this.setEndTime((double)Instant.now().toEpochMilli() / 1000.0);
        }
        this.setInProgress(false);
        boolean bl = shouldEmit = this.referenceCount.intValue() <= 0;
        if (shouldEmit) {
            this.checkAlreadyEmitted();
            this.setEmitted(true);
        }
        return shouldEmit;
    }

    @Override
    public boolean isSampled() {
        return this.sampled;
    }

    @Override
    public void setSampled(boolean sampled) {
        this.checkAlreadyEmitted();
        this.sampled = sampled;
    }

    @Override
    public String getResourceArn() {
        return this.resourceArn;
    }

    @Override
    public void setResourceArn(String resourceArn) {
        this.checkAlreadyEmitted();
        this.resourceArn = resourceArn;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.checkAlreadyEmitted();
        this.user = user;
    }

    @Override
    public String getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(String origin) {
        this.checkAlreadyEmitted();
        this.origin = origin;
    }

    @Override
    public Map<String, Object> getService() {
        return this.service;
    }

    @Override
    public void setService(Map<String, Object> service) {
        this.checkAlreadyEmitted();
        this.service = service;
    }

    @Override
    public void putService(String key, Object object) {
        this.checkAlreadyEmitted();
        this.service.put(key, object);
    }

    @Override
    public void putAllService(Map<String, Object> all) {
        this.checkAlreadyEmitted();
        this.service.putAll(all);
    }

    @Override
    public void setRuleName(String ruleName) {
        this.checkAlreadyEmitted();
        if (this.getAws().get("xray") instanceof Map) {
            HashMap a = (HashMap)this.getAws().get("xray");
            HashMap<String, String> referA = new HashMap<String, String>(a);
            referA.put("rule_name", ruleName);
            this.putAws("xray", referA);
        }
    }

    @Override
    public Segment getParentSegment() {
        return this;
    }

    @Override
    public void close() {
        this.getCreator().endSegment();
    }
}

