/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy.sampling.pollers;

import com.amazonaws.services.xray.AWSXRay;
import com.amazonaws.services.xray.model.GetSamplingTargetsRequest;
import com.amazonaws.services.xray.model.GetSamplingTargetsResult;
import com.amazonaws.services.xray.model.SamplingStatisticsDocument;
import com.amazonaws.xray.strategy.sampling.manifest.CentralizedManifest;
import com.amazonaws.xray.strategy.sampling.rand.RandImpl;
import java.time.Clock;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TargetPoller {
    private static Log logger = LogFactory.getLog(TargetPoller.class);
    private static final long PERIOD = 10L;
    private static final long MAX_JITTER = 100L;
    private AWSXRay client;
    private Clock clock;
    private CentralizedManifest manifest;

    public TargetPoller(CentralizedManifest m3, AWSXRay client, Clock clock) {
        this.manifest = m3;
        this.client = client;
        this.clock = clock;
    }

    public void start() {
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            try {
                this.pollManifest();
            }
            catch (Exception ex) {
                logger.error("Encountered error polling GetSamplingTargets: ", ex);
            }
        }, 0L, this.getJitterInterval(), TimeUnit.MILLISECONDS);
    }

    private void pollManifest() {
        List<SamplingStatisticsDocument> statistics = this.manifest.snapshots(this.clock.instant());
        if (statistics.size() == 0) {
            logger.trace("No statistics to report. Not refreshing sampling targets.");
            return;
        }
        GetSamplingTargetsRequest req = new GetSamplingTargetsRequest().withSamplingStatisticsDocuments(statistics);
        GetSamplingTargetsResult result = this.client.getSamplingTargets(req);
        this.manifest.putTargets(result.getSamplingTargetDocuments(), this.clock.instant());
    }

    private long getJitterInterval() {
        RandImpl random = new RandImpl();
        long interval = Math.round(random.next() * 100.0) + 10000L;
        return interval;
    }
}

