/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy.sampling.reservoir;

import com.amazonaws.services.xray.model.SamplingRule;
import com.amazonaws.services.xray.model.SamplingTargetDocument;
import java.time.Instant;

public class CentralizedReservoir {
    private static final long DEFAULT_INTERVAL = 10L;
    private long capacity;
    private long quota;
    private long used;
    private long currentEpoch;
    private long interval;
    private boolean borrow;
    private Instant refreshedAt;
    private Instant expiresAt;

    public CentralizedReservoir(long capacity) {
        this.capacity = capacity;
        this.expiresAt = Instant.EPOCH;
        this.refreshedAt = Instant.EPOCH;
        this.interval = 10L;
    }

    public void update(SamplingRule r) {
        this.capacity = r.getReservoirSize().longValue();
    }

    public boolean isExpired(Instant now) {
        return now.isAfter(this.expiresAt);
    }

    public boolean isBorrow(Instant now) {
        if (now.getEpochSecond() != this.currentEpoch) {
            this.reset(now);
        }
        boolean b = this.borrow;
        this.borrow = true;
        return !b && this.capacity != 0L;
    }

    public boolean isStale(Instant now) {
        return now.isAfter(this.refreshedAt.plusSeconds(this.interval));
    }

    public void update(SamplingTargetDocument target, Instant now) {
        if (target.getReservoirQuota() != null) {
            this.quota = target.getReservoirQuota().intValue();
        }
        if (target.getReservoirQuotaTTL() != null) {
            this.expiresAt = target.getReservoirQuotaTTL().toInstant();
        }
        if (target.getInterval() != null) {
            this.interval = target.getInterval().intValue();
        }
        this.refreshedAt = now;
    }

    public boolean take(Instant now) {
        if (now.getEpochSecond() != this.currentEpoch) {
            this.reset(now);
        }
        if (this.quota > this.used) {
            ++this.used;
            return true;
        }
        return false;
    }

    void reset(Instant now) {
        this.currentEpoch = now.getEpochSecond();
        this.used = 0L;
        this.borrow = false;
    }

    public long getQuota() {
        return this.quota;
    }

    public long getUsed() {
        return this.used;
    }

    public long getCurrentEpoch() {
        return this.currentEpoch;
    }

    public long getInterval() {
        return this.interval;
    }
}

