/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.translate;

import com.google.api.GoogleAPI;
import com.google.api.translate.Language;
import com.tecnick.htmlutils.htmlentities.HTMLEntities;
import java.net.URL;
import java.net.URLEncoder;
import org.json.JSONArray;
import org.json.JSONObject;

public final class Translate
extends GoogleAPI {
    private static final String LANG_PARAM = "&langpair=";
    private static final String TEXT_PARAM = "&q=";
    private static final String PIPE_PARAM = "%7C";
    private static final String URL = "http://ajax.googleapis.com/ajax/services/language/translate";
    private static final String PARAMETERS = "v=1.0&langpair=#FROM#%7C#TO#&q=";

    public static String execute(String text, Language from, Language to) throws Exception {
        Translate.validateReferrer();
        URL url = new URL(URL);
        String parameters = PARAMETERS.replaceAll("#FROM#", from.toString()).replaceAll("#TO#", to.toString()) + URLEncoder.encode(text, "UTF-8");
        JSONObject json = Translate.retrieveJSON(url, parameters);
        return Translate.getJSONResponse(json);
    }

    public static String[] execute(String[] text, Language from, Language to) throws Exception {
        Translate.validateReferrer();
        Language[] fromArgs = new Language[text.length];
        Language[] toArgs = new Language[text.length];
        for (int i = 0; i < text.length; ++i) {
            fromArgs[i] = from;
            toArgs[i] = to;
        }
        return Translate.execute(text, fromArgs, toArgs);
    }

    public static String[] execute(String text, Language from, Language[] to) throws Exception {
        Translate.validateReferrer();
        String[] textArgs = new String[to.length];
        Language[] fromArgs = new Language[to.length];
        for (int i = 0; i < to.length; ++i) {
            textArgs[i] = text;
            fromArgs[i] = from;
        }
        return Translate.execute(textArgs, fromArgs, to);
    }

    public static String[] execute(String[] text, Language[] from, Language[] to) throws Exception {
        Translate.validateReferrer();
        if (text.length != from.length || from.length != to.length) {
            throw new Exception("[google-api-translate-java] The same number of texts, from and to languages must be supplied.");
        }
        if (text.length == 1) {
            return new String[]{Translate.execute(text[0], from[0], to[0])};
        }
        String[] responses = new String[text.length];
        StringBuilder parametersBuilder = new StringBuilder();
        parametersBuilder.append(PARAMETERS.replaceAll("#FROM#", from[0].toString()).replaceAll("#TO#", to[0].toString()));
        parametersBuilder.append(URLEncoder.encode(text[0], "UTF-8"));
        for (int i = 1; i < text.length; ++i) {
            parametersBuilder.append(LANG_PARAM);
            parametersBuilder.append(from[i].toString());
            parametersBuilder.append(PIPE_PARAM);
            parametersBuilder.append(to[i].toString());
            parametersBuilder.append(TEXT_PARAM);
            parametersBuilder.append(URLEncoder.encode(text[i].toString(), "UTF-8"));
        }
        URL url = new URL(URL);
        JSONArray json = Translate.retrieveJSON(url, parametersBuilder.toString()).getJSONArray("responseData");
        for (int i = 0; i < json.length(); ++i) {
            JSONObject obj = json.getJSONObject(i);
            responses[i] = Translate.getJSONResponse(obj);
        }
        return responses;
    }

    private static String getJSONResponse(JSONObject json) throws Exception {
        if (json.getString("responseStatus").equals("200")) {
            String translatedText = json.getJSONObject("responseData").getString("translatedText");
            return HTMLEntities.unhtmlentities(translatedText);
        }
        throw new Exception("Google returned the following error: [" + json.getString("responseStatus") + "] " + json.getString("responseDetails"));
    }

    @Deprecated
    public static String translate(String text, Language from, Language to) throws Exception {
        return Translate.execute(text, from, to);
    }
}

