/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm;

import com.googlecode.jpattern.logger.ILogger;
import com.googlecode.jpattern.orm.IJPOrm;
import com.googlecode.jpattern.orm.IOrmClassToolMap;
import com.googlecode.jpattern.orm.IOrmPersistor;
import com.googlecode.jpattern.orm.OrmClassTool;
import com.googlecode.jpattern.orm.OrmClassToolMap;
import com.googlecode.jpattern.orm.crud.IOrmCRUDQuery;
import com.googlecode.jpattern.orm.crud.OrmCRUDQueryGenerator;
import com.googlecode.jpattern.orm.dialect.DefaultDialect;
import com.googlecode.jpattern.orm.dialect.IDialect;
import com.googlecode.jpattern.orm.exception.OrmConfigurationException;
import com.googlecode.jpattern.orm.generator.CojenPersistorGenerator;
import com.googlecode.jpattern.orm.logger.OrmLogger;
import com.googlecode.jpattern.orm.mapper.ClassMapperBuilder;
import com.googlecode.jpattern.orm.mapper.ClassTableMapBuilder;
import com.googlecode.jpattern.orm.mapper.IClassMapper;
import com.googlecode.jpattern.orm.mapper.TableMap;
import com.googlecode.jpattern.orm.session.ISession;
import com.googlecode.jpattern.orm.session.ISessionProvider;

public class JPOrm
implements IJPOrm {
    private final ISessionProvider sessionProvider;
    private IOrmClassToolMap ormClassToolMap = new OrmClassToolMap();
    private ILogger logger = OrmLogger.getOrmLogger(this.getClass());
    private final IDialect dialect;

    public JPOrm(ISessionProvider sessionProvider) {
        this(sessionProvider, new DefaultDialect());
    }

    public JPOrm(ISessionProvider sessionProvider, IDialect dialect) {
        this.sessionProvider = sessionProvider;
        this.dialect = dialect;
    }

    @Override
    public ISession session() {
        return this.sessionProvider.getSession(this.ormClassToolMap);
    }

    @Override
    public <T> void register(Class<T> clazz) throws OrmConfigurationException {
        this.register(clazz, true);
    }

    @Override
    public <T> void register(Class<T> clazz, boolean enableDBScan) throws OrmConfigurationException {
        this.logger.info("register", "register new class: " + clazz.getName());
        try {
            TableMap tableMap = new TableMap();
            new ClassTableMapBuilder(clazz, tableMap).updateTableMap();
            this.sessionProvider.updateTableMap(tableMap, enableDBScan);
            IClassMapper<T> classMapper = new ClassMapperBuilder<T>(clazz, tableMap).generate();
            IOrmPersistor<T> ormPersistor = new CojenPersistorGenerator<T>(classMapper).generate();
            IOrmCRUDQuery ormCRUDQuery = new OrmCRUDQueryGenerator<T>(this.dialect, classMapper).generate();
            OrmClassTool<T> ormClassTool = new OrmClassTool<T>(classMapper, ormPersistor, ormCRUDQuery);
            this.ormClassToolMap.put(clazz, ormClassTool);
        }
        catch (Exception e) {
            throw new OrmConfigurationException(e);
        }
    }
}

