/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.generator;

import com.googlecode.jpattern.orm.exception.OrmConfigurationException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public final class MethodHelper {
    private static boolean initialized = false;
    private static Map<Class<?>, Method> resultSetGetterForInt = new HashMap();
    private static Map<Class<?>, Method> resultSetGetterForString = new HashMap();

    private static void init() throws SecurityException, NoSuchMethodException {
        if (!initialized) {
            MethodHelper.addGetter(Array.class, "getArray");
            MethodHelper.addGetter(BigDecimal.class, "getBigDecimal");
            MethodHelper.addGetter(InputStream.class, "getBinaryStream");
            MethodHelper.addGetter(Blob.class, "getBlob");
            MethodHelper.addGetter(Boolean.TYPE, "getBoolean");
            MethodHelper.addGetter(Boolean.class, "getBoolean");
            MethodHelper.addGetter(Byte.TYPE, "getByte");
            MethodHelper.addGetter(Byte.class, "getByte");
            MethodHelper.addGetter(byte[].class, "getBytes");
            MethodHelper.addGetter(Reader.class, "getCharacterStream");
            MethodHelper.addGetter(Clob.class, "getClob");
            MethodHelper.addGetter(Date.class, "getDate");
            MethodHelper.addGetter(Double.TYPE, "getDouble");
            MethodHelper.addGetter(Double.class, "getDouble");
            MethodHelper.addGetter(Float.TYPE, "getFloat");
            MethodHelper.addGetter(Float.class, "getFloat");
            MethodHelper.addGetter(Integer.TYPE, "getInt");
            MethodHelper.addGetter(Integer.class, "getInt");
            MethodHelper.addGetter(Long.TYPE, "getLong");
            MethodHelper.addGetter(Long.class, "getLong");
            MethodHelper.addGetter(NClob.class, "getNClob");
            MethodHelper.addGetter(Object.class, "getObject");
            MethodHelper.addGetter(Ref.class, "getRef");
            MethodHelper.addGetter(RowId.class, "getRowId");
            MethodHelper.addGetter(Short.TYPE, "getShort");
            MethodHelper.addGetter(Short.class, "getShort");
            MethodHelper.addGetter(SQLXML.class, "getSQLXML");
            MethodHelper.addGetter(String.class, "getString");
            MethodHelper.addGetter(Time.class, "getTime");
            MethodHelper.addGetter(Timestamp.class, "getTimestamp");
            MethodHelper.addGetter(URL.class, "getURL");
        }
    }

    public static final Method findResultSetGetterForString(Class<?> type) throws SecurityException, NoSuchMethodException, OrmConfigurationException {
        MethodHelper.init();
        if (resultSetGetterForString.containsKey(type)) {
            return resultSetGetterForString.get(type);
        }
        throw new OrmConfigurationException("Type [" + type + "] is not supported at this time");
    }

    public static final Method findResultSetGetterForInt(Class<?> type) throws SecurityException, NoSuchMethodException, OrmConfigurationException {
        MethodHelper.init();
        if (resultSetGetterForInt.containsKey(type)) {
            return resultSetGetterForInt.get(type);
        }
        throw new OrmConfigurationException("Type [" + type + "] is not supported at this time");
    }

    private static void addGetter(Class<?> key, String resultSetMethodName) throws SecurityException, NoSuchMethodException {
        resultSetGetterForInt.put(key, ResultSet.class.getMethod(resultSetMethodName, Integer.TYPE));
        resultSetGetterForString.put(key, ResultSet.class.getMethod(resultSetMethodName, String.class));
    }
}

