/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.query;

import com.googlecode.jpattern.orm.IOrmClassToolMap;
import com.googlecode.jpattern.orm.query.IJoin;
import com.googlecode.jpattern.orm.query.INameSolver;
import com.googlecode.jpattern.orm.query.NullNameSolver;
import com.googlecode.jpattern.orm.query.join.CrossJoinElement;
import com.googlecode.jpattern.orm.query.join.FullOuterJoinElement;
import com.googlecode.jpattern.orm.query.join.IJoinElement;
import com.googlecode.jpattern.orm.query.join.InnerJoinElement;
import com.googlecode.jpattern.orm.query.join.LeftOuterJoinElement;
import com.googlecode.jpattern.orm.query.join.NaturalJoinElement;
import com.googlecode.jpattern.orm.query.join.RightOuterJoinElement;
import java.util.ArrayList;
import java.util.List;

public class Join
implements IJoin {
    private INameSolver nameSolver = new NullNameSolver();
    private List<IJoinElement> joinElements = new ArrayList<IJoinElement>();
    private final IOrmClassToolMap ormClassToolMap;

    public Join(IOrmClassToolMap ormClassToolMap) {
        this.ormClassToolMap = ormClassToolMap;
    }

    @Override
    public IJoin cross(Class<?> joinClass) {
        return this.cross(joinClass, joinClass.getSimpleName());
    }

    @Override
    public IJoin cross(Class<?> joinClass, String joinClassAlias) {
        CrossJoinElement joinElement = new CrossJoinElement(this.ormClassToolMap, joinClass);
        this.nameSolver.register(joinClass, joinClassAlias);
        joinElement.setNameSolver(this.nameSolver);
        this.joinElements.add(joinElement);
        return this;
    }

    @Override
    public IJoin natural(Class<?> joinClass) {
        return this.natural(joinClass, joinClass.getSimpleName());
    }

    @Override
    public IJoin natural(Class<?> joinClass, String joinClassAlias) {
        NaturalJoinElement joinElement = new NaturalJoinElement(this.ormClassToolMap, joinClass);
        this.nameSolver.register(joinClass, joinClassAlias);
        joinElement.setNameSolver(this.nameSolver);
        this.joinElements.add(joinElement);
        return this;
    }

    @Override
    public IJoin inner(Class<?> joinClass) {
        return this.inner(joinClass, joinClass.getSimpleName());
    }

    @Override
    public IJoin inner(Class<?> joinClass, String joinClassAlias) {
        InnerJoinElement joinElement = new InnerJoinElement(this.ormClassToolMap, joinClass);
        this.nameSolver.register(joinClass, joinClassAlias);
        joinElement.setNameSolver(this.nameSolver);
        this.joinElements.add(joinElement);
        return this;
    }

    @Override
    public IJoin inner(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
        return this.inner(joinClass, joinClass.getSimpleName(), onLeftProperty, onRigthProperty);
    }

    @Override
    public IJoin inner(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
        InnerJoinElement joinElement = new InnerJoinElement(this.ormClassToolMap, joinClass, onLeftProperty, onRigthProperty);
        this.nameSolver.register(joinClass, joinClassAlias);
        joinElement.setNameSolver(this.nameSolver);
        this.joinElements.add(joinElement);
        return this;
    }

    @Override
    public IJoin leftOuter(Class<?> joinClass) {
        return this.leftOuter(joinClass, joinClass.getSimpleName());
    }

    @Override
    public IJoin leftOuter(Class<?> joinClass, String joinClassAlias) {
        LeftOuterJoinElement joinElement = new LeftOuterJoinElement(this.ormClassToolMap, joinClass);
        this.nameSolver.register(joinClass, joinClassAlias);
        joinElement.setNameSolver(this.nameSolver);
        this.joinElements.add(joinElement);
        return this;
    }

    @Override
    public IJoin leftOuter(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
        return this.leftOuter(joinClass, joinClass.getSimpleName(), onLeftProperty, onRigthProperty);
    }

    @Override
    public IJoin leftOuter(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
        LeftOuterJoinElement joinElement = new LeftOuterJoinElement(this.ormClassToolMap, joinClass, onLeftProperty, onRigthProperty);
        this.nameSolver.register(joinClass, joinClassAlias);
        joinElement.setNameSolver(this.nameSolver);
        this.joinElements.add(joinElement);
        return this;
    }

    @Override
    public IJoin rightOuter(Class<?> joinClass) {
        return this.rightOuter(joinClass, joinClass.getSimpleName());
    }

    @Override
    public IJoin rightOuter(Class<?> joinClass, String joinClassAlias) {
        RightOuterJoinElement joinElement = new RightOuterJoinElement(this.ormClassToolMap, joinClass);
        this.nameSolver.register(joinClass, joinClassAlias);
        joinElement.setNameSolver(this.nameSolver);
        this.joinElements.add(joinElement);
        return this;
    }

    @Override
    public IJoin rightOuter(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
        return this.rightOuter(joinClass, joinClass.getSimpleName(), onLeftProperty, onRigthProperty);
    }

    @Override
    public IJoin rightOuter(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
        RightOuterJoinElement joinElement = new RightOuterJoinElement(this.ormClassToolMap, joinClass, onLeftProperty, onRigthProperty);
        this.nameSolver.register(joinClass, joinClassAlias);
        joinElement.setNameSolver(this.nameSolver);
        this.joinElements.add(joinElement);
        return this;
    }

    @Override
    public IJoin fullOuter(Class<?> joinClass) {
        return this.fullOuter(joinClass, joinClass.getSimpleName());
    }

    @Override
    public IJoin fullOuter(Class<?> joinClass, String joinClassAlias) {
        FullOuterJoinElement joinElement = new FullOuterJoinElement(this.ormClassToolMap, joinClass);
        this.nameSolver.register(joinClass, joinClassAlias);
        joinElement.setNameSolver(this.nameSolver);
        this.joinElements.add(joinElement);
        return this;
    }

    @Override
    public IJoin fullOuter(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
        return this.fullOuter(joinClass, joinClass.getSimpleName(), onLeftProperty, onRigthProperty);
    }

    @Override
    public IJoin fullOuter(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
        FullOuterJoinElement joinElement = new FullOuterJoinElement(this.ormClassToolMap, joinClass, onLeftProperty, onRigthProperty);
        this.nameSolver.register(joinClass, joinClassAlias);
        joinElement.setNameSolver(this.nameSolver);
        this.joinElements.add(joinElement);
        return this;
    }

    @Override
    public void setNameSolver(INameSolver nameSolver) {
        this.nameSolver = nameSolver;
    }

    @Override
    public String renderSql() {
        StringBuffer query = new StringBuffer();
        this.renderSql(query);
        return query.toString();
    }

    @Override
    public void renderSql(StringBuffer stringBuffer) {
        for (IJoinElement joinElement : this.joinElements) {
            joinElement.renderSql(stringBuffer);
        }
    }
}

