/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.query;

import com.googlecode.jpattern.orm.IOrmClassToolMap;
import com.googlecode.jpattern.orm.exception.OrmException;
import com.googlecode.jpattern.orm.exception.OrmNotUniqueResultException;
import com.googlecode.jpattern.orm.query.ABaseOrmQuery;
import com.googlecode.jpattern.orm.query.INameSolver;
import com.googlecode.jpattern.orm.query.INameSolverConsumer;
import com.googlecode.jpattern.orm.query.IOrmCustomQuery;
import com.googlecode.jpattern.orm.query.ISelectClause;
import com.googlecode.jpattern.orm.query.Join;
import com.googlecode.jpattern.orm.query.NullNameSolver;
import com.googlecode.jpattern.orm.query.SelectClause;
import com.googlecode.jpattern.orm.session.IResultSetReader;
import com.googlecode.jpattern.orm.session.ISessionSqlPerformer;
import com.googlecode.jpattern.orm.session.ISqlPerformer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class OrmCustomQuery
extends ABaseOrmQuery
implements IOrmCustomQuery,
INameSolverConsumer {
    private INameSolver nameSolver = new NullNameSolver();
    private final ISelectClause select;
    private final IOrmClassToolMap ormClassToolMap;
    private final Class<?> clazz;
    private final Class<?>[] joinClasses;
    private final ISessionSqlPerformer session;

    public OrmCustomQuery(String selectClause, IOrmClassToolMap ormClassToolMap, ISessionSqlPerformer session, Class<?> clazz, Class<?> ... joinClasses) {
        this.ormClassToolMap = ormClassToolMap;
        this.session = session;
        this.clazz = clazz;
        this.joinClasses = joinClasses;
        this.setJoin(new Join(ormClassToolMap));
        this.select = new SelectClause(selectClause);
    }

    @Override
    public void setNameSolver(INameSolver nameSolver) {
        this.nameSolver = nameSolver;
        this.where().setNameSolver(nameSolver);
        this.orderBy().setNameSolver(nameSolver);
        this.join().setNameSolver(nameSolver);
        this.select.setNameSolver(nameSolver);
    }

    @Override
    public List<Object[]> findList() {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForList(this.renderSql(), values.toArray());
    }

    @Override
    public Object[] findUnique() throws OrmNotUniqueResultException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForArray(this.renderSql(), values.toArray());
    }

    @Override
    protected void renderSelect(StringBuffer stringBuffer) {
        this.select.renderSql(stringBuffer);
    }

    @Override
    protected void renderFrom(StringBuffer stringBuffer) {
        String alias = this.nameSolver.alias(this.clazz);
        stringBuffer.append("FROM ");
        stringBuffer.append(this.ormClassToolMap.getOrmClassTool(this.clazz).getClassMapper().getTableMap().getTableNameWithSchema());
        stringBuffer.append(" ");
        stringBuffer.append(alias);
        stringBuffer.append(" ");
        this.join().renderSql(stringBuffer);
        if (this.joinClasses != null && this.joinClasses.length > 0) {
            for (Class<?> joinClass : this.joinClasses) {
                stringBuffer.append(", ");
                stringBuffer.append(this.ormClassToolMap.getOrmClassTool(joinClass).getClassMapper().getTableMap().getTableNameWithSchema());
                stringBuffer.append(" ");
                stringBuffer.append(this.nameSolver.alias(joinClass));
            }
            stringBuffer.append(" ");
        }
    }

    @Override
    protected void renderWhere(StringBuffer stringBuffer) {
        this.where().renderSql(stringBuffer);
    }

    @Override
    protected void renderOrderBy(StringBuffer stringBuffer) {
        this.orderBy().renderSql(stringBuffer);
    }

    @Override
    public <T> T find(IResultSetReader<T> rse) throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.query(this.renderSql(), rse, values.toArray());
    }

    @Override
    public int findInt() throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForInt(this.renderSql(), values.toArray());
    }

    @Override
    public long findLong() throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForLong(this.renderSql(), values.toArray());
    }

    @Override
    public double findDouble() throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForDouble(this.renderSql(), values.toArray());
    }

    @Override
    public float findFloat() throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForFloat(this.renderSql(), values.toArray());
    }

    @Override
    public String findString() throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForString(this.renderSql(), values.toArray());
    }

    @Override
    public boolean findBoolean() throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForBoolean(this.renderSql(), values.toArray());
    }

    @Override
    public BigDecimal findBigDecimal() throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForBigDecimal(this.renderSql(), values.toArray());
    }
}

