/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.query;

import com.googlecode.jpattern.orm.query.INameSolver;
import com.googlecode.jpattern.orm.query.ISelectClause;
import com.googlecode.jpattern.orm.query.NullNameSolver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SelectClause
implements ISelectClause {
    private static Pattern patternProperty = Pattern.compile("[a-zA-Z_0-9]+[\\.][a-zA-Z_0-9]+[\\.][a-zA-Z_0-9]+|[a-zA-Z_0-9]+[\\.][a-zA-Z_0-9]+");
    private final String selectClause;
    private INameSolver nameSolver = new NullNameSolver();

    public SelectClause(String selectClause) {
        this.selectClause = selectClause;
    }

    @Override
    public String renderSql() {
        StringBuffer query = new StringBuffer();
        this.renderSql(query);
        return query.toString();
    }

    @Override
    public void renderSql(StringBuffer stringBuffer) {
        stringBuffer.append("SELECT ");
        this.solveProperties(stringBuffer, this.selectClause);
        stringBuffer.append(" ");
    }

    @Override
    public void setNameSolver(INameSolver nameSolver) {
        this.nameSolver = nameSolver;
    }

    private void solveProperties(StringBuffer stringBuffer, String token) {
        Matcher m = patternProperty.matcher(token);
        int beginIndex = 0;
        while (m.find()) {
            stringBuffer.append(token.substring(beginIndex, m.start()));
            stringBuffer.append(this.nameSolver.solvePropertyName(m.group(), m.group()));
            beginIndex = m.end();
        }
        stringBuffer.append(token.substring(beginIndex, token.length()));
    }
}

