/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.query.sql;

import com.googlecode.jpattern.orm.exception.OrmException;
import com.googlecode.jpattern.orm.exception.OrmNotUniqueResultException;
import com.googlecode.jpattern.orm.query.AQuery;
import com.googlecode.jpattern.orm.query.ISqlQuery;
import com.googlecode.jpattern.orm.session.IResultSetReader;
import com.googlecode.jpattern.orm.session.ISessionSqlPerformer;
import com.googlecode.jpattern.orm.session.ISqlPerformer;
import java.math.BigDecimal;
import java.util.List;

public class SqlQuery
extends AQuery
implements ISqlQuery {
    private final ISessionSqlPerformer session;
    private final String sql;
    private final Object[] args;

    public SqlQuery(ISessionSqlPerformer session, String sql, Object[] args) {
        this.session = session;
        this.sql = sql;
        this.args = args;
    }

    @Override
    public <T> T find(IResultSetReader<T> rse) throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.query(this.renderSql(), rse, this.args);
    }

    @Override
    public List<Object[]> findList() throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForList(this.renderSql(), this.args);
    }

    @Override
    public Object[] findUnique() throws OrmNotUniqueResultException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForArray(this.renderSql(), this.args);
    }

    @Override
    public int findInt() throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForInt(this.renderSql(), this.args);
    }

    @Override
    public long findLong() throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForLong(this.renderSql(), this.args);
    }

    @Override
    public double findDouble() throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForDouble(this.renderSql(), this.args);
    }

    @Override
    public float findFloat() throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForFloat(this.renderSql(), this.args);
    }

    @Override
    public String findString() throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForString(this.renderSql(), this.args);
    }

    @Override
    public boolean findBoolean() throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForBoolean(this.renderSql(), this.args);
    }

    @Override
    public BigDecimal findBigDecimal() throws OrmException {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForBigDecimal(this.renderSql(), this.args);
    }

    @Override
    public void appendValues(List<Object> values) {
        for (Object object : this.args) {
            values.add(object);
        }
    }

    @Override
    public String renderSql() {
        return this.sql;
    }

    @Override
    public void renderSql(StringBuffer stringBuffer) {
        stringBuffer.append(this.sql);
    }
}

