/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.util;

public abstract class FieldDefaultNaming {
    public static String getDefaultMappingNameForMethod(String javaName) {
        String result = "";
        String[] prefixs = new String[]{"get", "set", "is"};
        boolean found = false;
        for (String prefix : prefixs) {
            result = FieldDefaultNaming.removePrefix(prefix, javaName);
            boolean bl = found = !result.equalsIgnoreCase(javaName);
            if (found) break;
        }
        if (!found) {
            return "";
        }
        return FieldDefaultNaming.getJavanameToDBnameDefaultMapping(result);
    }

    public static String getJavanameToDBnameDefaultMapping(String javaName) {
        StringBuffer result = new StringBuffer();
        if (javaName.length() > 0) {
            result.append(javaName.charAt(0));
            for (int i = 1; i < javaName.length(); ++i) {
                if (Character.isUpperCase(javaName.charAt(i))) {
                    result.append("_");
                }
                result.append(javaName.charAt(i));
            }
        }
        return result.toString().toUpperCase();
    }

    public static String getDBnameToJavanameDefaultMapping(String dbName, boolean startWithUpperCase) {
        StringBuffer result = new StringBuffer();
        boolean upperCase = startWithUpperCase;
        for (int i = 0; i < dbName.length(); ++i) {
            Character character = new Character(dbName.charAt(i));
            if (character.charValue() == '_') {
                upperCase = true;
                continue;
            }
            if (!Character.isLetterOrDigit(character.charValue())) continue;
            if (upperCase) {
                result.append(Character.toUpperCase(character.charValue()));
                upperCase = false;
                continue;
            }
            result.append(Character.toLowerCase(character.charValue()));
        }
        return result.toString();
    }

    public static String removePrefix(String prefix, String methodName) {
        if (methodName.startsWith(prefix)) {
            return methodName.substring(prefix.length(), methodName.length());
        }
        return methodName;
    }

    public static String getDefaultGetterName(String javaPropertyName) {
        return "get" + javaPropertyName.substring(0, 1).toUpperCase() + javaPropertyName.substring(1);
    }

    public static String getDefaultSetterName(String javaPropertyName) {
        return "set" + javaPropertyName.substring(0, 1).toUpperCase() + javaPropertyName.substring(1);
    }

    public static String getDefaultBooleanGetterName(String javaPropertyName) {
        return "is" + javaPropertyName.substring(0, 1).toUpperCase() + javaPropertyName.substring(1);
    }
}

