/*
 * Decompiled with CFR 0.152.
 */
package com.testmonitor.actions;

import com.testmonitor.api.Connector;
import com.testmonitor.parsers.TestResultParser;
import com.testmonitor.resources.Project;
import com.testmonitor.resources.TestResult;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class TestResults {
    private final Connector connector;
    private final Integer projectId;

    public TestResults(Connector connector, Project project) {
        this.connector = connector;
        this.projectId = project.getId();
    }

    public ArrayList<TestResult> list() throws IOException, URISyntaxException {
        return this.list(1);
    }

    public ArrayList<TestResult> list(Integer page) throws IOException, URISyntaxException {
        return this.list(page, 15);
    }

    public ArrayList<TestResult> list(Integer page, Integer limit) throws IOException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        params.add(new BasicNameValuePair("page", page.toString()));
        params.add(new BasicNameValuePair("limit", limit.toString()));
        return TestResultParser.parse(this.connector.get("test-results", params));
    }

    public TestResult get(Integer id) throws IOException {
        JSONObject response = this.connector.get("test-results/" + id);
        HashMap testResult = (HashMap)response.getJSONObject("data").toMap();
        return TestResultParser.parse(testResult);
    }

    public ArrayList<TestResult> search(String query) throws IOException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        params.add(new BasicNameValuePair("query", this.projectId.toString()));
        return TestResultParser.parse(this.connector.get("test-results", params));
    }

    public TestResult create(TestResult testResult) throws IOException {
        JSONObject response = this.connector.post("test-results", testResult.toHttpParams());
        HashMap newTestResult = (HashMap)response.getJSONObject("data").toMap();
        return TestResultParser.parse(newTestResult);
    }

    public TestResult update(TestResult testResult) throws IOException {
        JSONObject response = this.connector.put("test-results/" + testResult.getId(), testResult.toHttpParams());
        HashMap updatedTestResult = (HashMap)response.getJSONObject("data").toMap();
        return TestResultParser.parse(updatedTestResult);
    }

    public TestResult addAttachment(TestResult testResult, File attachment) throws IOException {
        this.connector.postAttachment("test-result/" + testResult.getId() + "/attachments", attachment);
        return testResult;
    }
}

