/*
 * Decompiled with CFR 0.152.
 */
package com.codevasp.lazysodium.interfaces;

import com.codevasp.lazysodium.exceptions.SodiumException;
import com.codevasp.lazysodium.interfaces.Hash;
import com.codevasp.lazysodium.utils.BaseChecker;
import com.codevasp.lazysodium.utils.Key;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public interface Auth {
    public static final int HMACSHA512256_BYTES = 32;
    public static final int HMACSHA512256_KEYBYTES = 32;
    public static final int HMACSHA256_BYTES = 32;
    public static final int HMACSHA256_KEYBYTES = 32;
    public static final int HMACSHA512_BYTES = 64;
    public static final int HMACSHA512_KEYBYTES = 32;
    public static final int BYTES = 32;
    public static final int KEYBYTES = 32;

    public static class StateHMAC512256
    extends Structure {
        public Hash.State512 ictx;
        public Hash.State512 octx;

        protected List<String> getFieldOrder() {
            return Arrays.asList("ictx", "octx");
        }
    }

    public static class StateHMAC512
    extends Structure {
        public Hash.State512 ictx;
        public Hash.State512 octx;

        protected List<String> getFieldOrder() {
            return Arrays.asList("ictx", "octx");
        }
    }

    public static class StateHMAC256
    extends Structure {
        public Hash.State256 ictx;
        public Hash.State256 octx;

        protected List<String> getFieldOrder() {
            return Arrays.asList("ictx", "octx");
        }
    }

    public static class Checker
    extends BaseChecker {
    }

    public static interface Lazy {
        public Key cryptoAuthKeygen();

        public String cryptoAuth(String var1, Key var2) throws SodiumException;

        public boolean cryptoAuthVerify(String var1, String var2, Key var3) throws SodiumException;

        public Key cryptoAuthHMACShaKeygen(Type var1);

        public String cryptoAuthHMACSha(Type var1, String var2, Key var3);

        public boolean cryptoAuthHMACShaVerify(Type var1, String var2, String var3, Key var4);

        public boolean cryptoAuthHMACShaInit(StateHMAC256 var1, Key var2);

        public boolean cryptoAuthHMACShaUpdate(StateHMAC256 var1, String var2);

        public String cryptoAuthHMACShaFinal(StateHMAC256 var1) throws SodiumException;

        public boolean cryptoAuthHMACShaInit(StateHMAC512 var1, Key var2);

        public boolean cryptoAuthHMACShaUpdate(StateHMAC512 var1, String var2);

        public String cryptoAuthHMACShaFinal(StateHMAC512 var1) throws SodiumException;

        public boolean cryptoAuthHMACShaInit(StateHMAC512256 var1, Key var2);

        public boolean cryptoAuthHMACShaUpdate(StateHMAC512256 var1, String var2);

        public String cryptoAuthHMACShaFinal(StateHMAC512256 var1) throws SodiumException;
    }

    public static interface Native {
        public void cryptoAuthKeygen(byte[] var1);

        public boolean cryptoAuth(byte[] var1, byte[] var2, long var3, byte[] var5);

        public boolean cryptoAuthVerify(byte[] var1, byte[] var2, long var3, byte[] var5);

        public void cryptoAuthHMACSha256Keygen(byte[] var1);

        public boolean cryptoAuthHMACSha256(byte[] var1, byte[] var2, long var3, byte[] var5);

        public boolean cryptoAuthHMACSha256Verify(byte[] var1, byte[] var2, long var3, byte[] var5);

        public boolean cryptoAuthHMACSha256Init(StateHMAC256 var1, byte[] var2, int var3);

        public boolean cryptoAuthHMACSha256Update(StateHMAC256 var1, byte[] var2, long var3);

        public boolean cryptoAuthHMACSha256Final(StateHMAC256 var1, byte[] var2);

        public void cryptoAuthHMACSha512Keygen(byte[] var1);

        public boolean cryptoAuthHMACSha512(byte[] var1, byte[] var2, long var3, byte[] var5);

        public boolean cryptoAuthHMACSha512Verify(byte[] var1, byte[] var2, long var3, byte[] var5);

        public boolean cryptoAuthHMACSha512Init(StateHMAC512 var1, byte[] var2, int var3);

        public boolean cryptoAuthHMACSha512Update(StateHMAC512 var1, byte[] var2, long var3);

        public boolean cryptoAuthHMACSha512Final(StateHMAC512 var1, byte[] var2);

        public void cryptoAuthHMACSha512256Keygen(byte[] var1);

        public boolean cryptoAuthHMACSha512256(byte[] var1, byte[] var2, long var3, byte[] var5);

        public boolean cryptoAuthHMACSha512256Verify(byte[] var1, byte[] var2, long var3, byte[] var5);

        public boolean cryptoAuthHMACSha512256Init(StateHMAC512256 var1, byte[] var2, int var3);

        public boolean cryptoAuthHMACSha512256Update(StateHMAC512256 var1, byte[] var2, long var3);

        public boolean cryptoAuthHMACSha512256Final(StateHMAC512256 var1, byte[] var2);
    }

    public static enum Type {
        SHA256,
        SHA512,
        SHA512256;

    }
}

