/*
 * Decompiled with CFR 0.152.
 */
package com.codevasp.lazysodium.interfaces;

import com.codevasp.lazysodium.exceptions.SodiumException;
import com.codevasp.lazysodium.utils.BaseChecker;
import com.codevasp.lazysodium.utils.Key;

public interface KeyDerivation {
    public static final int MASTER_KEY_BYTES = 32;
    public static final int CONTEXT_BYTES = 8;
    public static final int BLAKE2B_BYTES_MIN = 16;
    public static final int BLAKE2B_BYTES_MAX = 64;
    public static final int BYTES_MIN = 16;
    public static final int BYTES_MAX = 64;

    public static class Checker
    extends BaseChecker {
        public static boolean masterKeyIsCorrect(long masterKeyLen) {
            return masterKeyLen == 32L;
        }

        public static boolean subKeyIsCorrect(int lengthOfSubkey) {
            return Checker.isBetween(lengthOfSubkey, 16L, 64L);
        }

        public static boolean contextIsCorrect(int length) {
            return length == 8;
        }
    }

    public static interface Lazy {
        public Key cryptoKdfKeygen();

        public Key cryptoKdfDeriveFromKey(int var1, long var2, String var4, Key var5) throws SodiumException;
    }

    public static interface Native {
        public void cryptoKdfKeygen(byte[] var1);

        public int cryptoKdfDeriveFromKey(byte[] var1, int var2, long var3, byte[] var5, byte[] var6);
    }
}

