/*
 * Decompiled with CFR 0.152.
 */
package com.codevasp.lazysodium.interfaces;

import com.codevasp.lazysodium.exceptions.SodiumException;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public interface Hash {
    public static final int SHA256_BYTES = 32;
    public static final int SHA512_BYTES = 64;
    public static final int BYTES = 64;

    public static class State512
    extends Structure {
        public long[] state = new long[8];
        public long[] count = new long[2];
        public byte[] buf = new byte[128];

        protected List<String> getFieldOrder() {
            return Arrays.asList("state", "count", "buf");
        }

        public static class ByReference
        extends State512
        implements Structure.ByReference {
        }
    }

    public static class State256
    extends Structure {
        public long[] state = new long[8];
        public long count;
        public byte[] buf = new byte[64];

        protected List<String> getFieldOrder() {
            return Arrays.asList("state", "count", "buf");
        }

        public static class ByReference
        extends State256
        implements Structure.ByReference {
        }
    }

    public static interface Lazy {
        public String cryptoHashSha256(String var1) throws SodiumException;

        public String cryptoHashSha512(String var1) throws SodiumException;

        public boolean cryptoHashSha256Init(State256 var1);

        public boolean cryptoHashSha256Update(State256 var1, String var2);

        public String cryptoHashSha256Final(State256 var1) throws SodiumException;

        public boolean cryptoHashSha512Init(State512 var1);

        public boolean cryptoHashSha512Update(State512 var1, String var2);

        public String cryptoHashSha512Final(State512 var1) throws SodiumException;
    }

    public static interface Native {
        public boolean cryptoHashSha256(byte[] var1, byte[] var2, long var3);

        public boolean cryptoHashSha512(byte[] var1, byte[] var2, long var3);

        public boolean cryptoHashSha256Init(State256 var1);

        public boolean cryptoHashSha256Update(State256 var1, byte[] var2, long var3);

        public boolean cryptoHashSha256Final(State256 var1, byte[] var2);

        public boolean cryptoHashSha512Init(State512 var1);

        public boolean cryptoHashSha512Update(State512 var1, byte[] var2, long var3);

        public boolean cryptoHashSha512Final(State512 var1, byte[] var2);
    }
}

