/*
 * Decompiled with CFR 0.152.
 */
package com.codevasp.lazysodium.interfaces;

import com.codevasp.lazysodium.LazySodium;
import com.codevasp.lazysodium.exceptions.SodiumException;
import java.math.BigInteger;
import java.util.Arrays;

public interface Ristretto255 {
    public static final int RISTRETTO255_BYTES = 32;
    public static final int RISTRETTO255_HASH_BYTES = 64;
    public static final int RISTRETTO255_SCALAR_BYTES = 32;
    public static final int RISTRETTO255_NON_REDUCED_SCALAR_BYTES = 64;
    public static final BigInteger RISTRETTO255_L = BigInteger.valueOf(2L).pow(252).add(new BigInteger("27742317777372353535851937790883648493", 10));

    public static byte[] scalarToBytes(BigInteger n) {
        return Ristretto255.scalarToBytes(n, true);
    }

    public static byte[] scalarToBytes(BigInteger n, boolean reduced) {
        int expectedCount;
        byte[] bigEndianBytes = n.toByteArray();
        int n2 = expectedCount = reduced ? 32 : 64;
        if (bigEndianBytes.length > expectedCount) {
            throw new IllegalArgumentException("The scalar value is too big to be represented in " + expectedCount + " bytes");
        }
        byte[] littleEndianBytes = new byte[expectedCount];
        for (int i = 0; i < bigEndianBytes.length; ++i) {
            littleEndianBytes[i] = bigEndianBytes[bigEndianBytes.length - i - 1];
        }
        return littleEndianBytes;
    }

    public static BigInteger bytesToScalar(byte[] bytes) {
        byte[] temp = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            temp[bytes.length - i - 1] = bytes[i];
        }
        return new BigInteger(temp);
    }

    public static byte[] pointBuffer() {
        return new byte[32];
    }

    public static byte[] scalarBuffer() {
        return new byte[32];
    }

    public static final class RistrettoPoint {
        private final LazySodium ls;
        private final byte[] repr;

        private RistrettoPoint(LazySodium ls, byte[] repr) {
            if (repr == null || !ls.cryptoCoreRistretto255IsValidPoint(repr)) {
                throw new IllegalArgumentException("The passed point is invalid");
            }
            this.repr = repr;
            this.ls = ls;
        }

        private RistrettoPoint(LazySodium ls, String encoded) {
            this(ls, ls.decodeFromString(encoded));
        }

        public String toString() {
            return this.encode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RistrettoPoint)) {
                return false;
            }
            RistrettoPoint that = (RistrettoPoint)o;
            return Arrays.equals(this.repr, that.repr);
        }

        public int hashCode() {
            return Arrays.hashCode(this.repr);
        }

        public String toHex() {
            return this.ls.toHexStr(this.repr);
        }

        public byte[] toBytes() {
            return this.repr;
        }

        public String encode() {
            return this.ls.encodeToString(this.repr);
        }

        public RistrettoPoint scalarMult(BigInteger n) throws SodiumException {
            return this.ls.cryptoScalarmultRistretto255(n, this);
        }

        public RistrettoPoint times(BigInteger n) throws SodiumException {
            return this.scalarMult(n);
        }

        public RistrettoPoint plus(RistrettoPoint other) throws SodiumException {
            return this.ls.cryptoCoreRistretto255Add(this, other);
        }

        public RistrettoPoint minus(RistrettoPoint other) throws SodiumException {
            return this.ls.cryptoCoreRistretto255Sub(this, other);
        }

        public RistrettoPoint negate() throws SodiumException {
            return RistrettoPoint.zero(this.ls).minus(this);
        }

        public static RistrettoPoint zero(LazySodium ls) {
            return RistrettoPoint.fromBytes(ls, Ristretto255.pointBuffer());
        }

        public static RistrettoPoint random(LazySodium ls) {
            return ls.cryptoCoreRistretto255Random();
        }

        public static RistrettoPoint base(LazySodium ls) throws SodiumException {
            return ls.cryptoScalarmultRistretto255Base(BigInteger.ONE);
        }

        public static RistrettoPoint fromHex(LazySodium ls, String hex) {
            return new RistrettoPoint(ls, ls.toBinary(hex));
        }

        public static RistrettoPoint fromString(LazySodium ls, String encoded) {
            return new RistrettoPoint(ls, encoded);
        }

        public static RistrettoPoint fromBytes(LazySodium ls, byte[] bytes) {
            return new RistrettoPoint(ls, bytes);
        }

        public static RistrettoPoint hashToPoint(LazySodium ls, String encodedInput) throws SodiumException {
            return RistrettoPoint.hashToPoint(ls, ls.decodeFromString(encodedInput));
        }

        public static RistrettoPoint hashToPoint(LazySodium ls, byte[] input) throws SodiumException {
            byte[] hash = new byte[64];
            ls.cryptoHashSha512(hash, input, input.length);
            return ls.cryptoCoreRistretto255FromHash(hash);
        }
    }

    public static class Checker {
        private Checker() {
        }

        public static void ensurePointFits(byte[] point) {
            if (point == null) {
                throw new IllegalArgumentException("Null pointers are not allowed as target arrays");
            }
            if (point.length < 32) {
                throw new IllegalArgumentException("To hold a Ristretto255 point, the array must be 32 bytes in size");
            }
        }

        public static void ensureScalarFits(byte[] scalar) {
            if (scalar == null) {
                throw new IllegalArgumentException("Null pointers are not allowed as target arrays");
            }
            if (scalar.length < 32) {
                throw new IllegalArgumentException("To hold a Ristretto255 scalar, the array must be 32 bytes in size");
            }
        }

        public static void checkPoint(byte[] point) {
            if (point == null) {
                throw new IllegalArgumentException("Null pointers are not allowed as Ristretto255 points");
            }
            if (point.length != 32) {
                throw new IllegalArgumentException("A Ristretto255 point must be 32 bytes in size");
            }
        }

        public static void checkHash(byte[] hash) {
            if (hash == null) {
                throw new IllegalArgumentException("Null pointers are not allowed as Ristretto255 hashes");
            }
            if (hash.length != 64) {
                throw new IllegalArgumentException("A hash for use with Ristretto255 must be 64 bytes in size");
            }
        }

        public static void checkScalar(byte[] scalar) {
            if (scalar == null) {
                throw new IllegalArgumentException("Null pointers are not allowed as Ristretto255 scalars");
            }
            if (scalar.length != 32) {
                throw new IllegalArgumentException("A Ristretto255 scalar must be 32 bytes in size");
            }
        }

        public static void checkNonReducedScalar(byte[] scalar) {
            if (scalar == null) {
                throw new IllegalArgumentException("Null pointers are not allowed as non-reduced Ristretto255 scalars");
            }
            if (scalar.length != 64) {
                throw new IllegalArgumentException("A non-reduced Ristretto255 scalar must be 64 bytes in size");
            }
        }
    }

    public static interface Lazy {
        public boolean cryptoCoreRistretto255IsValidPoint(String var1);

        public RistrettoPoint cryptoCoreRistretto255Random();

        public RistrettoPoint cryptoCoreRistretto255FromHash(String var1) throws SodiumException;

        public RistrettoPoint cryptoCoreRistretto255FromHash(byte[] var1) throws SodiumException;

        public RistrettoPoint cryptoScalarmultRistretto255(BigInteger var1, RistrettoPoint var2) throws SodiumException;

        public RistrettoPoint cryptoScalarmultRistretto255(String var1, RistrettoPoint var2) throws SodiumException;

        public RistrettoPoint cryptoScalarmultRistretto255(byte[] var1, RistrettoPoint var2) throws SodiumException;

        public RistrettoPoint cryptoScalarmultRistretto255Base(BigInteger var1) throws SodiumException;

        public RistrettoPoint cryptoScalarmultRistretto255Base(String var1) throws SodiumException;

        public RistrettoPoint cryptoScalarmultRistretto255Base(byte[] var1) throws SodiumException;

        public RistrettoPoint cryptoCoreRistretto255Add(RistrettoPoint var1, RistrettoPoint var2) throws SodiumException;

        public RistrettoPoint cryptoCoreRistretto255Sub(RistrettoPoint var1, RistrettoPoint var2) throws SodiumException;

        public BigInteger cryptoCoreRistretto255ScalarRandom();

        public BigInteger cryptoCoreRistretto255ScalarReduce(BigInteger var1);

        public BigInteger cryptoCoreRistretto255ScalarReduce(String var1);

        public BigInteger cryptoCoreRistretto255ScalarReduce(byte[] var1);

        public BigInteger cryptoCoreRistretto255ScalarInvert(BigInteger var1) throws SodiumException;

        public BigInteger cryptoCoreRistretto255ScalarInvert(String var1) throws SodiumException;

        public BigInteger cryptoCoreRistretto255ScalarInvert(byte[] var1) throws SodiumException;

        public BigInteger cryptoCoreRistretto255ScalarNegate(BigInteger var1);

        public BigInteger cryptoCoreRistretto255ScalarNegate(String var1);

        public BigInteger cryptoCoreRistretto255ScalarNegate(byte[] var1);

        public BigInteger cryptoCoreRistretto255ScalarComplement(BigInteger var1);

        public BigInteger cryptoCoreRistretto255ScalarComplement(String var1);

        public BigInteger cryptoCoreRistretto255ScalarComplement(byte[] var1);

        public BigInteger cryptoCoreRistretto255ScalarAdd(BigInteger var1, BigInteger var2);

        public BigInteger cryptoCoreRistretto255ScalarAdd(BigInteger var1, String var2);

        public BigInteger cryptoCoreRistretto255ScalarAdd(String var1, BigInteger var2);

        public BigInteger cryptoCoreRistretto255ScalarAdd(String var1, String var2);

        public BigInteger cryptoCoreRistretto255ScalarAdd(String var1, byte[] var2);

        public BigInteger cryptoCoreRistretto255ScalarAdd(byte[] var1, String var2);

        public BigInteger cryptoCoreRistretto255ScalarAdd(BigInteger var1, byte[] var2);

        public BigInteger cryptoCoreRistretto255ScalarAdd(byte[] var1, BigInteger var2);

        public BigInteger cryptoCoreRistretto255ScalarAdd(byte[] var1, byte[] var2);

        public BigInteger cryptoCoreRistretto255ScalarSub(BigInteger var1, BigInteger var2);

        public BigInteger cryptoCoreRistretto255ScalarSub(BigInteger var1, String var2);

        public BigInteger cryptoCoreRistretto255ScalarSub(String var1, BigInteger var2);

        public BigInteger cryptoCoreRistretto255ScalarSub(String var1, String var2);

        public BigInteger cryptoCoreRistretto255ScalarSub(String var1, byte[] var2);

        public BigInteger cryptoCoreRistretto255ScalarSub(byte[] var1, String var2);

        public BigInteger cryptoCoreRistretto255ScalarSub(BigInteger var1, byte[] var2);

        public BigInteger cryptoCoreRistretto255ScalarSub(byte[] var1, BigInteger var2);

        public BigInteger cryptoCoreRistretto255ScalarSub(byte[] var1, byte[] var2);

        public BigInteger cryptoCoreRistretto255ScalarMul(BigInteger var1, BigInteger var2);

        public BigInteger cryptoCoreRistretto255ScalarMul(BigInteger var1, String var2);

        public BigInteger cryptoCoreRistretto255ScalarMul(String var1, BigInteger var2);

        public BigInteger cryptoCoreRistretto255ScalarMul(String var1, String var2);

        public BigInteger cryptoCoreRistretto255ScalarMul(String var1, byte[] var2);

        public BigInteger cryptoCoreRistretto255ScalarMul(byte[] var1, String var2);

        public BigInteger cryptoCoreRistretto255ScalarMul(BigInteger var1, byte[] var2);

        public BigInteger cryptoCoreRistretto255ScalarMul(byte[] var1, BigInteger var2);

        public BigInteger cryptoCoreRistretto255ScalarMul(byte[] var1, byte[] var2);
    }

    public static interface Native {
        public boolean cryptoCoreRistretto255IsValidPoint(byte[] var1);

        public void cryptoCoreRistretto255Random(byte[] var1);

        public boolean cryptoCoreRistretto255FromHash(byte[] var1, byte[] var2);

        public boolean cryptoScalarmultRistretto255(byte[] var1, byte[] var2, byte[] var3);

        public boolean cryptoScalarmultRistretto255Base(byte[] var1, byte[] var2);

        public boolean cryptoCoreRistretto255Add(byte[] var1, byte[] var2, byte[] var3);

        public boolean cryptoCoreRistretto255Sub(byte[] var1, byte[] var2, byte[] var3);

        public void cryptoCoreRistretto255ScalarRandom(byte[] var1);

        public void cryptoCoreRistretto255ScalarReduce(byte[] var1, byte[] var2);

        public boolean cryptoCoreRistretto255ScalarInvert(byte[] var1, byte[] var2);

        public void cryptoCoreRistretto255ScalarNegate(byte[] var1, byte[] var2);

        public void cryptoCoreRistretto255ScalarComplement(byte[] var1, byte[] var2);

        public void cryptoCoreRistretto255ScalarAdd(byte[] var1, byte[] var2, byte[] var3);

        public void cryptoCoreRistretto255ScalarSub(byte[] var1, byte[] var2, byte[] var3);

        public void cryptoCoreRistretto255ScalarMul(byte[] var1, byte[] var2, byte[] var3);
    }
}

