/*
 * Decompiled with CFR 0.152.
 */
package com.codevasp.lazysodium.interfaces;

import com.codevasp.lazysodium.exceptions.SodiumException;
import com.codevasp.lazysodium.utils.BaseChecker;

public interface Scrypt {
    public static final long SCRYPTSALSA208SHA256_BYTES_MIN = 16L;
    public static final long SCRYPTSALSA208SHA256_BYTES_MAX = Long.MAX_VALUE;
    public static final long SCRYPTSALSA208SHA256_PASSWD_MIN = 0L;
    public static final long SCRYPTSALSA208SHA256_PASSWD_MAX = Long.MAX_VALUE;
    public static final long SCRYPTSALSA208SHA256_SALT_BYTES = 32L;
    public static final long SCRYPTSALSA208SHA256_STRBYTES = 102L;
    public static final long SCRYPTSALSA208SHA256_OPSLIMIT_MIN = 32768L;
    public static final long SCRYPTSALSA208SHA256_OPSLIMIT_MAX = 0xFFFFFFFFL;
    public static final long SCRYPTSALSA208SHA256_OPSLIMIT_INTERACTIVE = 524288L;
    public static final long SCRYPTSALSA208SHA256_OPSLIMIT_SENSITIVE = 0x2000000L;
    public static final long SCRYPTSALSA208SHA256_MEMLIMIT_MIN = 0x1000000L;
    public static final long SCRYPTSALSA208SHA256_MEMLIMIT_MAX = 0x1000000000L;
    public static final long SCRYPTSALSA208SHA256_MEMLIMIT_INTERACTIVE = 0x1000000L;
    public static final long SCRYPTSALSA208SHA256_MEMLIMIT_SENSITIVE = 0x40000000L;

    public static interface Lazy {
        public String cryptoPwHashScryptSalsa208Sha256(String var1, long var2, byte[] var4, long var5, long var7) throws SodiumException;

        public String cryptoPwHashScryptSalsa208Sha256Str(String var1, long var2, long var4) throws SodiumException;

        public boolean cryptoPwHashScryptSalsa208Sha256StrVerify(String var1, String var2);
    }

    public static interface Native {
        public boolean cryptoPwHashScryptSalsa208Sha256(byte[] var1, long var2, byte[] var4, long var5, byte[] var7, long var8, long var10);

        public boolean cryptoPwHashScryptSalsa208Sha256Str(byte[] var1, byte[] var2, long var3, long var5, long var7);

        public boolean cryptoPwHashScryptSalsa208Sha256StrVerify(byte[] var1, byte[] var2, long var3);

        public boolean cryptoPwHashScryptSalsa208Sha256Ll(byte[] var1, int var2, byte[] var3, int var4, long var5, long var7, long var9, byte[] var11, int var12);

        public boolean cryptoPwHashScryptSalsa208Sha256StrNeedsRehash(byte[] var1, long var2, long var4);
    }

    public static class Checker
    extends BaseChecker {
        public static boolean checkOpsLimitScrypt(long opsLimit) {
            return Checker.isBetween(opsLimit, 32768L, 0xFFFFFFFFL);
        }

        public static boolean checkMemLimitScrypt(long memLimit) {
            return Checker.isBetween(memLimit, 0x1000000L, 0x1000000000L);
        }

        public static boolean checkAllScrypt(long passwordBytesLen, long saltBytesLen, long hashLen, long opsLimit, long memLimit) throws SodiumException {
            if (!Checker.isBetween(passwordBytesLen, 0L, Long.MAX_VALUE)) {
                throw new SodiumException("The password provided is not the correct size.");
            }
            if (!Checker.isBetween(hashLen, 16L, Long.MAX_VALUE)) {
                throw new SodiumException("Please supply a hashLen greater than SCRYPTSALSA208SHA256_PASSWD_MIN but less than SCRYPTSALSA208SHA256_PASSWD_MAX");
            }
            if (!Checker.correctLen(saltBytesLen, 32L)) {
                throw new SodiumException("The password provided is not the correct size.");
            }
            if (!Checker.checkOpsLimitScrypt(opsLimit)) {
                throw new SodiumException("The ops limit provided is not between the correct values.");
            }
            if (!Checker.checkMemLimitScrypt(memLimit)) {
                throw new SodiumException("The mem limit provided is not between the correct values.");
            }
            return true;
        }
    }
}

