package com.contentstack.sdk;


import com.contentstack.sdk.utility.CSAppConstants;
import org.json.JSONObject;
import java.util.HashMap;
import java.util.LinkedHashMap;

/**
 * @Author Contentstack
 *
 * MIT License
 *
 * Copyright (c) 2012 - 2019 Contentstack
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */


class CSBackgroundTask {

    public CSBackgroundTask(Query queryInstance, Stack stackInstance, String controller, String url, LinkedHashMap<String, Object> headers, LinkedHashMap<String, Object> urlQueries, JSONObject jsonMain, String requestInfo, CSAppConstants.RequestMethod method, ResultCallBack callback) {

        if (CSAppConstants.isNetworkAvailable()) {
            if (headers != null && headers.size() > 0) {

                String URL = stackInstance.URLSCHEMA + stackInstance.URL + url;

                CSConnectionRequest csConnectionRequest = new CSConnectionRequest(queryInstance);
                csConnectionRequest.setQueryInstance(queryInstance);
                csConnectionRequest.setURLQueries(urlQueries);

                csConnectionRequest.setParams(URL, method, controller, jsonMain, headers, requestInfo, callback);

            } else {
                sendErrorForHeader(callback);
            }
        } else {
            sendErrorToUser(callback);
        }
    }


    public CSBackgroundTask(Entry entryInstance, Stack stackInstance, String controller, String url, LinkedHashMap<String, Object> headers, HashMap<String, Object> urlQueries, JSONObject jsonMain, String requestInfo, boolean isOffline, CSAppConstants.RequestMethod method, ResultCallBack callBack) {

        if (CSAppConstants.isNetworkAvailable()) {

            if (headers != null && headers.size() > 0)
            {
                String URL = stackInstance.URLSCHEMA + stackInstance.URL + url;
                CSConnectionRequest csConnectionRequest = new CSConnectionRequest(entryInstance);
                csConnectionRequest.setURLQueries(urlQueries);
                csConnectionRequest.setParams(URL, method, controller, jsonMain, headers,  requestInfo, callBack);

            } else {
                sendErrorForHeader(callBack);
            }
        } else {
            sendErrorToUser(callBack);
        }
    }



    public CSBackgroundTask(AssetLibrary assetLibrary, Stack stackInstance, String controller, String url, LinkedHashMap<String, Object> headers, HashMap<String, Object> urlQueries, JSONObject jsonMain,  String requestInfo, boolean isOffline, CSAppConstants.RequestMethod method, ResultCallBack callback) {
        if (CSAppConstants.isNetworkAvailable()) {
            if (headers != null && headers.size() > 0) {

                String URL = stackInstance.URLSCHEMA + stackInstance.URL + url;

                CSConnectionRequest csConnectionRequest = new CSConnectionRequest(assetLibrary);
                csConnectionRequest.setURLQueries(urlQueries);
                csConnectionRequest.setParams(URL, method, controller, jsonMain, headers,  requestInfo, callback);

            } else {
                sendErrorForHeader(callback);
            }
        } else {
            sendErrorToUser(callback);
        }
    }


    public CSBackgroundTask(Asset asset, Stack stackInstance, String controller, String url, LinkedHashMap<String, Object> headers, HashMap<String, Object> urlQueries, JSONObject jsonMain,  String requestInfo, boolean isOffline, CSAppConstants.RequestMethod method, ResultCallBack callback) {

        if (CSAppConstants.isNetworkAvailable()) {
            if (headers != null && headers.size() > 0) {

                String URL = stackInstance.URLSCHEMA + stackInstance.URL + url;

                CSConnectionRequest csConnectionRequest = new CSConnectionRequest(asset);
                csConnectionRequest.setURLQueries(urlQueries);
                csConnectionRequest.setParams(URL, method, controller, jsonMain, headers, requestInfo, callback);

            } else {
                sendErrorForHeader(callback);
            }
        } else {
            sendErrorToUser(callback);
        }
    }


    public CSBackgroundTask(Stack stackInstance, String controller, String url, HashMap<String, Object> headers, HashMap<String, Object> urlParams, JSONObject jsonMain, String requestInfo, boolean b, CSAppConstants.RequestMethod method, ResultCallBack callback) {

        if (CSAppConstants.isNetworkAvailable()) {
            if (headers != null && headers.size() > 0) {

                String URL = stackInstance.URLSCHEMA + stackInstance.URL + url;

                CSConnectionRequest csConnectionRequest = new CSConnectionRequest(stackInstance);
                csConnectionRequest.setStackInstance(stackInstance);
                csConnectionRequest.setURLQueries(urlParams);
                csConnectionRequest.setParams(URL, method, controller, jsonMain, headers, requestInfo, callback);

            } else {
                sendErrorForHeader(callback);
            }
        } else {
            sendErrorToUser(callback);
        }
    }



    public CSBackgroundTask(ContentType contentTypeInstance, Stack stackInstance, String controller, String url, HashMap<String, Object> headers, HashMap<String, Object> urlParams, JSONObject jsonMain, String requestInfo, boolean b, CSAppConstants.RequestMethod method, ResultCallBack callback) {

        if (CSAppConstants.isNetworkAvailable()) {
            if (headers != null && headers.size() > 0) {

                String URL = stackInstance.URLSCHEMA + stackInstance.URL + url;

                CSConnectionRequest csConnectionRequest = new CSConnectionRequest(contentTypeInstance);
                csConnectionRequest.setURLQueries(urlParams);
                csConnectionRequest.setParams(URL, method, controller, jsonMain, headers, requestInfo, callback);

            } else {
                sendErrorForHeader(callback);
            }
        } else {
            sendErrorToUser(callback);
        }
    }



    private void sendErrorToUser(ResultCallBack callbackObject){
        Error error = new Error();
        error.setErrorCode(CSAppConstants.NONETWORKCONNECTION);
        error.setErrorMessage(CSAppConstants.ErrorMessage_NoNetwork);
        if(callbackObject != null){
            callbackObject.onRequestFail(ResponseType.UNKNOWN,error);
        }
    }


    private void sendErrorForHeader(ResultCallBack callbackObject) {
        Error error = new Error();
        error.setErrorMessage(CSAppConstants.ErrorMessage_CalledDefaultMethod);
        if (callbackObject != null) {
            callbackObject.onRequestFail(ResponseType.UNKNOWN, error);
        }
    }
}
