/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Asset;
import com.contentstack.sdk.Entry;
import com.contentstack.sdk.EntryModel;
import com.contentstack.sdk.Stack;
import com.contentstack.sdk.utility.ContentstackUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Group {
    private static final String TAG = "Group";
    private JSONObject resultJson;
    private Stack stackInstance;

    protected Group(Stack stack, JSONObject jsonObject) {
        this.resultJson = jsonObject;
        this.stackInstance = stack;
    }

    public JSONObject toJSON() {
        return this.resultJson;
    }

    public Object get(String key) {
        try {
            if (this.resultJson != null && key != null) {
                return this.resultJson.get(key);
            }
            return null;
        }
        catch (Exception e) {
            Stack.log(TAG, e.getLocalizedMessage());
            return null;
        }
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value != null && value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public Boolean getBoolean(String key) {
        Object value = this.get(key);
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public JSONArray getJSONArray(String key) {
        Object value = this.get(key);
        if (value != null && value instanceof JSONArray) {
            return (JSONArray)value;
        }
        return null;
    }

    public JSONObject getJSONObject(String key) {
        Object value = this.get(key);
        if (value != null && value instanceof JSONObject) {
            return (JSONObject)value;
        }
        return null;
    }

    public Number getNumber(String key) {
        Object value = this.get(key);
        if (value != null && value instanceof Number) {
            return (Number)value;
        }
        return null;
    }

    public int getInt(String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.intValue();
        }
        return 0;
    }

    public float getFloat(String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.floatValue();
        }
        return 0.0f;
    }

    public double getDouble(String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.doubleValue();
        }
        return 0.0;
    }

    public long getLong(String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.longValue();
        }
        return 0L;
    }

    public short getShort(String key) {
        Number value = this.getNumber(key);
        if (value != null) {
            return value.shortValue();
        }
        return 0;
    }

    public Calendar getDate(String key) {
        try {
            String value = this.getString(key);
            return ContentstackUtil.parseDate(value, null);
        }
        catch (Exception e) {
            Stack.log(TAG, "-----------------getDate|" + e.getLocalizedMessage());
            return null;
        }
    }

    public Asset getAsset(String key) {
        JSONObject assetObject = this.getJSONObject(key);
        return this.stackInstance.asset().configure(assetObject);
    }

    public List<Asset> getAssets(String key) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        JSONArray assetArray = this.getJSONArray(key);
        for (int i = 0; i < assetArray.length(); ++i) {
            if (!(assetArray.opt(i) instanceof JSONObject)) continue;
            Asset asset = this.stackInstance.asset().configure(assetArray.optJSONObject(i));
            assets.add(asset);
        }
        return assets;
    }

    public Group getGroup(String key) {
        if (!key.isEmpty() && this.resultJson.has(key) && this.resultJson.opt(key) instanceof JSONObject) {
            return new Group(this.stackInstance, this.resultJson.optJSONObject(key));
        }
        return null;
    }

    public List<Group> getGroups(String key) {
        if (!key.isEmpty() && this.resultJson.has(key) && this.resultJson.opt(key) instanceof JSONArray) {
            JSONArray array = this.resultJson.optJSONArray(key);
            ArrayList<Group> groupList = new ArrayList<Group>();
            for (int i = 0; i < array.length(); ++i) {
                if (!(array.opt(i) instanceof JSONObject)) continue;
                Group group = new Group(this.stackInstance, array.optJSONObject(i));
                groupList.add(group);
            }
            return groupList;
        }
        return null;
    }

    public ArrayList<Entry> getAllEntries(String refKey, String refContentType) {
        block6: {
            try {
                if (this.resultJson == null || !(this.resultJson.get(refKey) instanceof JSONArray)) break block6;
                int count = ((JSONArray)this.resultJson.get(refKey)).length();
                ArrayList<Entry> builtObjectList = new ArrayList<Entry>();
                for (int i = 0; i < count; ++i) {
                    EntryModel model = new EntryModel(((JSONArray)this.resultJson.get(refKey)).getJSONObject(i), null, false, false, true);
                    Entry entryInstance = null;
                    try {
                        entryInstance = this.stackInstance.contentType(refContentType).entry();
                    }
                    catch (Exception e) {
                        entryInstance = new Entry(refContentType);
                        Stack.log(TAG, "----------------getAllEntries" + e.toString());
                    }
                    entryInstance.setUid(model.entryUid);
                    entryInstance.ownerEmailId = model.ownerEmailId;
                    entryInstance.ownerUid = model.ownerUid;
                    if (model.ownerMap != null) {
                        entryInstance.owner = new HashMap<String, Object>(model.ownerMap);
                    }
                    entryInstance.resultJson = model.jsonObject;
                    entryInstance.setTags(model.tags);
                    builtObjectList.add(entryInstance);
                    model = null;
                }
                return builtObjectList;
            }
            catch (Exception e) {
                Stack.log(TAG, "-----------------get|" + e.getLocalizedMessage());
                return null;
            }
        }
        return null;
    }
}

