/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.Entry;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class QueryResult {
    protected static final Logger logger = Logger.getLogger(QueryResult.class.getSimpleName());
    protected JSONObject receiveJson;
    protected JSONArray schemaArray;
    protected JSONObject contentObject;
    protected int count;
    protected List<Entry> resultObjects;

    public List<Entry> getResultObjects() {
        return this.resultObjects;
    }

    public int getCount() {
        return this.count;
    }

    public JSONArray getSchema() {
        return this.schemaArray;
    }

    public JSONObject getContentType() {
        return this.contentObject;
    }

    public void setJSON(JSONObject jsonObject, List<Entry> objectList) {
        this.receiveJson = jsonObject;
        this.resultObjects = objectList;
        this.extractSchemaArray();
        this.extractContentObject();
        this.extractCount();
    }

    private void extractSchemaArray() {
        try {
            JSONArray jsonArray;
            if (this.receiveJson != null && this.receiveJson.has("schema") && (jsonArray = this.receiveJson.getJSONArray("schema")) != null) {
                this.schemaArray = jsonArray;
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    private void extractContentObject() {
        try {
            Object contentTypeObject;
            JSONObject jsonObject;
            if (this.receiveJson != null && this.receiveJson.has("content_type") && (jsonObject = new JSONObject((Map)(contentTypeObject = this.receiveJson.get("content_type")))) != null) {
                this.contentObject = jsonObject;
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    private void extractCount() {
        try {
            if (this.receiveJson != null) {
                this.count = this.receiveJson.optInt("count");
                if (this.count == 0 && this.receiveJson.has("entries")) {
                    this.count = this.receiveJson.optInt("entries");
                }
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    private void logException(Exception e) {
        logger.log(Level.SEVERE, "Failed to process query result data. Check the response format and try again.", e);
    }
}

