/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.datadog_lambda_java;

import com.datadoghq.datadog_lambda_java.CustomMetric;
import com.datadoghq.datadog_lambda_java.DDLogger;
import com.datadoghq.datadog_lambda_java.MetricWriter;
import com.timgroup.statsd.NonBlockingStatsDClientBuilder;
import com.timgroup.statsd.StatsDClient;

class ExtensionMetricWriter
extends MetricWriter {
    private StatsDClient client;

    public ExtensionMetricWriter() {
        try {
            this.client = new NonBlockingStatsDClientBuilder().prefix("").hostname("127.0.0.1").port(8125).enableTelemetry(false).telemetryFlushInterval(0).build();
        }
        catch (Exception e) {
            DDLogger.getLoggerImpl().error("Could not create StatsDClient " + e.getMessage(), new Object[0]);
            this.client = null;
        }
    }

    @Override
    public void write(CustomMetric cm) {
        if (null != this.client) {
            StringBuilder tagsSb = new StringBuilder();
            if (cm.getTags() != null) {
                cm.getTags().forEach((k, val) -> tagsSb.append(k.toLowerCase()).append(":").append(val.toString().toLowerCase()));
            }
            this.client.distribution(cm.getName(), cm.getValue(), new String[]{tagsSb.toString()});
        } else {
            DDLogger.getLoggerImpl().error("Could not write the metric because the client is null", new Object[0]);
        }
    }

    @Override
    public void flush() {
    }
}

