package com.docusign.webforms.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

/** The components map for the web form. */
@Schema(description = "The components map for the web form")
public class WebFormComponentsMap extends java.util.HashMap<String, WebFormComponent> {

  /**
   * Compares objects.
   *
   * @return true or false depending on comparison result.
   */
  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    return super.equals(o);
  }

  /** Returns the HashCode. */
  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode());
  }

  /** Converts the given object to string. */
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WebFormComponentsMap {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
