/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.webforms.model;

import com.docusign.webforms.model.WebFormMetadata;
import com.docusign.webforms.model.WebFormProperties;
import com.docusign.webforms.model.WebFormState;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="An object that summarizes an instance of a form that can be used to display a listing")
public class WebFormSummary {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="accountId")
    private String accountId = null;
    @JsonProperty(value="isPublished")
    private Boolean isPublished = null;
    @JsonProperty(value="isEnabled")
    private Boolean isEnabled = null;
    @JsonProperty(value="hasDraftChanges")
    private Boolean hasDraftChanges = null;
    @JsonProperty(value="formState")
    private WebFormState formState = null;
    @JsonProperty(value="formProperties")
    private WebFormProperties formProperties = null;
    @JsonProperty(value="formMetadata")
    private WebFormMetadata formMetadata = null;

    public WebFormSummary id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WebFormSummary accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Schema(description="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public WebFormSummary isPublished(Boolean isPublished) {
        this.isPublished = isPublished;
        return this;
    }

    @Schema(example="true", description="Has the form been published")
    public Boolean isIsPublished() {
        return this.isPublished;
    }

    public void setIsPublished(Boolean isPublished) {
        this.isPublished = isPublished;
    }

    public WebFormSummary isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Schema(example="true", description="Is the form currently enabled and available for data collection")
    public Boolean isIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public WebFormSummary hasDraftChanges(Boolean hasDraftChanges) {
        this.hasDraftChanges = hasDraftChanges;
        return this;
    }

    @Schema(example="true", description="Does the form have draft changes that need to be published?")
    public Boolean isHasDraftChanges() {
        return this.hasDraftChanges;
    }

    public void setHasDraftChanges(Boolean hasDraftChanges) {
        this.hasDraftChanges = hasDraftChanges;
    }

    public WebFormSummary formState(WebFormState formState) {
        this.formState = formState;
        return this;
    }

    @Schema(description="")
    public WebFormState getFormState() {
        return this.formState;
    }

    public void setFormState(WebFormState formState) {
        this.formState = formState;
    }

    public WebFormSummary formProperties(WebFormProperties formProperties) {
        this.formProperties = formProperties;
        return this;
    }

    @Schema(description="")
    public WebFormProperties getFormProperties() {
        return this.formProperties;
    }

    public void setFormProperties(WebFormProperties formProperties) {
        this.formProperties = formProperties;
    }

    public WebFormSummary formMetadata(WebFormMetadata formMetadata) {
        this.formMetadata = formMetadata;
        return this;
    }

    @Schema(description="")
    public WebFormMetadata getFormMetadata() {
        return this.formMetadata;
    }

    public void setFormMetadata(WebFormMetadata formMetadata) {
        this.formMetadata = formMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebFormSummary webFormSummary = (WebFormSummary)o;
        return Objects.equals(this.id, webFormSummary.id) && Objects.equals(this.accountId, webFormSummary.accountId) && Objects.equals(this.isPublished, webFormSummary.isPublished) && Objects.equals(this.isEnabled, webFormSummary.isEnabled) && Objects.equals(this.hasDraftChanges, webFormSummary.hasDraftChanges) && Objects.equals((Object)this.formState, (Object)webFormSummary.formState) && Objects.equals(this.formProperties, webFormSummary.formProperties) && Objects.equals(this.formMetadata, webFormSummary.formMetadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.accountId, this.isPublished, this.isEnabled, this.hasDraftChanges, this.formState, this.formProperties, this.formMetadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebFormSummary {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    isPublished: ").append(this.toIndentedString(this.isPublished)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    hasDraftChanges: ").append(this.toIndentedString(this.hasDraftChanges)).append("\n");
        sb.append("    formState: ").append(this.toIndentedString((Object)this.formState)).append("\n");
        sb.append("    formProperties: ").append(this.toIndentedString(this.formProperties)).append("\n");
        sb.append("    formMetadata: ").append(this.toIndentedString(this.formMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

