package com.flutterwave.services;

import com.flutterwave.bean.ListResponse;
import com.flutterwave.bean.OTPRequest;
import com.flutterwave.bean.Response;
import org.json.JSONObject;

import java.util.Optional;

import static com.flutterwave.client.Utility.post;
import static com.flutterwave.utility.Properties.getProperty;
import static com.flutterwave.bean.ChargeTypes.OTP;

/**
 * Creating and managing custom-generated OTPs with FLutterwave.
 * @author Cleopatra Douglas
 */
public class OTP {

    private String ERROR = "Error processing request, please check logs";

    /**
     * Generate an OTP via Flutterwave for any validation.
     * @param otpRequest bean
     * @return ListResponse
     */
    public ListResponse runCreateOTP(OTPRequest otpRequest){
        return Optional.of(post(getProperty("OTP_BASE"), otpRequest.toString(), OTP, null))
                .map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(ERROR));
    }

    /**
     * OTPs generated by the /create endpoint.
     * @param reference String This is the reference that was returned in the create OTP response.
     * @param otp String This is the One time Pin sent to the user. You are meant to collect this from the user for validation.
     * @return Response
     */
    public Response runValidateOTP(String reference, String otp){
        return Optional.of(post(getProperty("OTP_BASE")+"/"+reference+"/validate",
                        new JSONObject().put("otp", otp).toString(), OTP, null))
                .map(Response::toResponse).orElseThrow(() -> new RuntimeException(ERROR));
    }
}
