/*
 * Decompiled with CFR 0.152.
 */
package com.flutterwave.services;

import com.flutterwave.bean.ChargeTypes;
import com.flutterwave.bean.ListResponse;
import com.flutterwave.bean.Response;
import com.flutterwave.client.Utility;
import com.flutterwave.utility.Properties;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class Settlements {
    private String ERROR = "Error processing request, please check logs";

    public ListResponse runGetAllSettlements(Optional<Integer> page, Optional<String> from, Optional<String> to, Optional<String> subaccount_id) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        subaccount_id.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("subaccount_id", s)));
        to.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("to", s)));
        from.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("from", s)));
        page.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("page", s.toString())));
        return Optional.of(Utility.get(Properties.getProperty("SETTLEMENT_BASE"), ChargeTypes.SETTLEMENT, nameValuePairs)).map(ListResponse::toListResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }

    public Response runGetSettlement(int id, Optional<String> from, Optional<String> to) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        to.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("to", s)));
        from.ifPresent(s -> nameValuePairs.add((NameValuePair)new BasicNameValuePair("from", s)));
        return Optional.of(Utility.get(Properties.getProperty("SETTLEMENT_BASE") + "/" + id, ChargeTypes.SETTLEMENT, nameValuePairs)).map(Response::toResponse).orElseThrow(() -> new RuntimeException(this.ERROR));
    }
}

