/*
 * Decompiled with CFR 0.152.
 */
package xdean.reflect.getter.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.NoOp;
import sun.misc.Unsafe;
import xdean.reflect.getter.FieldPropGetter;
import xdean.reflect.getter.internal.util.ExceptionUtil;
import xdean.reflect.getter.internal.util.PrimitiveTypeUtil;
import xdean.reflect.getter.internal.util.ReflectUtil;
import xdean.reflect.getter.internal.util.TaskUtil;
import xdean.reflect.getter.internal.util.UnsafeUtil;

public class UnsafeFieldGetter<T>
implements FieldPropGetter<T> {
    private static final Unsafe UNSAFE = UnsafeUtil.getUnsafe();
    private T mockT;
    private Map<Class<?>, List<Field>> primitives = new HashMap();
    private Map<Object, Field> objectMap = new IdentityHashMap<Object, Field>();

    public UnsafeFieldGetter(Class<T> clz) throws IllegalStateException, IllegalArgumentException {
        try {
            Field[] fields;
            if (clz.isInterface()) {
                throw new IllegalArgumentException("Interface has no field.");
            }
            this.mockT = Modifier.isAbstract(clz.getModifiers()) ? this.newAbstract(clz) : this.newObject(clz);
            for (Field field : fields = ReflectUtil.getAllFields(clz, false)) {
                Class<?> type = field.getType();
                if (PrimitiveTypeUtil.isPrimitive(type)) {
                    this.handlePrimitive(field);
                    continue;
                }
                if (type.isArray()) {
                    this.handleArray(field);
                    continue;
                }
                this.handleObject(field);
            }
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    private void handleObject(Field field) throws InstantiationException {
        Class<?> type = field.getType();
        Object o = type.isInterface() || Modifier.isAbstract(type.getModifiers()) ? this.newAbstract(type) : (type == Class.class ? this.newClass(Object.class) : this.newObject(type));
        long offset = UNSAFE.objectFieldOffset(field);
        UNSAFE.putObject(this.mockT, offset, o);
        this.objectMap.put(o, field);
    }

    private <C> C newObject(Class<C> clz) throws InstantiationException {
        return (C)UNSAFE.allocateInstance(clz);
    }

    private <C> C newAbstract(Class<C> clz) throws InstantiationException {
        return this.newObject(this.newClass(clz));
    }

    private <C> Class<? extends C> newClass(Class<C> clz) {
        Enhancer enhancer = new Enhancer();
        if (clz.isInterface()) {
            enhancer.setInterfaces(new Class[]{clz});
        } else {
            enhancer.setSuperclass(clz);
        }
        enhancer.setUseCache(true);
        enhancer.setCallbackType(NoOp.class);
        return enhancer.createClass();
    }

    private void handleArray(Field field) {
        Array.newInstance(field.getType(), 0);
        long offset = UNSAFE.objectFieldOffset(field);
        Object array = Array.newInstance(Object.class, 0);
        UNSAFE.putObject(this.mockT, offset, array);
        this.objectMap.put(array, field);
    }

    private void handlePrimitive(Field field) {
        field.setAccessible(true);
        this.primitives.computeIfAbsent(field.getType(), k -> new ArrayList()).add(field);
    }

    private Field getPrimitive(Function<T, ?> invoke) {
        Object value = invoke.apply(this.mockT);
        Class<?> type = PrimitiveTypeUtil.toPrimitive(value.getClass());
        Collection fields = this.primitives.get(type);
        if (fields.size() == 1) {
            return (Field)fields.iterator().next();
        }
        int count = 0;
        while (true) {
            HashMap map = new HashMap();
            Iterator<?> allValue = this.getAllValue(type);
            Iterator<Field> fieldIterator = fields.iterator();
            Object defaultValue = allValue.next();
            int i = count;
            while (i-- > 0) {
                ExceptionUtil.uncheck(() -> ((Field)fieldIterator.next()).set(this.mockT, defaultValue));
            }
            while (allValue.hasNext() && fieldIterator.hasNext()) {
                Field field = (Field)fieldIterator.next();
                Object next = allValue.next();
                ExceptionUtil.uncheck(() -> field.set(this.mockT, next));
                map.put(next, field);
            }
            fieldIterator.forEachRemaining(f -> ExceptionUtil.uncheck(() -> f.set(this.mockT, defaultValue)));
            value = invoke.apply(this.mockT);
            if (value != defaultValue) {
                return (Field)map.get(value);
            }
            count += map.size();
        }
    }

    private <E> Iterator<E> getAllValue(Class<E> clz) {
        switch (PrimitiveTypeUtil.toPrimitive(clz).getName()) {
            case "int": {
                return this.getIterator(0, i -> i == Integer.MAX_VALUE ? null : Integer.valueOf(i + 1));
            }
            case "short": {
                return this.getIterator((short)0, i -> i == Short.MAX_VALUE ? null : Short.valueOf((short)(i + 1)));
            }
            case "long": {
                return this.getIterator(0L, i -> i == Long.MAX_VALUE ? null : Long.valueOf(i + 1L));
            }
            case "double": {
                return this.getIterator(0.0, i -> i >= 100.0 ? null : Double.valueOf(i + 1.0));
            }
            case "float": {
                return this.getIterator(Float.valueOf(0.0f), i -> i.floatValue() >= 100.0f ? null : Float.valueOf(i.floatValue() + 1.0f));
            }
            case "boolean": {
                return this.getIterator(Boolean.TRUE, i -> i != false ? Boolean.FALSE : null);
            }
            case "char": {
                return this.getIterator(Character.valueOf('\u0000'), i -> i.charValue() == '\uffff' ? null : Character.valueOf((char)(i.charValue() + '\u0001')));
            }
            case "byte": {
                return this.getIterator((byte)0, i -> i == 127 ? null : Byte.valueOf((byte)(i + 1)));
            }
        }
        throw new IllegalArgumentException("Not a primitive type.");
    }

    private <E> Iterator<E> getIterator(final E first, final Function<E, E> func) {
        return new Iterator<E>(){
            E next;
            {
                this.next = first;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public E next() {
                Object current = this.next;
                this.next = func.apply(current);
                return current;
            }
        };
    }

    @Override
    public <O> Field getField(Function<T, O> invoke) {
        return (Field)TaskUtil.firstNonNull(() -> this.objectMap.get(invoke.apply(this.mockT)), () -> this.getPrimitive(invoke)).orElseThrow(() -> new IllegalStateException("The given value isn't the mock object's property."));
    }
}

