/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.common.bean.WxMenu;
import me.chanjar.weixin.common.util.json.GsonHelper;

public class WxMenuGsonAdapter
implements JsonSerializer<WxMenu>,
JsonDeserializer<WxMenu> {
    public JsonElement serialize(WxMenu menu, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        JsonArray buttonArray = new JsonArray();
        for (WxMenu.WxMenuButton button : menu.getButtons()) {
            JsonObject buttonJson = this.convertToJson(button);
            buttonArray.add((JsonElement)buttonJson);
        }
        json.add("button", (JsonElement)buttonArray);
        if (menu.getMatchRule() != null) {
            json.add("matchrule", (JsonElement)this.convertToJson(menu.getMatchRule()));
        }
        return json;
    }

    protected JsonObject convertToJson(WxMenu.WxMenuButton button) {
        JsonObject buttonJson = new JsonObject();
        buttonJson.addProperty("type", button.getType());
        buttonJson.addProperty("name", button.getName());
        buttonJson.addProperty("key", button.getKey());
        buttonJson.addProperty("url", button.getUrl());
        if (button.getSubButtons() != null && button.getSubButtons().size() > 0) {
            JsonArray buttonArray = new JsonArray();
            for (WxMenu.WxMenuButton sub_button : button.getSubButtons()) {
                buttonArray.add((JsonElement)this.convertToJson(sub_button));
            }
            buttonJson.add("sub_button", (JsonElement)buttonArray);
        }
        return buttonJson;
    }

    protected JsonObject convertToJson(WxMenu.WxMenuRule menuRule) {
        JsonObject matchRule = new JsonObject();
        matchRule.addProperty("group_id", menuRule.getGroupId());
        matchRule.addProperty("sex", menuRule.getSex());
        matchRule.addProperty("country", menuRule.getCountry());
        matchRule.addProperty("province", menuRule.getProvince());
        matchRule.addProperty("city", menuRule.getCity());
        matchRule.addProperty("client_platform_type", menuRule.getClientPlatformType());
        matchRule.addProperty("language", menuRule.getLanguage());
        return matchRule;
    }

    public WxMenu deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        WxMenu menu = new WxMenu();
        JsonObject menuJson = json.getAsJsonObject().get("menu").getAsJsonObject();
        JsonArray buttonsJson = menuJson.get("button").getAsJsonArray();
        for (int i = 0; i < buttonsJson.size(); ++i) {
            JsonObject buttonJson = buttonsJson.get(i).getAsJsonObject();
            WxMenu.WxMenuButton button = this.convertFromJson(buttonJson);
            menu.getButtons().add(button);
            if (buttonJson.get("sub_button") == null || buttonJson.get("sub_button").isJsonNull()) continue;
            JsonArray sub_buttonsJson = buttonJson.get("sub_button").getAsJsonArray();
            for (int j = 0; j < sub_buttonsJson.size(); ++j) {
                JsonObject sub_buttonJson = sub_buttonsJson.get(j).getAsJsonObject();
                button.getSubButtons().add(this.convertFromJson(sub_buttonJson));
            }
        }
        return menu;
    }

    protected WxMenu.WxMenuButton convertFromJson(JsonObject json) {
        WxMenu.WxMenuButton button = new WxMenu.WxMenuButton();
        button.setName(GsonHelper.getString(json, "name"));
        button.setKey(GsonHelper.getString(json, "key"));
        button.setUrl(GsonHelper.getString(json, "url"));
        button.setType(GsonHelper.getString(json, "type"));
        return button;
    }
}

