/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.common.bean.oauth2.WxOAuth2AccessToken;
import me.chanjar.weixin.common.bean.result.WxMinishopImageUploadResult;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.open.api.WxOpenComponentService;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.api.WxOpenFastMaService;
import me.chanjar.weixin.open.api.WxOpenMaService;
import me.chanjar.weixin.open.api.WxOpenMinishopService;
import me.chanjar.weixin.open.api.WxOpenMpService;
import me.chanjar.weixin.open.api.WxOpenService;
import me.chanjar.weixin.open.api.impl.WxOpenFastMaServiceImpl;
import me.chanjar.weixin.open.api.impl.WxOpenMaServiceImpl;
import me.chanjar.weixin.open.api.impl.WxOpenMinishopServiceImpl;
import me.chanjar.weixin.open.api.impl.WxOpenMpServiceImpl;
import me.chanjar.weixin.open.bean.WxOpenAuthorizerAccessToken;
import me.chanjar.weixin.open.bean.WxOpenComponentAccessToken;
import me.chanjar.weixin.open.bean.WxOpenCreateResult;
import me.chanjar.weixin.open.bean.WxOpenGetResult;
import me.chanjar.weixin.open.bean.WxOpenMaCodeTemplate;
import me.chanjar.weixin.open.bean.auth.WxOpenAuthorizationInfo;
import me.chanjar.weixin.open.bean.ma.WxOpenMaApplyOrderPathInfo;
import me.chanjar.weixin.open.bean.message.WxOpenXmlMessage;
import me.chanjar.weixin.open.bean.minishop.MinishopBrand;
import me.chanjar.weixin.open.bean.minishop.MinishopBrandList;
import me.chanjar.weixin.open.bean.minishop.MinishopBusiLicense;
import me.chanjar.weixin.open.bean.minishop.MinishopCategories;
import me.chanjar.weixin.open.bean.minishop.MinishopCategory;
import me.chanjar.weixin.open.bean.minishop.MinishopDeliveryTemplate;
import me.chanjar.weixin.open.bean.minishop.MinishopDeliveryTemplateResult;
import me.chanjar.weixin.open.bean.minishop.MinishopIdcardInfo;
import me.chanjar.weixin.open.bean.minishop.MinishopNameInfo;
import me.chanjar.weixin.open.bean.minishop.MinishopOrganizationCodeInfo;
import me.chanjar.weixin.open.bean.minishop.MinishopReturnInfo;
import me.chanjar.weixin.open.bean.minishop.MinishopShopCat;
import me.chanjar.weixin.open.bean.minishop.MinishopShopCatList;
import me.chanjar.weixin.open.bean.minishop.MinishopSuperAdministratorInfo;
import me.chanjar.weixin.open.bean.minishop.coupon.WxMinishopCoupon;
import me.chanjar.weixin.open.bean.minishop.coupon.WxMinishopCouponStock;
import me.chanjar.weixin.open.bean.minishop.goods.WxMinishopAddGoodsSkuData;
import me.chanjar.weixin.open.bean.minishop.goods.WxMinishopAddGoodsSpuData;
import me.chanjar.weixin.open.bean.minishop.goods.WxMinishopAddGoodsSpuResult;
import me.chanjar.weixin.open.bean.minishop.goods.WxMinishopDeliveryCompany;
import me.chanjar.weixin.open.bean.minishop.goods.WxMinishopSku;
import me.chanjar.weixin.open.bean.minishop.goods.WxMinishopSpu;
import me.chanjar.weixin.open.bean.minishop.limitdiscount.LimitDiscountGoods;
import me.chanjar.weixin.open.bean.minishop.limitdiscount.LimitDiscountSku;
import me.chanjar.weixin.open.bean.result.WxOpenAuthorizerInfoResult;
import me.chanjar.weixin.open.bean.result.WxOpenAuthorizerListResult;
import me.chanjar.weixin.open.bean.result.WxOpenAuthorizerOptionResult;
import me.chanjar.weixin.open.bean.result.WxOpenHaveResult;
import me.chanjar.weixin.open.bean.result.WxOpenQueryAuthResult;
import me.chanjar.weixin.open.bean.result.WxOpenRegisterBetaWeappResult;
import me.chanjar.weixin.open.bean.result.WxOpenRegisterPersonalWeappResult;
import me.chanjar.weixin.open.bean.result.WxOpenResult;
import me.chanjar.weixin.open.bean.tcb.ShareCloudBaseEnvRequest;
import me.chanjar.weixin.open.bean.tcb.ShareCloudBaseEnvResponse;
import me.chanjar.weixin.open.bean.tcbComponent.GetShareCloudBaseEnvResponse;
import me.chanjar.weixin.open.bean.tcbComponent.GetTcbEnvListResponse;
import me.chanjar.weixin.open.util.json.WxOpenGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxOpenComponentServiceImpl
implements WxOpenComponentService {
    private static final Logger log = LoggerFactory.getLogger(WxOpenComponentServiceImpl.class);
    private static final Map<String, WxOpenMaService> WX_OPEN_MA_SERVICE_MAP = new ConcurrentHashMap<String, WxOpenMaService>();
    private static final Map<String, WxOpenMpService> WX_OPEN_MP_SERVICE_MAP = new ConcurrentHashMap<String, WxOpenMpService>();
    private static final Map<String, WxOpenFastMaService> WX_OPEN_FAST_MA_SERVICE_MAP = new ConcurrentHashMap<String, WxOpenFastMaService>();
    private static final Map<String, WxOpenMinishopService> WX_OPEN_MINISHOP_SERVICE_MAP = new ConcurrentHashMap<String, WxOpenMinishopService>();
    private final WxOpenService wxOpenService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WxOpenMpService getWxMpServiceByAppid(String appId) {
        WxOpenMpService wxMpService = WX_OPEN_MP_SERVICE_MAP.get(appId);
        if (wxMpService == null) {
            Map<String, WxOpenMpService> map = WX_OPEN_MP_SERVICE_MAP;
            synchronized (map) {
                wxMpService = WX_OPEN_MP_SERVICE_MAP.get(appId);
                if (wxMpService == null) {
                    WxOpenConfigStorage storage = this.getWxOpenConfigStorage();
                    wxMpService = new WxOpenMpServiceImpl(this, appId, storage.getWxMpConfigStorage(appId));
                    wxMpService.setMaxRetryTimes(storage.getMaxRetryTimes());
                    wxMpService.setRetrySleepMillis(storage.getRetrySleepMillis());
                    WX_OPEN_MP_SERVICE_MAP.put(appId, wxMpService);
                }
            }
        }
        return wxMpService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WxOpenMaService getWxMaServiceByAppid(String appId) {
        WxOpenMaService wxOpenMaService = WX_OPEN_MA_SERVICE_MAP.get(appId);
        if (wxOpenMaService == null) {
            Map<String, WxOpenMaService> map = WX_OPEN_MA_SERVICE_MAP;
            synchronized (map) {
                wxOpenMaService = WX_OPEN_MA_SERVICE_MAP.get(appId);
                if (wxOpenMaService == null) {
                    WxOpenConfigStorage storage = this.getWxOpenConfigStorage();
                    wxOpenMaService = new WxOpenMaServiceImpl(this, appId, storage.getWxMaConfig(appId));
                    wxOpenMaService.setMaxRetryTimes(storage.getMaxRetryTimes());
                    wxOpenMaService.setRetrySleepMillis(storage.getRetrySleepMillis());
                    WX_OPEN_MA_SERVICE_MAP.put(appId, wxOpenMaService);
                }
            }
        }
        return wxOpenMaService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WxOpenFastMaService getWxFastMaServiceByAppid(String appId) {
        WxOpenFastMaService fastMaService = WX_OPEN_FAST_MA_SERVICE_MAP.get(appId);
        if (fastMaService == null) {
            Map<String, WxOpenFastMaService> map = WX_OPEN_FAST_MA_SERVICE_MAP;
            synchronized (map) {
                fastMaService = WX_OPEN_FAST_MA_SERVICE_MAP.get(appId);
                if (fastMaService == null) {
                    WxOpenConfigStorage storage = this.getWxOpenConfigStorage();
                    fastMaService = new WxOpenFastMaServiceImpl(this, appId, storage.getWxMaConfig(appId));
                    fastMaService.setMaxRetryTimes(storage.getMaxRetryTimes());
                    fastMaService.setRetrySleepMillis(storage.getRetrySleepMillis());
                    WX_OPEN_FAST_MA_SERVICE_MAP.put(appId, fastMaService);
                }
            }
        }
        return fastMaService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WxOpenMinishopService getWxMinishopServiceByAppid(String appId) {
        WxOpenMinishopService minishopService = WX_OPEN_MINISHOP_SERVICE_MAP.get(appId);
        if (minishopService == null) {
            Map<String, WxOpenMinishopService> map = WX_OPEN_MINISHOP_SERVICE_MAP;
            synchronized (map) {
                minishopService = WX_OPEN_MINISHOP_SERVICE_MAP.get(appId);
                if (minishopService == null) {
                    minishopService = new WxOpenMinishopServiceImpl(this, appId, this.getWxOpenConfigStorage().getWxMaConfig(appId));
                    WX_OPEN_MINISHOP_SERVICE_MAP.put(appId, minishopService);
                }
            }
        }
        return minishopService;
    }

    public WxOpenService getWxOpenService() {
        return this.wxOpenService;
    }

    @Override
    public WxOpenConfigStorage getWxOpenConfigStorage() {
        return this.wxOpenService.getWxOpenConfigStorage();
    }

    @Override
    public boolean checkSignature(String timestamp, String nonce, String signature) {
        try {
            return SHA1.gen((String[])new String[]{this.getWxOpenConfigStorage().getComponentToken(), timestamp, nonce}).equals(signature);
        }
        catch (Exception e) {
            log.error("Checking signature failed, and the reason is :" + e.getMessage());
            return false;
        }
    }

    @Override
    public void startPushTicket() throws WxErrorException {
        WxOpenConfigStorage config = this.getWxOpenConfigStorage();
        JsonObject json = new JsonObject();
        json.addProperty("component_appid", config.getComponentAppId());
        json.addProperty("component_secret", config.getComponentAppSecret());
        this.getWxOpenService().post("https://api.weixin.qq.com/cgi-bin/component/api_start_push_ticket", json.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getComponentAccessToken(boolean forceRefresh) throws WxErrorException {
        WxOpenConfigStorage config = this.getWxOpenConfigStorage();
        if (!config.isComponentAccessTokenExpired() && !forceRefresh) {
            return config.getComponentAccessToken();
        }
        Lock lock = config.getComponentAccessTokenLock();
        lock.lock();
        try {
            if (!config.isComponentAccessTokenExpired() && !forceRefresh) {
                String string = config.getComponentAccessToken();
                return string;
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
            jsonObject.addProperty("component_appsecret", this.getWxOpenConfigStorage().getComponentAppSecret());
            jsonObject.addProperty("component_verify_ticket", this.getWxOpenConfigStorage().getComponentVerifyTicket());
            String responseContent = this.getWxOpenService().post("https://api.weixin.qq.com/cgi-bin/component/api_component_token", jsonObject.toString());
            WxOpenComponentAccessToken componentAccessToken = WxOpenComponentAccessToken.fromJson(responseContent);
            config.updateComponentAccessToken(componentAccessToken);
            String string = config.getComponentAccessToken();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String post(String uri, String postData) throws WxErrorException {
        return this.post(uri, postData, "component_access_token");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String post(String uri, String postData, String accessTokenKey) throws WxErrorException {
        String componentAccessToken = this.getComponentAccessToken(false);
        String uriWithComponentAccessToken = uri + (uri.contains("?") ? "&" : "?") + accessTokenKey + "=" + componentAccessToken;
        try {
            return this.getWxOpenService().post(uriWithComponentAccessToken, postData);
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (WxConsts.ACCESS_TOKEN_ERROR_CODES.contains(error.getErrorCode())) {
                Lock lock = this.getWxOpenConfigStorage().getComponentAccessTokenLock();
                lock.lock();
                try {
                    if (StringUtils.equals((CharSequence)componentAccessToken, (CharSequence)this.getWxOpenConfigStorage().getComponentAccessToken())) {
                        this.getWxOpenConfigStorage().expireComponentAccessToken();
                    }
                }
                catch (Exception ex) {
                    this.getWxOpenConfigStorage().expireComponentAccessToken();
                }
                finally {
                    lock.unlock();
                }
                if (this.getWxOpenConfigStorage().autoRefreshToken()) {
                    log.warn("\u5373\u5c06\u91cd\u65b0\u83b7\u53d6\u65b0\u7684access_token\uff0c\u9519\u8bef\u4ee3\u7801\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)error.getErrorCode(), (Object)error.getErrorMsg());
                    return this.post(uri, postData, accessTokenKey);
                }
            }
            if (error.getErrorCode() != 0) {
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public String post(String uri, String postData, String accessTokenKey, String accessToken) throws WxErrorException {
        String uriWithComponentAccessToken = uri + (uri.contains("?") ? "&" : "?") + accessTokenKey + "=" + accessToken;
        try {
            return this.getWxOpenService().post(uriWithComponentAccessToken, postData);
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() != 0) {
                throw new WxErrorException(error, (Throwable)e);
            }
            return error.getErrorMsg();
        }
    }

    @Override
    public String get(String uri) throws WxErrorException {
        return this.get(uri, "component_access_token");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String uri, String accessTokenKey) throws WxErrorException {
        String componentAccessToken = this.getComponentAccessToken(false);
        String uriWithComponentAccessToken = uri + (uri.contains("?") ? "&" : "?") + accessTokenKey + "=" + componentAccessToken;
        try {
            return this.getWxOpenService().get(uriWithComponentAccessToken, null);
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (WxConsts.ACCESS_TOKEN_ERROR_CODES.contains(error.getErrorCode())) {
                Lock lock = this.getWxOpenConfigStorage().getComponentAccessTokenLock();
                lock.lock();
                try {
                    if (StringUtils.equals((CharSequence)componentAccessToken, (CharSequence)this.getWxOpenConfigStorage().getComponentAccessToken())) {
                        this.getWxOpenConfigStorage().expireComponentAccessToken();
                    }
                }
                catch (Exception ex) {
                    this.getWxOpenConfigStorage().expireComponentAccessToken();
                }
                finally {
                    lock.unlock();
                }
                if (this.getWxOpenConfigStorage().autoRefreshToken()) {
                    log.warn("\u5373\u5c06\u91cd\u65b0\u83b7\u53d6\u65b0\u7684access_token\uff0c\u9519\u8bef\u4ee3\u7801\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)error.getErrorCode(), (Object)error.getErrorMsg());
                    return this.get(uri, accessTokenKey);
                }
            }
            if (error.getErrorCode() != 0) {
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public String getPreAuthUrl(String redirectUri) throws WxErrorException {
        return this.getPreAuthUrl(redirectUri, null, null);
    }

    @Override
    public String getPreAuthUrl(String redirectUri, String authType, String bizAppid) throws WxErrorException {
        return this.createPreAuthUrl(redirectUri, authType, bizAppid, false);
    }

    @Override
    public String getMobilePreAuthUrl(String redirectUri) throws WxErrorException {
        return this.getMobilePreAuthUrl(redirectUri, null, null);
    }

    @Override
    public String getMobilePreAuthUrl(String redirectUri, String authType, String bizAppid) throws WxErrorException {
        return this.createPreAuthUrl(redirectUri, authType, bizAppid, true);
    }

    private String createPreAuthUrl(String redirectUri, String authType, String bizAppid, boolean isMobile) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
        String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/component/api_create_preauthcode", jsonObject.toString());
        jsonObject = (JsonObject)WxGsonBuilder.create().fromJson(responseContent, JsonObject.class);
        String preAuthUrlStr = String.format(isMobile ? "https://open.weixin.qq.com/wxaopen/safe/bindcomponent?action=bindcomponent&no_scan=1&component_appid=%s&pre_auth_code=%s&redirect_uri=%s&auth_type=xxx&biz_appid=xxx#wechat_redirect" : "https://mp.weixin.qq.com/cgi-bin/componentloginpage?component_appid=%s&pre_auth_code=%s&redirect_uri=%s&auth_type=xxx&biz_appid=xxx", this.getWxOpenConfigStorage().getComponentAppId(), jsonObject.get("pre_auth_code").getAsString(), URIUtil.encodeURIComponent((String)redirectUri));
        preAuthUrlStr = StringUtils.isNotEmpty((CharSequence)authType) ? preAuthUrlStr.replace("&auth_type=xxx", "&auth_type=" + authType) : preAuthUrlStr.replace("&auth_type=xxx", "");
        preAuthUrlStr = StringUtils.isNotEmpty((CharSequence)bizAppid) ? preAuthUrlStr.replace("&biz_appid=xxx", "&biz_appid=" + bizAppid) : preAuthUrlStr.replace("&biz_appid=xxx", "");
        return preAuthUrlStr;
    }

    @Override
    public String route(WxOpenXmlMessage wxMessage) throws WxErrorException {
        if (wxMessage == null) {
            throw new NullPointerException("message is empty");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)wxMessage.getInfoType(), (CharSequence)"component_verify_ticket")) {
            this.getWxOpenConfigStorage().setComponentVerifyTicket(wxMessage.getComponentVerifyTicket());
            return "success";
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)wxMessage.getInfoType(), (CharSequence[])new CharSequence[]{"authorized", "updateauthorized"})) {
            WxOpenQueryAuthResult queryAuth = this.wxOpenService.getWxOpenComponentService().getQueryAuth(wxMessage.getAuthorizationCode());
            if (queryAuth == null || queryAuth.getAuthorizationInfo() == null || queryAuth.getAuthorizationInfo().getAuthorizerAppid() == null) {
                throw new NullPointerException("getQueryAuth");
            }
            return "success";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)wxMessage.getInfoType(), (CharSequence)"notify_third_fasteregister") && wxMessage.getStatus() == 0) {
            WxOpenQueryAuthResult queryAuth = this.wxOpenService.getWxOpenComponentService().getQueryAuth(wxMessage.getAuthCode());
            if (queryAuth == null || queryAuth.getAuthorizationInfo() == null || queryAuth.getAuthorizationInfo().getAuthorizerAppid() == null) {
                throw new NullPointerException("getQueryAuth");
            }
            return "success";
        }
        return "";
    }

    @Override
    public WxOpenQueryAuthResult getQueryAuth(String authorizationCode) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
        jsonObject.addProperty("authorization_code", authorizationCode);
        String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/component/api_query_auth", jsonObject.toString());
        WxOpenQueryAuthResult queryAuth = (WxOpenQueryAuthResult)WxOpenGsonBuilder.create().fromJson(responseContent, WxOpenQueryAuthResult.class);
        if (queryAuth == null || queryAuth.getAuthorizationInfo() == null) {
            return queryAuth;
        }
        WxOpenAuthorizationInfo authorizationInfo = queryAuth.getAuthorizationInfo();
        if (authorizationInfo.getAuthorizerAccessToken() != null) {
            this.getWxOpenConfigStorage().updateAuthorizerAccessToken(authorizationInfo.getAuthorizerAppid(), authorizationInfo.getAuthorizerAccessToken(), authorizationInfo.getExpiresIn());
        }
        if (authorizationInfo.getAuthorizerRefreshToken() != null) {
            this.getWxOpenConfigStorage().updateAuthorizerRefreshToken(authorizationInfo.getAuthorizerAppid(), authorizationInfo.getAuthorizerRefreshToken());
        }
        return queryAuth;
    }

    @Override
    public WxOpenAuthorizerInfoResult getAuthorizerInfo(String authorizerAppid) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
        jsonObject.addProperty("authorizer_appid", authorizerAppid);
        String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/component/api_get_authorizer_info", jsonObject.toString());
        return (WxOpenAuthorizerInfoResult)WxOpenGsonBuilder.create().fromJson(responseContent, WxOpenAuthorizerInfoResult.class);
    }

    @Override
    public WxOpenAuthorizerListResult getAuthorizerList(int begin, int len) throws WxErrorException {
        begin = Math.max(begin, 0);
        len = len == 0 ? 10 : len;
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
        jsonObject.addProperty("offset", (Number)begin);
        jsonObject.addProperty("count", (Number)len);
        String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/component/api_get_authorizer_list", jsonObject.toString());
        WxOpenAuthorizerListResult ret = (WxOpenAuthorizerListResult)WxOpenGsonBuilder.create().fromJson(responseContent, WxOpenAuthorizerListResult.class);
        if (ret != null && ret.getList() != null) {
            for (Map<String, String> data : ret.getList()) {
                String authorizerAppid = data.get("authorizer_appid");
                String refreshToken = data.get("refresh_token");
                if (authorizerAppid == null || refreshToken == null) continue;
                this.getWxOpenConfigStorage().updateAuthorizerRefreshToken(authorizerAppid, refreshToken);
            }
        }
        return ret;
    }

    @Override
    public WxOpenAuthorizerOptionResult getAuthorizerOption(String authorizerAppid, String optionName) throws WxErrorException {
        String authorizerAccessToken = this.getAuthorizerAccessToken(authorizerAppid, false);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
        jsonObject.addProperty("authorizer_appid", authorizerAppid);
        jsonObject.addProperty("option_name", optionName);
        String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/component/get_authorizer_option", jsonObject.toString(), "access_token", authorizerAccessToken);
        return (WxOpenAuthorizerOptionResult)WxOpenGsonBuilder.create().fromJson(responseContent, WxOpenAuthorizerOptionResult.class);
    }

    @Override
    public void setAuthorizerOption(String authorizerAppid, String optionName, String optionValue) throws WxErrorException {
        String authorizerAccessToken = this.getAuthorizerAccessToken(authorizerAppid, false);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
        jsonObject.addProperty("authorizer_appid", authorizerAppid);
        jsonObject.addProperty("option_name", optionName);
        jsonObject.addProperty("option_value", optionValue);
        this.post("https://api.weixin.qq.com/cgi-bin/component/set_authorizer_option", jsonObject.toString(), "access_token", authorizerAccessToken);
    }

    @Override
    public String getAuthorizerAccessToken(String appId, boolean forceRefresh) throws WxErrorException {
        WxOpenConfigStorage config = this.getWxOpenConfigStorage();
        if (!config.isAuthorizerAccessTokenExpired(appId) && !forceRefresh) {
            return config.getAuthorizerAccessToken(appId);
        }
        Lock lock = config.getWxMpConfigStorage(appId).getAccessTokenLock();
        boolean locked = false;
        try {
            do {
                locked = lock.tryLock(100L, TimeUnit.MILLISECONDS);
                if (forceRefresh || config.isAuthorizerAccessTokenExpired(appId)) continue;
                String string = config.getAuthorizerAccessToken(appId);
                return string;
            } while (!locked);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
            jsonObject.addProperty("authorizer_appid", appId);
            jsonObject.addProperty("authorizer_refresh_token", this.getWxOpenConfigStorage().getAuthorizerRefreshToken(appId));
            String responseContent = this.post("https://api.weixin.qq.com/cgi-bin/component/api_authorizer_token", jsonObject.toString());
            WxOpenAuthorizerAccessToken wxOpenAuthorizerAccessToken = WxOpenAuthorizerAccessToken.fromJson(responseContent);
            config.updateAuthorizerAccessToken(appId, wxOpenAuthorizerAccessToken);
            config.updateAuthorizerRefreshToken(appId, wxOpenAuthorizerAccessToken.getAuthorizerRefreshToken());
            String string = config.getAuthorizerAccessToken(appId);
            return string;
        }
        catch (InterruptedException e) {
            throw new WxRuntimeException((Throwable)e);
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    @Override
    public WxOAuth2AccessToken oauth2getAccessToken(String appId, String code) throws WxErrorException {
        String url = String.format("https://api.weixin.qq.com/sns/oauth2/component/access_token?appid=%s&code=%s&grant_type=authorization_code&component_appid=%s", appId, code, this.getWxOpenConfigStorage().getComponentAppId());
        String responseContent = this.get(url);
        return WxOAuth2AccessToken.fromJson((String)responseContent);
    }

    @Override
    public boolean checkSignature(String appid, String timestamp, String nonce, String signature) {
        return false;
    }

    @Override
    public WxOAuth2AccessToken oauth2refreshAccessToken(String appId, String refreshToken) throws WxErrorException {
        String url = String.format("https://api.weixin.qq.com/sns/oauth2/component/refresh_token?appid=%s&grant_type=refresh_token&refresh_token=%s&component_appid=%s", appId, refreshToken, this.getWxOpenConfigStorage().getComponentAppId());
        String responseContent = this.get(url);
        return WxOAuth2AccessToken.fromJson((String)responseContent);
    }

    @Override
    public String oauth2buildAuthorizationUrl(String appId, String redirectURI, String scope, String state) {
        return String.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s&component_appid=%s#wechat_redirect", appId, URIUtil.encodeURIComponent((String)redirectURI), scope, StringUtils.trimToEmpty((String)state), this.getWxOpenConfigStorage().getComponentAppId());
    }

    @Override
    public WxMaJscode2SessionResult miniappJscode2Session(String appId, String jsCode) throws WxErrorException {
        String url = String.format("https://api.weixin.qq.com/sns/component/jscode2session?appid=%s&js_code=%s&grant_type=authorization_code&component_appid=%s", appId, jsCode, this.getWxOpenConfigStorage().getComponentAppId());
        String responseContent = this.get(url);
        return WxMaJscode2SessionResult.fromJson((String)responseContent);
    }

    @Override
    public List<WxOpenMaCodeTemplate> getTemplateDraftList() throws WxErrorException {
        String responseContent = this.get("https://api.weixin.qq.com/wxa/gettemplatedraftlist", "access_token");
        JsonObject response = GsonParser.parse((String)StringUtils.defaultString((String)responseContent, (String)"{}"));
        boolean hasDraftList = response.has("draft_list");
        if (hasDraftList) {
            return (List)WxOpenGsonBuilder.create().fromJson((JsonElement)response.getAsJsonArray("draft_list"), new TypeToken<List<WxOpenMaCodeTemplate>>(){}.getType());
        }
        return null;
    }

    @Override
    public List<WxOpenMaCodeTemplate> getTemplateList() throws WxErrorException {
        return this.getTemplateList(null);
    }

    @Override
    public List<WxOpenMaCodeTemplate> getTemplateList(Integer templateType) throws WxErrorException {
        String url = "https://api.weixin.qq.com/wxa/gettemplatelist" + (templateType == null ? "" : "?template_type=" + templateType);
        String responseContent = this.get(url, "access_token");
        JsonObject response = GsonParser.parse((String)StringUtils.defaultString((String)responseContent, (String)"{}"));
        boolean hasTemplateList = response.has("template_list");
        if (hasTemplateList) {
            return (List)WxOpenGsonBuilder.create().fromJson((JsonElement)response.getAsJsonArray("template_list"), new TypeToken<List<WxOpenMaCodeTemplate>>(){}.getType());
        }
        return null;
    }

    @Override
    public void addToTemplate(long draftId) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("draft_id", (Number)draftId);
        this.post("https://api.weixin.qq.com/wxa/addtotemplate", param.toString(), "access_token");
    }

    @Override
    public void addToTemplate(long draftId, int templateType) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("draft_id", (Number)draftId);
        param.addProperty("template_type", (Number)templateType);
        this.post("https://api.weixin.qq.com/wxa/addtotemplate", param.toString(), "access_token");
    }

    @Override
    public void deleteTemplate(long templateId) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("template_id", (Number)templateId);
        this.post("https://api.weixin.qq.com/wxa/deletetemplate", param.toString(), "access_token");
    }

    private String openAccountServicePost(String appId, String appIdType, String requestUrl, JsonObject param) throws WxErrorException {
        String result = "";
        switch (appIdType) {
            case "mp": {
                WxOpenMpService wxMpService = this.getWxMpServiceByAppid(appId);
                result = wxMpService.post(requestUrl, param.toString());
                return result;
            }
            case "mini": {
                WxOpenMaService maService = this.getWxMaServiceByAppid(appId);
                result = maService.post(requestUrl, param.toString());
                return result;
            }
        }
        throw new WxErrorException("appIdType\u7c7b\u578b\u5f02\u5e38");
    }

    @Override
    public WxOpenCreateResult createOpenAccount(String appId, String appIdType) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("appid", appId);
        String json = this.openAccountServicePost(appId, appIdType, "https://api.weixin.qq.com/cgi-bin/open/create", param);
        return WxOpenCreateResult.fromJson(json);
    }

    @Override
    public Boolean bindOpenAccount(String appId, String appIdType, String openAppid) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("appid", appId);
        param.addProperty("open_appid", openAppid);
        String json = this.openAccountServicePost(appId, appIdType, "https://api.weixin.qq.com/cgi-bin/open/bind", param);
        return WxOpenResult.fromJson(json).isSuccess();
    }

    @Override
    public Boolean unbindOpenAccount(String appId, String appIdType, String openAppid) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("appid", appId);
        param.addProperty("open_appid", openAppid);
        String json = this.openAccountServicePost(appId, appIdType, "https://api.weixin.qq.com/cgi-bin/open/unbind", param);
        return WxOpenResult.fromJson(json).isSuccess();
    }

    @Override
    public WxOpenGetResult getOpenAccount(String appId, String appIdType) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("appid", appId);
        String json = this.openAccountServicePost(appId, appIdType, "https://api.weixin.qq.com/cgi-bin/open/get", param);
        return WxOpenGetResult.fromJson(json);
    }

    @Override
    public WxOpenHaveResult haveOpen() throws WxErrorException {
        String json = this.get("https://api.weixin.qq.com/cgi-bin/open/have", "access_token");
        return WxOpenHaveResult.fromJson(json);
    }

    @Override
    public WxOpenResult fastRegisterWeapp(String name, String code, String codeType, String legalPersonaWechat, String legalPersonaName, String componentPhone) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", name);
        jsonObject.addProperty("code", code);
        jsonObject.addProperty("code_type", codeType);
        jsonObject.addProperty("legal_persona_wechat", legalPersonaWechat);
        jsonObject.addProperty("legal_persona_name", legalPersonaName);
        jsonObject.addProperty("component_phone", componentPhone);
        String response = this.post("https://api.weixin.qq.com/cgi-bin/component/fastregisterweapp?action=create", jsonObject.toString(), "component_access_token");
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult fastRegisterWeappSearch(String name, String legalPersonaWechat, String legalPersonaName) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", name);
        jsonObject.addProperty("legal_persona_wechat", legalPersonaWechat);
        jsonObject.addProperty("legal_persona_name", legalPersonaName);
        String response = this.post("https://api.weixin.qq.com/cgi-bin/component/fastregisterweapp?action=search", jsonObject.toString(), "component_access_token");
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenRegisterPersonalWeappResult fastRegisterPersonalWeapp(String idname, String wxuser, String componentPhone) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("idname", idname);
        jsonObject.addProperty("wxuser", wxuser);
        jsonObject.addProperty("component_phone", componentPhone);
        String response = this.post("https://api.weixin.qq.com/wxa/component/fastregisterpersonalweapp?action=create", jsonObject.toString(), "component_access_token");
        return (WxOpenRegisterPersonalWeappResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenRegisterPersonalWeappResult.class);
    }

    @Override
    public WxOpenRegisterPersonalWeappResult fastRegisterPersonalWeappSearch(String taskid) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("taskid", taskid);
        String response = this.post("https://api.weixin.qq.com/wxa/component/fastregisterpersonalweapp?action=query", jsonObject.toString(), "component_access_token");
        return (WxOpenRegisterPersonalWeappResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenRegisterPersonalWeappResult.class);
    }

    @Override
    public WxOpenRegisterBetaWeappResult fastRegisterBetaWeapp(String name, String openid) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", name);
        jsonObject.addProperty("openid", openid);
        String response = this.wxOpenService.getWxOpenComponentService().post("https://api.weixin.qq.com/wxa/component/fastregisterbetaweapp", jsonObject.toString(), "access_token");
        return (WxOpenRegisterBetaWeappResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenRegisterBetaWeappResult.class);
    }

    @Override
    public WxOpenResult registerShop(String wxName, String idCardName, String idCardNumber, String channelId, Integer apiOpenstoreType, String authPageUrl) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("wx_name", wxName);
        jsonObject.addProperty("id_card_name", idCardName);
        jsonObject.addProperty("id_card_number", idCardNumber);
        if (channelId != null && !channelId.isEmpty()) {
            jsonObject.addProperty("channel_id", channelId);
        }
        jsonObject.addProperty("api_openstore_type", (Number)apiOpenstoreType);
        if (authPageUrl != null && !authPageUrl.isEmpty()) {
            jsonObject.addProperty("auth_page_url", authPageUrl);
        }
        String response = this.post("https://api.weixin.qq.com/product/register/register_shop", jsonObject.toString(), "component_access_token");
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public String checkAuditStatus(String wxName) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("wx_name", wxName);
        String url = "https://api.weixin.qq.com/product/register/check_audit_status?access_token=" + this.getComponentAccessToken(false);
        String response = this.post(url, jsonObject.toString());
        log.info("CHECK_SHOP_AUDITSTATUS_URL: " + response);
        return response;
    }

    @Override
    public String checkAuditStatus(String appId, String wxName) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("wx_name", wxName);
        String url = "https://api.weixin.qq.com/product/register/check_audit_status?access_token=" + this.getAuthorizerAccessToken(appId, false);
        String response = this.post(url, jsonObject.toString());
        log.info("CHECK_SHOP_AUDITSTATUS_URL: " + response);
        return response;
    }

    @Override
    public WxOpenResult submitMerchantInfo(String appId, String subjectType, MinishopBusiLicense busiLicense, MinishopOrganizationCodeInfo organizationCodeInfo, MinishopIdcardInfo idcardInfo, MinishopSuperAdministratorInfo superAdministratorInfo, String merchantShoprtName) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("app_id", appId);
        jsonObject.addProperty("subject_type", subjectType);
        jsonObject.add("busi_license", (JsonElement)busiLicense.toJsonObject());
        if (organizationCodeInfo != null) {
            jsonObject.add("organization_code_info", (JsonElement)organizationCodeInfo.toJsonObject());
        }
        if (idcardInfo != null) {
            jsonObject.add("id_card_info", (JsonElement)idcardInfo.toJsonObject());
        }
        if (superAdministratorInfo != null) {
            jsonObject.add("super_administrator_info", (JsonElement)superAdministratorInfo.toJsonObject());
        }
        if (merchantShoprtName != null) {
            jsonObject.addProperty("merchant_shortname", merchantShoprtName);
        }
        String url = "https://api.weixin.qq.com/product/register/submit_merchantinfo?access_token=" + this.getAuthorizerAccessToken(appId, false);
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult submitBasicInfo(String appId, MinishopNameInfo nameInfo, MinishopReturnInfo returnInfo) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("appid", appId);
        jsonObject.add("name_info", (JsonElement)nameInfo.toJsonObject());
        jsonObject.add("return_info", (JsonElement)returnInfo.toJsonObject());
        String url = "https://api.weixin.qq.com/product/register/submit_basicinfo?access_token=" + this.getAuthorizerAccessToken(appId, false);
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxMinishopImageUploadResult uploadMinishopImagePicFile(String appId, Integer height, Integer width, File file) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/img/upload?access_token=" + this.getAuthorizerAccessToken(appId, false) + "&height=" + height + "&width=" + width;
        log.info("upload url: " + url);
        WxMinishopImageUploadResult result = this.getWxOpenService().uploadMinishopMediaFile(url, file);
        return result;
    }

    @Override
    public MinishopCategories getMinishopCategories(String appId, Integer fCatId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("f_cat_id", (Number)fCatId);
        String url = "https://api.weixin.qq.com/product/category/get?access_token=" + this.getAuthorizerAccessToken(appId, false);
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        log.info("response: " + response);
        JsonObject respJson = GsonParser.parse((String)response);
        MinishopCategories categories = new MinishopCategories();
        categories.setErrcode(respJson.get("errcode").getAsInt());
        if (categories.getErrcode() == 0) {
            JsonArray catListJson = respJson.getAsJsonArray("cat_list");
            if (catListJson != null || catListJson.size() > 0) {
                ArrayList<MinishopCategory> categoryList = new ArrayList<MinishopCategory>();
                for (int i = 0; i < catListJson.size(); ++i) {
                    JsonObject catJson = catListJson.get(i).getAsJsonObject();
                    MinishopCategory cate = new MinishopCategory();
                    cate.setCatId(catJson.get("cat_id").getAsInt());
                    cate.setFCatId(catJson.get("f_cat_id").getAsInt());
                    cate.setName(catJson.get("name").getAsString());
                    categoryList.add(cate);
                }
                categories.setCatList(categoryList);
            }
        } else {
            categories.setErrmsg(respJson.get("errmsg").getAsString());
        }
        return categories;
    }

    @Override
    public MinishopBrandList getMinishopBrands(String appId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        String url = "https://api.weixin.qq.com/product/brand/get?access_token=" + this.getAuthorizerAccessToken(appId, false);
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        JsonObject respJson = GsonParser.parse((String)response);
        MinishopBrandList brandList = new MinishopBrandList();
        brandList.setErrcode(respJson.get("errcode").getAsInt());
        if (brandList.getErrcode() == 0) {
            JsonArray brandArrayJson = respJson.get("brands").getAsJsonArray();
            if (brandArrayJson.size() > 0) {
                ArrayList<MinishopBrand> brands = new ArrayList<MinishopBrand>();
                for (int i = 0; i < brandArrayJson.size(); ++i) {
                    JsonObject brandJson = brandArrayJson.get(i).getAsJsonObject();
                    MinishopBrand brand = new MinishopBrand();
                    brand.setFirstCatId(brandJson.get("first_cat_id").getAsInt());
                    brand.setSecondCatId(brandJson.get("second_cat_id").getAsInt());
                    brand.setThirdCatId(brandJson.get("third_cat_id").getAsInt());
                    MinishopBrand.MinishopBrandInfo brandInfo = new MinishopBrand.MinishopBrandInfo();
                    JsonObject brandInfoJson = brandJson.get("brand_info").getAsJsonObject();
                    brandInfo.setBrandId(brandInfoJson.get("brand_id").getAsInt());
                    brandInfo.setBrandName(brandInfoJson.get("brand_name").getAsString());
                    brand.setBrandInfo(brandInfo);
                    brands.add(brand);
                }
                brandList.setBrands(brands);
            }
        } else {
            brandList.setErrmsg(respJson.get("errmsg").getAsString());
        }
        return brandList;
    }

    @Override
    public MinishopDeliveryTemplateResult getMinishopDeliveryTemplate(String appId) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/delivery/get_freight_template?access_token=" + this.getAuthorizerAccessToken(appId, false);
        JsonObject jsonObject = new JsonObject();
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        JsonObject respJson = GsonParser.parse((String)response);
        MinishopDeliveryTemplateResult templateResult = new MinishopDeliveryTemplateResult();
        templateResult.setErrCode(respJson.get("errcode").getAsInt());
        if (templateResult.getErrCode() == 0) {
            JsonArray templateArrayJson = respJson.get("template_list").getAsJsonArray();
            if (templateArrayJson.size() > 0) {
                ArrayList<MinishopDeliveryTemplate> templateList = new ArrayList<MinishopDeliveryTemplate>();
                for (int i = 0; i < templateArrayJson.size(); ++i) {
                    JsonObject templateJson = templateArrayJson.get(i).getAsJsonObject();
                    MinishopDeliveryTemplate template = new MinishopDeliveryTemplate();
                    template.setTemplateId(templateJson.get("template_id").getAsInt());
                    template.setName(templateJson.get("name").getAsString());
                    template.setValuationType(templateJson.get("valuation_type").getAsInt() == 1 ? MinishopDeliveryTemplate.ValuationType.WEIGHT : MinishopDeliveryTemplate.ValuationType.PACKAGE);
                    templateList.add(template);
                }
                templateResult.setTemplateList(templateList);
            }
        } else {
            templateResult.setErrMsg(respJson.get("errmsg").getAsString());
        }
        return templateResult;
    }

    @Override
    public MinishopShopCatList getMinishopCatList(String appId) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/store/get_shopcat?access_token=" + this.getAuthorizerAccessToken(appId, false);
        JsonObject jsonObject = new JsonObject();
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        JsonObject respJson = GsonParser.parse((String)response);
        MinishopShopCatList shopCatList = new MinishopShopCatList();
        shopCatList.setErrcode(respJson.get("errcode").getAsInt());
        if (shopCatList.getErrcode() == 0) {
            JsonArray shopcatArrayJson = respJson.get("shopcat_list").getAsJsonArray();
            if (shopcatArrayJson.size() > 0) {
                ArrayList<MinishopShopCat> shopCats = new ArrayList<MinishopShopCat>();
                for (int i = 0; i < shopcatArrayJson.size(); ++i) {
                    JsonObject shopCatJson = shopcatArrayJson.get(i).getAsJsonObject();
                    MinishopShopCat shopCat = new MinishopShopCat();
                    shopCat.setShopCatId(shopCatJson.get("shopcat_id").getAsInt());
                    shopCat.setShopCatName(shopCatJson.get("shopcat_name").getAsString());
                    shopCat.setFShopCatId(shopCatJson.get("f_shopcat_id").getAsInt());
                    shopCat.setCatLevel(shopCatJson.get("cat_level").getAsInt());
                    shopCats.add(shopCat);
                }
                shopCatList.setShopCatList(shopCats);
            }
        } else {
            shopCatList.setErrmsg(respJson.get("errmsg").getAsString());
        }
        return shopCatList;
    }

    @Override
    public WxMinishopAddGoodsSpuResult<List<WxMinishopDeliveryCompany>> getMinishopDeliveryCompany(String appId) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/delivery/get_company_list?access_token=" + this.getAuthorizerAccessToken(appId, false);
        JsonObject jsonObject = new JsonObject();
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        JsonObject respObj = GsonParser.parse((String)response);
        WxMinishopAddGoodsSpuResult<List<WxMinishopDeliveryCompany>> result = new WxMinishopAddGoodsSpuResult<List<WxMinishopDeliveryCompany>>();
        result.setErrcode(respObj.get("errcode").getAsInt());
        if (result.getErrcode() == 0) {
            JsonArray companyArray = respObj.get("company_list").getAsJsonArray();
            ArrayList<WxMinishopDeliveryCompany> companies = new ArrayList<WxMinishopDeliveryCompany>();
            for (int i = 0; i < companyArray.size(); ++i) {
                JsonObject company = companyArray.get(i).getAsJsonObject();
                WxMinishopDeliveryCompany resultData = new WxMinishopDeliveryCompany();
                resultData.setDeliveryId(company.get("delivery_id").getAsString());
                resultData.setDeliveryName(company.get("delivery_name").getAsString());
                companies.add(resultData);
            }
            result.setData(companies);
        } else {
            result.setErrmsg(respObj.get("errmsg").getAsString());
        }
        return result;
    }

    @Override
    public Integer minishopCreateCoupon(String appId, WxMinishopCoupon couponInfo) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/coupon/create?access_token=" + this.getAuthorizerAccessToken(appId, true);
        JsonObject jsonObject = couponInfo.toJsonObject();
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        JsonObject respJson = GsonParser.parse((String)response);
        Integer couponId = -1;
        if (respJson.get("errcode").getAsInt() == 0) {
            JsonObject dataJson = respJson.get("data").getAsJsonObject();
            couponId = dataJson.get("coupon_id").getAsInt();
        }
        return couponId;
    }

    @Override
    public WxMinishopCouponStock minishopGetCouponList(String appId, String startCreateTime, String endCreateTime, Integer status, Integer page, Integer pageSize) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/coupon/get_list?access_token=" + this.getAuthorizerAccessToken(appId, true);
        JsonObject jsonObject = new JsonObject();
        return null;
    }

    @Override
    public WxOpenResult minishopPushCouponToUser(String appId, String openId, Integer couponId) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/coupon/push?access_token=" + this.getAuthorizerAccessToken(appId, true);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("openid", openId);
        jsonObject.addProperty("coupon_id", (Number)couponId);
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public Integer minishopUpdateCoupon(String appId, WxMinishopCoupon couponInfo) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/coupon/update?access_token=" + this.getAuthorizerAccessToken(appId, true);
        JsonObject jsonObject = couponInfo.toJsonObject();
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        JsonObject respJson = GsonParser.parse((String)response);
        Integer couponId = -1;
        if (respJson.get("errcode").getAsInt() == 0) {
            JsonObject dataJson = respJson.get("data").getAsJsonObject();
            couponId = dataJson.get("coupon_id").getAsInt();
        }
        return couponId;
    }

    @Override
    public WxOpenResult minishopUpdateCouponStatus(String appId, Integer couponId, Integer status) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/coupon/update_status?access_token=" + this.getAuthorizerAccessToken(appId, true);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("coupon_id", (Number)couponId);
        jsonObject.addProperty("status", (Number)status);
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxMinishopAddGoodsSpuResult<WxMinishopAddGoodsSpuData> minishopGoodsAddSpu(String appId, WxMinishopSpu spu) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/spu/add?access_token=" + this.getAuthorizerAccessToken(appId, true);
        JsonObject jsonObject = spu.toJsonObject();
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        JsonObject respObj = GsonParser.parse((String)response);
        WxMinishopAddGoodsSpuResult<WxMinishopAddGoodsSpuData> result = new WxMinishopAddGoodsSpuResult<WxMinishopAddGoodsSpuData>();
        result.setErrcode(respObj.get("errcode").getAsInt());
        if (result.getErrcode() == 0) {
            JsonObject dataObj = respObj.get("data").getAsJsonObject();
            WxMinishopAddGoodsSpuData resultData = new WxMinishopAddGoodsSpuData();
            resultData.setProductId(dataObj.get("product_id").getAsLong());
            resultData.setOutProductId(dataObj.get("out_product_id").getAsString());
            resultData.setCreateTime(dataObj.get("create_time").getAsString());
            result.setData(resultData);
        } else {
            result.setErrmsg(respObj.get("errmsg").getAsString());
        }
        return result;
    }

    @Override
    public WxOpenResult minishopGoodsDelSpu(String appId, Long productId, Long outProductId) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/spu/del?access_token=" + this.getAuthorizerAccessToken(appId, true);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("product_id", (Number)productId);
        jsonObject.addProperty("out_product_id", outProductId.toString());
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxMinishopAddGoodsSpuResult<WxMinishopAddGoodsSpuData> minishopGoodsUpdateSpu(String appId, WxMinishopSpu spu) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/spu/update?access_token=" + this.getAuthorizerAccessToken(appId, true);
        JsonObject jsonObject = spu.toJsonObject();
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        JsonObject respObj = GsonParser.parse((String)response);
        WxMinishopAddGoodsSpuResult<WxMinishopAddGoodsSpuData> result = new WxMinishopAddGoodsSpuResult<WxMinishopAddGoodsSpuData>();
        result.setErrcode(respObj.get("errcode").getAsInt());
        if (result.getErrcode() == 0) {
            JsonObject dataObj = respObj.get("data").getAsJsonObject();
            WxMinishopAddGoodsSpuData resultData = new WxMinishopAddGoodsSpuData();
            resultData.setProductId(dataObj.get("product_id").getAsLong());
            resultData.setOutProductId(dataObj.get("out_product_id").getAsString());
            resultData.setCreateTime(dataObj.get("update_time").getAsString());
            result.setData(resultData);
        } else {
            result.setErrmsg(respObj.get("errmsg").getAsString());
        }
        return result;
    }

    @Override
    public WxOpenResult minishopGoodsListingSpu(String appId, Long productId, Long outProductId) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/spu/listing?access_token=" + this.getAuthorizerAccessToken(appId, true);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("product_id", (Number)productId);
        jsonObject.addProperty("out_product_id", outProductId.toString());
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult minishopGoodsDelistingSpu(String appId, Long productId, Long outProductId) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/spu/delisting?access_token=" + this.getAuthorizerAccessToken(appId, true);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("product_id", (Number)productId);
        jsonObject.addProperty("out_product_id", outProductId.toString());
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxMinishopAddGoodsSpuResult<WxMinishopAddGoodsSkuData> minishiopGoodsAddSku(String appId, WxMinishopSku sku) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/sku/add?access_token=" + this.getAuthorizerAccessToken(appId, true);
        JsonObject jsonObject = sku.toJsonObject();
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        JsonObject respObj = GsonParser.parse((String)response);
        WxMinishopAddGoodsSpuResult<WxMinishopAddGoodsSkuData> result = new WxMinishopAddGoodsSpuResult<WxMinishopAddGoodsSkuData>();
        result.setErrcode(respObj.get("errcode").getAsInt());
        if (result.getErrcode() == 0) {
            JsonObject dataObj = respObj.get("data").getAsJsonObject();
            WxMinishopAddGoodsSkuData resultData = new WxMinishopAddGoodsSkuData();
            resultData.setSkuId(dataObj.get("sku_id").getAsLong());
            resultData.setCreateTime(dataObj.get("create_time").getAsString());
            result.setData(resultData);
        } else {
            result.setErrmsg(respObj.get("errmsg").getAsString());
        }
        return result;
    }

    @Override
    public WxOpenResult minishopGoodsBatchAddSku(String appId, List<WxMinishopSku> skuList) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/sku/batch_add?access_token=" + this.getAuthorizerAccessToken(appId, true);
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (WxMinishopSku sku : skuList) {
            jsonArray.add((JsonElement)sku.toJsonObject());
        }
        jsonObject.add("skus", (JsonElement)jsonArray);
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult minishopGoodsDelSku(String appId, Long productId, Long outProductId, String outSkuId, Long skuId) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/sku/del?access_token=" + this.getAuthorizerAccessToken(appId, true);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("product_id", (Number)productId);
        jsonObject.addProperty("out_product_id", (Number)outProductId);
        jsonObject.addProperty("sku_id", (Number)skuId);
        jsonObject.addProperty("out_sku_id", outSkuId);
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult minishopGoodsUpdateSku(String appId, WxMinishopSku sku) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/sku/update?access_token=" + this.getAuthorizerAccessToken(appId, true);
        JsonObject jsonObject = sku.toJsonObject();
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult minishopGoodsUpdateSkuPrice(String appId, Long productId, Long outProductId, String outSkuId, Long skuId, Long salePrice, Long marketPrice) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/sku/update_price?access_token=" + this.getAuthorizerAccessToken(appId, true);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("product_id", (Number)productId);
        jsonObject.addProperty("out_product_id", (Number)outProductId);
        jsonObject.addProperty("sku_id", (Number)skuId);
        jsonObject.addProperty("out_sku_id", outSkuId);
        jsonObject.addProperty("sale_price", outSkuId);
        jsonObject.addProperty("market_price", outSkuId);
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult minishopGoodsUpdateSkuStock(String appId, Long productId, Long outProductId, String outSkuId, Long skuId, Integer type, Integer stockNum) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/stock/update?access_token=" + this.getAuthorizerAccessToken(appId, true);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("product_id", (Number)productId);
        jsonObject.addProperty("out_product_id", (Number)outProductId);
        jsonObject.addProperty("sku_id", (Number)skuId);
        jsonObject.addProperty("out_sku_id", outSkuId);
        jsonObject.addProperty("type", (Number)type);
        jsonObject.addProperty("stock_num", (Number)stockNum);
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public String minishopCommonPost(String appId, String url, String requestParam) throws WxErrorException {
        return null;
    }

    @Override
    public Integer addLimitDiscountGoods(String appId, LimitDiscountGoods limitDiscountGoods) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/limiteddiscount/add/access_token=" + this.getAuthorizerAccessToken(appId, false);
        JsonObject jsonObject = limitDiscountGoods.toJsonObject();
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        JsonObject respObj = GsonParser.parse((String)response);
        Integer taskId = 0;
        if (respObj.get("errcode").getAsInt() == 0) {
            taskId = respObj.get("task_id").getAsInt();
        }
        return taskId;
    }

    @Override
    public List<LimitDiscountGoods> getLimitDiscountList(String appId, Integer status) throws WxErrorException {
        JsonArray jsonArray;
        String url = "https://api.weixin.qq.com/product/limiteddiscount/get_list/access_token=" + this.getAuthorizerAccessToken(appId, false);
        JsonObject jsonObject = new JsonObject();
        if (status != null) {
            jsonObject.addProperty("status", (Number)status);
        }
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        JsonObject respObj = GsonParser.parse((String)response);
        ArrayList<LimitDiscountGoods> limitDiscountGoodsList = new ArrayList<LimitDiscountGoods>();
        if (respObj.get("errcode").getAsInt() == 0 && (jsonArray = respObj.get("limited_discount_list").getAsJsonArray()) != null && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject goodsObj = jsonArray.get(i).getAsJsonObject();
                LimitDiscountGoods discountGoods = new LimitDiscountGoods();
                discountGoods.setTaskId(goodsObj.get("task_id").getAsLong());
                discountGoods.setStatus(goodsObj.get("status").getAsInt());
                discountGoods.setStartTime(new Date(goodsObj.get("start_time").getAsLong() * 1000L));
                discountGoods.setEndTime(new Date(goodsObj.get("end_time").getAsLong() * 1000L));
                ArrayList<LimitDiscountSku> skuList = new ArrayList<LimitDiscountSku>();
                JsonArray skuArray = goodsObj.get("limited_discount_sku_list").getAsJsonArray();
                if (skuArray != null && skuArray.size() > 0) {
                    for (int j = 0; j < skuArray.size(); ++j) {
                        JsonObject skuObj = skuArray.get(i).getAsJsonObject();
                        LimitDiscountSku sku = new LimitDiscountSku();
                        sku.setSkuId(skuObj.get("sku_id").getAsLong());
                        sku.setSalePrice(new BigDecimal(skuObj.get("sale_price").getAsDouble() / 100.0));
                        sku.setSaleStock(skuObj.get("sale_stock").getAsInt());
                        skuList.add(sku);
                    }
                    discountGoods.setLimitDiscountSkuList(skuList);
                }
                limitDiscountGoodsList.add(discountGoods);
            }
        }
        return limitDiscountGoodsList;
    }

    @Override
    public WxOpenResult updateLimitDiscountStatus(String appId, Long taskId, Integer status) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/limiteddiscount/update_status/access_token=" + this.getAuthorizerAccessToken(appId, false);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("task_id", (Number)taskId);
        jsonObject.addProperty("status", (Number)status);
        String response = this.getWxOpenService().post(url, jsonObject.toString());
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public GetShareCloudBaseEnvResponse getShareCloudBaseEnv(List<String> appids) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (String appId : appids) {
            jsonArray.add(appId);
        }
        jsonObject.add("appids", (JsonElement)jsonArray);
        String response = this.post("https://api.weixin.qq.com/componenttcb/batchgetenvid", jsonObject.toString());
        return (GetShareCloudBaseEnvResponse)WxOpenGsonBuilder.create().fromJson(response, GetShareCloudBaseEnvResponse.class);
    }

    @Override
    public GetTcbEnvListResponse getTcbEnvList() throws WxErrorException {
        String response = this.post("https://api.weixin.qq.com/componenttcb/describeenvs", new JsonObject().toString());
        return (GetTcbEnvListResponse)WxOpenGsonBuilder.create().fromJson(response, GetTcbEnvListResponse.class);
    }

    @Override
    public WxOpenResult changeTcbEnv(String env) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("env", env);
        String response = this.post("https://api.weixin.qq.com/tcb/modifyenv", jsonObject.toString());
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public ShareCloudBaseEnvResponse shareCloudBaseEnv(ShareCloudBaseEnvRequest request) throws WxErrorException {
        Gson gson = new Gson();
        String response = this.post("https://api.weixin.qq.com/componenttcb/batchshareenv", gson.toJson((Object)request));
        return (ShareCloudBaseEnvResponse)WxOpenGsonBuilder.create().fromJson(response, ShareCloudBaseEnvResponse.class);
    }

    @Override
    public WxOpenResult clearQuotaV2(String appid) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("appid", appid);
        jsonObject.addProperty("component_appid", this.getWxOpenConfigStorage().getComponentAppId());
        jsonObject.addProperty("appsecret", this.getWxOpenConfigStorage().getComponentAppSecret());
        String response = this.getWxOpenService().post("https://api.weixin.qq.com/cgi-bin/component/clear_quota/v2", jsonObject.toString());
        return WxOpenResult.fromJson(response);
    }

    @Override
    public WxOpenResult applySetOrderPathInfo(WxOpenMaApplyOrderPathInfo info) throws WxErrorException {
        Gson gson = new Gson();
        String response = this.post("https://api.weixin.qq.com/wxa/security/applysetorderpathinfo", gson.toJson((Object)info));
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    public WxOpenComponentServiceImpl(WxOpenService wxOpenService) {
        this.wxOpenService = wxOpenService;
    }
}

