/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.BaseMediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.open.api.WxOpenMaIcpService;
import me.chanjar.weixin.open.bean.CommonUploadMultiParam;
import me.chanjar.weixin.open.bean.icp.WxOpenApplyIcpFilingParam;
import me.chanjar.weixin.open.bean.icp.WxOpenApplyIcpFilingResult;
import me.chanjar.weixin.open.bean.icp.WxOpenIcpCreateIcpVerifyTaskResult;
import me.chanjar.weixin.open.bean.icp.WxOpenIcpEntranceInfoResult;
import me.chanjar.weixin.open.bean.icp.WxOpenIcpVerifyTaskResult;
import me.chanjar.weixin.open.bean.icp.WxOpenOnlineIcpOrderResult;
import me.chanjar.weixin.open.bean.icp.WxOpenQueryIcpCertificateTypeResult;
import me.chanjar.weixin.open.bean.icp.WxOpenQueryIcpDistrictCodeResult;
import me.chanjar.weixin.open.bean.icp.WxOpenQueryIcpNrlxTypesResult;
import me.chanjar.weixin.open.bean.icp.WxOpenQueryIcpServiceContentTypesResult;
import me.chanjar.weixin.open.bean.icp.WxOpenQueryIcpSubjectTypeResult;
import me.chanjar.weixin.open.bean.icp.WxOpenUploadIcpMediaParam;
import me.chanjar.weixin.open.bean.icp.WxOpenUploadIcpMediaResult;
import me.chanjar.weixin.open.bean.result.WxOpenResult;
import me.chanjar.weixin.open.executor.CommonUploadMultiRequestExecutor;
import me.chanjar.weixin.open.util.json.WxOpenGsonBuilder;

public class WxOpenMaIcpServiceImpl
implements WxOpenMaIcpService {
    private final WxMaService wxMaService;

    public WxOpenMaIcpServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }

    @Override
    public WxOpenIcpVerifyTaskResult queryIcpVerifyTask(String taskId) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("task_id", taskId);
        String response = this.wxMaService.post("https://api.weixin.qq.com/wxa/icp/query_icp_verifytask", params);
        return (WxOpenIcpVerifyTaskResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenIcpVerifyTaskResult.class);
    }

    @Override
    public WxOpenIcpCreateIcpVerifyTaskResult createIcpVerifyTask() throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/wxa/icp/create_icp_verifytask", "");
        return (WxOpenIcpCreateIcpVerifyTaskResult)WxMaGsonBuilder.create().fromJson(response, WxOpenIcpCreateIcpVerifyTaskResult.class);
    }

    @Override
    public WxOpenUploadIcpMediaResult uploadIcpMedia(WxOpenUploadIcpMediaParam param) throws WxErrorException {
        RequestExecutor<String, CommonUploadMultiParam> executor = CommonUploadMultiRequestExecutor.create(this.wxMaService.getRequestHttp());
        String response = (String)this.wxMaService.execute(executor, "https://api.weixin.qq.com/wxa/icp/upload_icp_media", (Object)param.toCommonUploadMultiParam());
        return (WxOpenUploadIcpMediaResult)WxMaGsonBuilder.create().fromJson(response, WxOpenUploadIcpMediaResult.class);
    }

    @Override
    public WxOpenResult cancelApplyIcpFiling() throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/wxa/icp/cancel_apply_icp_filing", "");
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenApplyIcpFilingResult applyIcpFiling(WxOpenApplyIcpFilingParam param) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/wxa/icp/apply_icp_filing", (Object)param);
        return (WxOpenApplyIcpFilingResult)WxMaGsonBuilder.create().fromJson(response, WxOpenApplyIcpFilingResult.class);
    }

    @Override
    public WxOpenResult cancelIcpFiling(Integer cancelType) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("cancel_type", (Number)cancelType);
        String response = this.wxMaService.post("https://api.weixin.qq.com/wxa/icp/cancel_icp_filing", params);
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenIcpEntranceInfoResult getIcpEntranceInfo() throws WxErrorException {
        String response = this.wxMaService.get("https://api.weixin.qq.com/wxa/icp/get_icp_entrance_info", null);
        return (WxOpenIcpEntranceInfoResult)WxMaGsonBuilder.create().fromJson(response, WxOpenIcpEntranceInfoResult.class);
    }

    @Override
    public WxOpenOnlineIcpOrderResult getOnlineIcpOrder() throws WxErrorException {
        String response = this.wxMaService.get("https://api.weixin.qq.com/wxa/icp/get_online_icp_order", null);
        return (WxOpenOnlineIcpOrderResult)WxMaGsonBuilder.create().fromJson(response, WxOpenOnlineIcpOrderResult.class);
    }

    @Override
    public WxOpenQueryIcpServiceContentTypesResult queryIcpServiceContentTypes() throws WxErrorException {
        String response = this.wxMaService.get("https://api.weixin.qq.com/wxa/icp/query_icp_service_content_types", null);
        return (WxOpenQueryIcpServiceContentTypesResult)WxMaGsonBuilder.create().fromJson(response, WxOpenQueryIcpServiceContentTypesResult.class);
    }

    @Override
    public WxOpenQueryIcpCertificateTypeResult queryIcpCertificateTypes() throws WxErrorException {
        String response = this.wxMaService.get("https://api.weixin.qq.com/wxa/icp/query_icp_certificate_types", null);
        return (WxOpenQueryIcpCertificateTypeResult)WxMaGsonBuilder.create().fromJson(response, WxOpenQueryIcpCertificateTypeResult.class);
    }

    @Override
    public WxOpenQueryIcpDistrictCodeResult queryIcpDistrictCode() throws WxErrorException {
        String response = this.wxMaService.get("https://api.weixin.qq.com/wxa/icp/query_icp_district_code", null);
        return (WxOpenQueryIcpDistrictCodeResult)WxMaGsonBuilder.create().fromJson(response, WxOpenQueryIcpDistrictCodeResult.class);
    }

    @Override
    public WxOpenQueryIcpNrlxTypesResult queryIcpNrlxTypes() throws WxErrorException {
        String response = this.wxMaService.get("https://api.weixin.qq.com/wxa/icp/query_icp_nrlx_types", null);
        return (WxOpenQueryIcpNrlxTypesResult)WxMaGsonBuilder.create().fromJson(response, WxOpenQueryIcpNrlxTypesResult.class);
    }

    @Override
    public WxOpenQueryIcpSubjectTypeResult queryIcpSubjectTypes() throws WxErrorException {
        String response = this.wxMaService.get("https://api.weixin.qq.com/wxa/icp/query_icp_subject_types", null);
        return (WxOpenQueryIcpSubjectTypeResult)WxMaGsonBuilder.create().fromJson(response, WxOpenQueryIcpSubjectTypeResult.class);
    }

    @Override
    public File getIcpMedia(String mediaId) throws WxErrorException {
        try {
            RequestExecutor executor = BaseMediaDownloadRequestExecutor.create((RequestHttp)this.wxMaService.getRequestHttp(), (File)Files.createTempDirectory("wxma", new FileAttribute[0]).toFile());
            return (File)this.wxMaService.execute(executor, "https://api.weixin.qq.com/wxa/icp/get_icp_media", (Object)("media_id=" + mediaId));
        }
        catch (IOException e) {
            throw new WxErrorException(WxError.builder().errorMsg(e.getMessage()).build(), (Throwable)e);
        }
    }
}

