/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.http;

import com.dropbox.core.http.HttpRequestor;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.Util;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okio.Buffer;
import okio.BufferedSink;
import okio.Source;

public class OkHttpRequestor
extends HttpRequestor {
    public static final OkHttpRequestor INSTANCE = new OkHttpRequestor(OkHttpRequestor.defaultOkHttpClient());
    private final OkHttpClient client;

    private static OkHttpClient defaultOkHttpClient() {
        OkHttpClient client = new OkHttpClient();
        client.setConnectTimeout(DEFAULT_CONNECT_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        client.setReadTimeout(DEFAULT_READ_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        client.setWriteTimeout(DEFAULT_READ_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        return client;
    }

    public OkHttpRequestor(OkHttpClient client) {
        this.client = client;
    }

    @Override
    public HttpRequestor.Response doGet(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        Request.Builder builder = new Request.Builder().get().url(url);
        OkHttpRequestor.toOkHttpHeaders(headers, builder);
        Response response = this.client.newCall(builder.build()).execute();
        Map<String, List<String>> responseHeaders = OkHttpRequestor.fromOkHttpHeaders(response.headers());
        return new HttpRequestor.Response(response.code(), response.body().byteStream(), responseHeaders);
    }

    @Override
    public BufferUploader startPost(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        return this.startUpload(url, headers, "POST");
    }

    @Override
    public BufferUploader startPut(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        return this.startUpload(url, headers, "PUT");
    }

    private BufferUploader startUpload(String url, Iterable<HttpRequestor.Header> headers, String method) {
        Buffer requestBuffer = new Buffer();
        BufferRequestBody requestBody = new BufferRequestBody(requestBuffer, null);
        Request.Builder builder = new Request.Builder().method(method, (RequestBody)requestBody).url(url);
        OkHttpRequestor.toOkHttpHeaders(headers, builder);
        return new BufferUploader(this.client.newCall(builder.build()), requestBuffer);
    }

    private static void toOkHttpHeaders(Iterable<HttpRequestor.Header> headers, Request.Builder builder) {
        for (HttpRequestor.Header header : headers) {
            builder.addHeader(header.getKey(), header.getValue());
        }
    }

    private static Map<String, List<String>> fromOkHttpHeaders(Headers headers) {
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>(headers.size());
        for (String name : headers.names()) {
            responseHeaders.put(name, headers.values(name));
        }
        return responseHeaders;
    }

    private static class BufferRequestBody
    extends RequestBody {
        private Buffer buffer;
        private MediaType mediaType;

        private BufferRequestBody(Buffer buffer, MediaType mediaType) {
            this.buffer = buffer;
            this.mediaType = mediaType;
        }

        public MediaType contentType() {
            return this.mediaType;
        }

        public long contentLength() {
            return this.buffer.size();
        }

        public void writeTo(BufferedSink sink) throws IOException {
            try {
                sink.writeAll((Source)this.buffer);
            }
            finally {
                Util.closeQuietly((Closeable)this.buffer);
            }
        }
    }

    private static class BufferUploader
    extends HttpRequestor.Uploader {
        private final Call call;
        private final Buffer requestBuffer;

        public BufferUploader(Call call, Buffer requestBuffer) {
            super(requestBuffer.outputStream());
            this.call = call;
            this.requestBuffer = requestBuffer;
        }

        @Override
        public void close() {
            this.requestBuffer.clear();
        }

        @Override
        public void abort() {
            this.call.cancel();
        }

        @Override
        public HttpRequestor.Response finish() throws IOException {
            Response response = this.call.execute();
            Map responseHeaders = OkHttpRequestor.fromOkHttpHeaders(response.headers());
            return new HttpRequestor.Response(response.code(), response.body().byteStream(), responseHeaders);
        }
    }
}

