/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.async;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class LaunchResultBase {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    private final Tag tag;
    private final String asyncJobIdValue;

    private LaunchResultBase(Tag tag, String asyncJobIdValue) {
        this.tag = tag;
        this.asyncJobIdValue = asyncJobIdValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isAsyncJobId() {
        return this.tag == Tag.ASYNC_JOB_ID;
    }

    public static LaunchResultBase asyncJobId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 1) {
            throw new IllegalArgumentException("String is shorter than 1");
        }
        return new LaunchResultBase(Tag.ASYNC_JOB_ID, value);
    }

    public String getAsyncJobIdValue() {
        if (this.tag != Tag.ASYNC_JOB_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.ASYNC_JOB_ID, but was Tag." + this.tag.name());
        }
        return this.asyncJobIdValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.asyncJobIdValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LaunchResultBase) {
            LaunchResultBase other = (LaunchResultBase)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case ASYNC_JOB_ID: {
                    return this.asyncJobIdValue == other.asyncJobIdValue || this.asyncJobIdValue.equals(other.asyncJobIdValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<LaunchResultBase, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(LaunchResultBase.class, Deserializer.getTagMapping(), null, new Class[0]);
        }

        @Override
        public LaunchResultBase deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case ASYNC_JOB_ID: {
                    String value = null;
                    Deserializer.expectField(_p, "async_job_id");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return LaunchResultBase.asyncJobId(value);
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("async_job_id", Tag.ASYNC_JOB_ID);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<LaunchResultBase> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(LaunchResultBase.class, new Class[0]);
        }

        @Override
        public void serialize(LaunchResultBase value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case ASYNC_JOB_ID: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "async_job_id");
                    g.writeObjectField("async_job_id", value.asyncJobIdValue);
                    g.writeEndObject();
                }
            }
        }
    }

    public static enum Tag {
        ASYNC_JOB_ID;

    }
}

